/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.AcDictionary;
import dmg.cells.services.login.user.AgingHash;
import dmg.cells.services.login.user.DatabaseException;
import dmg.cells.services.login.user.UserRelationable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AclDb {
    private File _aclDir = null;
    private AgingHash _hash = new AgingHash(20);

    public AclDb(File aclDir) {
        if (!aclDir.isDirectory()) {
            throw new IllegalArgumentException("Not a acl DB(not a dir)aclDir \"" + aclDir.getPath() + " " + aclDir.getName() + "\"");
        }
        this._aclDir = aclDir;
    }

    private void putAcl(String aclName, AclItem item) throws DatabaseException {
        this._storeAcl(aclName, item);
        this._hash.put(aclName, item);
    }

    private AclItem getAcl(String aclName) throws NoSuchElementException {
        AclItem item = (AclItem)this._hash.get(aclName);
        if (item != null) {
            return item.cloneMe();
        }
        return this._loadAcl(aclName);
    }

    private void _storeAcl(String aclName, AclItem item) throws DatabaseException {
        File file = new File(this._aclDir, "." + aclName);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(file));
        }
        catch (IOException ioe) {
            throw new DatabaseException("Can't create : " + aclName);
        }
        String inherit = item.getInheritance();
        if (inherit != null) {
            pw.println("$=" + inherit);
        }
        Enumeration e = item.getUsers();
        while (e.hasMoreElements()) {
            String user = e.nextElement().toString();
            Boolean access = item.getUserAccess(user);
            pw.println(user + "=" + (access != false ? "allowed" : "denied"));
        }
        pw.close();
        file.renameTo(new File(this._aclDir, aclName));
    }

    private AclItem _loadAcl(String aclName) throws NoSuchElementException {
        File file = new File(this._aclDir, aclName);
        if (!file.exists()) {
            throw new NoSuchElementException("Acl  not found : " + aclName);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            throw new NoSuchElementException("Not found " + file);
        }
        String line = null;
        StringTokenizer st = null;
        AclItem item = new AclItem(aclName);
        String user = null;
        String access = null;
        try {
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, "=");
                user = st.nextToken();
                access = st.nextToken();
                if (user.equals("$")) {
                    item.setInheritance(access);
                    continue;
                }
                if (access.equals("allowed")) {
                    item.addAccess(user, true);
                    continue;
                }
                if (!access.equals("denied")) continue;
                item.addAccess(user, false);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new NoSuchElementException("Syntax error in " + file);
        }
        catch (IOException ioe) {
            throw new NoSuchElementException("IOError on " + file);
        }
        catch (Exception ee) {
            throw new NoSuchElementException("IOError on " + file);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        return item;
    }

    public synchronized void createAclItem(String aclItem) throws DatabaseException {
        this.putAcl(aclItem, new AclItem(aclItem));
    }

    public synchronized void removeAclItem(String aclItem) throws DatabaseException {
        this._hash.remove(aclItem);
        new File(this._aclDir, aclItem).delete();
    }

    public synchronized void setInheritance(String aclItem, String inheritsFrom) throws DatabaseException {
        AclItem item = this.getAcl(aclItem);
        item.setInheritance(inheritsFrom);
        this.putAcl(aclItem, item);
    }

    public synchronized void addAllowed(String aclItem, String user) throws DatabaseException {
        AclItem item = this.getAcl(aclItem);
        item.addAccess(user, true);
        this.putAcl(aclItem, item);
    }

    public synchronized void addDenied(String aclItem, String user) throws DatabaseException {
        AclItem item = this.getAcl(aclItem);
        item.addAccess(user, false);
        this.putAcl(aclItem, item);
    }

    public synchronized void removeUser(String aclItem, String user) throws DatabaseException {
        AclItem item = this.getAcl(aclItem);
        item.removeUser(user);
        this.putAcl(aclItem, item);
    }

    public AcDictionary getPermissions(String aclName, boolean resolve) throws NoSuchElementException {
        return resolve ? this._fullResolveAclItem(aclName) : this.getAcl(aclName);
    }

    private AclItem _fullResolveAclItem(String aclItem) throws NoSuchElementException {
        if (aclItem.startsWith(".") || aclItem.endsWith(".")) {
            throw new NoSuchElementException("Illegal formated acl : " + aclItem);
        }
        int f = aclItem.indexOf(46);
        int l = aclItem.lastIndexOf(46);
        String[] array = null;
        if (f < 0) {
            array = new String[]{aclItem, "*.*.*"};
        } else if (f == l) {
            String a = aclItem.substring(0, f);
            String e = aclItem.substring(l + 1);
            array = new String[]{aclItem, a + "." + e + ".*", a + ".*.*", "*.*.*"};
        } else {
            int i;
            if (f + 1 == l) {
                throw new NoSuchElementException("Illegal formated acl : " + aclItem);
            }
            String className = aclItem.substring(0, f);
            String instanceName = aclItem.substring(f + 1, l);
            String actionName = aclItem.substring(l + 1);
            StringTokenizer st = new StringTokenizer(instanceName, ".");
            String[] mm = new String[st.countTokens()];
            int firstStar = mm.length;
            for (int i2 = 0; i2 < mm.length; ++i2) {
                mm[i2] = st.nextToken();
                if (firstStar != mm.length || !mm[i2].equals("*")) continue;
                firstStar = i2;
            }
            String[] mask = new String[firstStar + 1];
            int k = 0;
            for (i = firstStar; i >= 0; --i) {
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < mm.length; ++j) {
                    if (j >= i) {
                        sb.append("*.");
                        continue;
                    }
                    sb.append(mm[j]).append(".");
                }
                mask[k++] = sb.toString();
            }
            k = 0;
            if (className.equals("*")) {
                array = new String[1];
            } else if (actionName.equals("*") && instanceName.equals("*")) {
                array = new String[2];
                array[k++] = className + ".*.*";
            } else if (actionName.equals("*")) {
                array = new String[2 + mask.length];
                for (i = 0; i < mask.length; ++i) {
                    array[k++] = className + "." + mask[i] + "*";
                }
                array[k++] = className + ".*.*";
            } else if (instanceName.equals("*")) {
                array = new String[3];
                array[k++] = className + ".*." + actionName;
                array[k++] = className + ".*.*";
            } else {
                array = new String[2 + 2 * mask.length];
                for (i = 0; i < mask.length; ++i) {
                    array[k++] = className + "." + mask[i] + actionName;
                    array[k++] = className + "." + mask[i] + "*";
                }
                array[k++] = className + ".*.*";
            }
            array[k++] = "*.*.*";
        }
        AclItem currentItem = null;
        for (int i = 0; i < array.length; ++i) {
            if (currentItem == null) {
                try {
                    currentItem = this._resolveAclItem(array[i]);
                }
                catch (NoSuchElementException ee) {}
                continue;
            }
            try {
                AclItem nextItem = this._resolveAclItem(array[i]);
                Enumeration e = nextItem.getUsers();
                while (e.hasMoreElements()) {
                    String user = (String)e.nextElement();
                    currentItem.merge(user, nextItem.getUserAccess(user));
                }
                continue;
            }
            catch (NoSuchElementException ee) {
                // empty catch block
            }
        }
        if (currentItem == null) {
            throw new NoSuchElementException("Not found : " + aclItem);
        }
        return currentItem;
    }

    private AclItem _resolveAclItem(String aclItem) throws NoSuchElementException {
        AclItem result;
        AclItem cursor = result = this.getAcl(aclItem);
        String inherited = null;
        int i = 0;
        for (i = 0; i < 200 && (inherited = cursor.getInheritance()) != null; ++i) {
            cursor = this.getAcl(inherited);
            Enumeration e = cursor.getUsers();
            while (e.hasMoreElements()) {
                String user = (String)e.nextElement();
                result.merge(user, cursor.getUserAccess(user));
            }
        }
        if (i == 200) {
            throw new NoSuchElementException("Infinit inheritance loop detected");
        }
        result.setInheritance(null);
        return result;
    }

    public synchronized boolean check(String aclItem, String user, UserRelationable relations) {
        try {
            AclItem item = this._fullResolveAclItem(aclItem);
            return this._check(item, user, relations);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean _check(AclItem item, String user, UserRelationable relations) throws NoSuchElementException {
        Boolean ok = item.getUserAccess(user);
        if (ok != null) {
            return ok;
        }
        Vector<String> v = new Vector<String>();
        Boolean x = null;
        v.addElement(user);
        for (int i = 0; i < v.size(); ++i) {
            user = (String)v.elementAt(i);
            x = item.getUserAccess(user);
            if (x != null) {
                if (!x.booleanValue()) continue;
                return true;
            }
            Enumeration e = relations.getParentsOf(user);
            while (e.hasMoreElements()) {
                v.addElement((String)e.nextElement());
            }
        }
        return false;
    }

    private class AclItem
    implements AcDictionary {
        private String _name = null;
        private Hashtable _users = new Hashtable();
        private String _inherits = null;

        private AclItem(String name) {
            this._name = name;
        }

        private void setInheritance(String aclItem) {
            this._inherits = aclItem;
        }

        private void addAccess(String user, boolean access) {
            this._users.put(user, access);
        }

        private Enumeration getUsers() {
            return this._users.keys();
        }

        private void removeUser(String user) {
            this._users.remove(user);
        }

        private Boolean getUserAccess(String user) throws NoSuchElementException {
            return (Boolean)this._users.get(user);
        }

        private void merge(String user, Boolean access) {
            if (this._users.get(user) == null) {
                this._users.put(user, access);
            }
        }

        @Override
        public Enumeration getPrincipals() {
            return this._users.keys();
        }

        @Override
        public boolean getPermission(String principal) {
            Boolean ok = (Boolean)this._users.get(principal);
            if (ok == null) {
                throw new NoSuchElementException(principal);
            }
            return ok;
        }

        @Override
        public boolean isResolved() {
            return this._inherits == null;
        }

        @Override
        public String getInheritance() {
            return this._inherits;
        }

        public AclItem cloneMe() {
            AclItem item = new AclItem(this._name);
            item._users = (Hashtable)this._users.clone();
            item._inherits = this._inherits;
            return item;
        }
    }
}

