/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.AcDictionary;
import dmg.cells.services.login.user.AclDb;
import dmg.cells.services.login.user.FileUserRelation;
import dmg.cells.services.login.user.InMemoryUserRelation;
import dmg.cells.services.login.user.UserAdminCommands;
import dmg.cells.services.login.user.UserMetaDb;
import dmg.cells.services.login.user.UserMetaDictionary;
import dmg.cells.services.login.user.UserRelationable;
import dmg.util.Args;
import dmg.util.AuthorizedArgs;
import dmg.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class AclCommander
extends CommandInterpreter {
    private AclDb _aclDb = null;
    private UserRelationable _userDb = null;
    private UserMetaDb _userMetaDb = null;
    private String _user = "none";
    public String hh_id = "[<newUserName>]";
    public String hh_ls_principal = "<principalName>";
    public String hh_meta_set_principal = "<principalName> <key>=<value> [...]";
    public String hh_rel_create_group = "<group>";
    public String hh_rel_rm_group = "<group>";
    public String hh_rel_ls_group = "<group>";
    public String hh_rel_ls_groups = "";
    public String hh_rel_add_user = "<group> <user>";
    public String hh_rel_rm_user = "<group> <user>";
    public String hh_acl_create_acl = "<aclName>";
    public String hh_acl_ls_acl = "<aclName> -resolve";
    public String hh_acl_rm_acl = "<aclName>";
    public String hh_acl_set_inherit = "<aclName> <aclNameFrom>";
    public String hh_acl_add_allowed = "<acl> <user>";
    public String hh_acl_add_denied = "<acl> <user>";
    public String hh_acl_rm_access = "<acl> <user>";
    public String hh_check = "<acl> <user>";

    public String ac_hello_$_1(Args args) throws Exception {
        throw new NoSuchElementException("otto");
    }

    public AclCommander(String[] args) throws Exception {
        if (args.length > 0) {
            this._aclDb = new AclDb(new File(args[0], "acls"));
            this._userDb = new InMemoryUserRelation(new FileUserRelation(new File(args[0], "relations")));
            this._userMetaDb = new UserMetaDb(new File(args[0], "meta"));
        }
        UserAdminCommands uac = new UserAdminCommands(this._userDb, this._aclDb, this._userMetaDb);
        this.addCommandListener(uac);
    }

    public String ac_id_$_0_1(Args args) throws Exception {
        this.checkDatabase();
        if (args.argc() == 0) {
            return this._user + "\n";
        }
        this._user = args.argv(0);
        return "";
    }

    public String ac_ls_principal_$_1(Args args) throws Exception {
        if (this._userMetaDb == null) {
            throw new Exception("UserMetaDb not open");
        }
        UserMetaDictionary dict = this._userMetaDb.getDictionary(args.argv(0));
        Enumeration e = dict.keys();
        while (e.hasMoreElements()) {
            String user = (String)e.nextElement();
            System.out.println(user + " -> " + dict.valueOf(user));
        }
        return "";
    }

    public String ac_meta_set_principal_$_1_99(Args args) throws Exception {
        if (this._userMetaDb == null) {
            throw new Exception("UserMetaDb not open");
        }
        StringTokenizer st = null;
        String key = null;
        String value = null;
        for (int i = 1; i < args.argc(); ++i) {
            st = new StringTokenizer(args.argv(i), "=");
            key = st.nextToken();
            try {
                value = st.nextToken();
            }
            catch (Exception ee) {
                value = "";
            }
            this._userMetaDb.setAttribute(args.argv(0), key, value);
        }
        return "";
    }

    public String ac_meta_create_principal_$_1(Args args) throws Exception {
        if (this._userMetaDb == null) {
            throw new Exception("UserMetaDb not open");
        }
        if (args.hasOption("group")) {
            this._userMetaDb.createGroup(args.argv(0));
        } else {
            this._userMetaDb.createUser(args.argv(0));
        }
        return "";
    }

    public String ac_meta_rm_principal_$_1(Args args) throws Exception {
        if (this._userMetaDb == null) {
            throw new Exception("UserMetaDb not open");
        }
        this._userMetaDb.removePrincipal(args.argv(0));
        return "";
    }

    public String ac_rel_create_group_$_1(Args args) throws Exception {
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        this._userDb.createContainer(args.argv(0));
        return "";
    }

    public String ac_rel_rm_group_$_1(Args args) throws Exception {
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        this._userDb.removeContainer(args.argv(0));
        return "";
    }

    public String ac_rel_ls_group_$_1(Args args) throws Exception {
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        Enumeration e = this._userDb.getElementsOf(args.argv(0));
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement().toString());
        }
        return "";
    }

    public String ac_rel_ls_groups(Args args) throws Exception {
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        Enumeration e = this._userDb.getContainers();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement().toString());
        }
        return "";
    }

    public String ac_rel_add_user_$_2(Args args) throws Exception {
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        this._userDb.addElement(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_rel_rm_user_$_2(Args args) throws Exception {
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        this._userDb.removeElement(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_acl_create_acl_$_1(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        this._aclDb.createAclItem(args.argv(0));
        return "";
    }

    public String ac_acl_ls_acl_$_1(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        boolean resolve = args.hasOption("resolve");
        AcDictionary dict = this._aclDb.getPermissions(args.argv(0), resolve);
        Enumeration e = dict.getPrincipals();
        String inherits = dict.getInheritance();
        if (inherits == null) {
            System.out.println("<resolved>");
        } else {
            System.out.println("<inherits=" + inherits + ">");
        }
        while (e.hasMoreElements()) {
            String user = (String)e.nextElement();
            System.out.println(user + " -> " + dict.getPermission(user));
        }
        return "";
    }

    public String ac_acl_rm_acl_$_1(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        this._aclDb.removeAclItem(args.argv(0));
        return "";
    }

    public String ac_acl_set_inherit_$_2(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        this._aclDb.setInheritance(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_acl_add_allowed_$_2(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        this._aclDb.addAllowed(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_acl_add_denied_$_2(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        this._aclDb.addDenied(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_acl_rm_access_$_2(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        this._aclDb.removeUser(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_check_$_2(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        if (this._userDb == null) {
            throw new Exception("UserDb not open");
        }
        boolean ok = this._aclDb.check(args.argv(0), args.argv(1), this._userDb);
        return (ok ? "Allowed" : "Denied") + "\n";
    }

    private void checkDatabase() throws Exception {
        if (this._userMetaDb != null && this._aclDb != null && this._userDb != null) {
            return;
        }
        throw new Exception("Not all databases are open");
    }

    public Object exec(String line) throws Exception {
        if (this._user.equals("none")) {
            return this.command(new Args(line));
        }
        return this.command(new AuthorizedArgs(this._user, line));
    }

    public static void main(String[] args) throws Exception {
        AclCommander commander = new AclCommander(args);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        while (true) {
            block7: {
                System.out.print("acl > ");
                try {
                    line = br.readLine();
                    if (line == null) {
                    }
                    break block7;
                }
                catch (Exception ioe) {
                    System.err.println("Input problem : " + ioe);
                }
                break;
            }
            Args a = new Args(line);
            if (a.argc() < 1) continue;
            if (a.argv(0).equals("exit")) break;
            try {
                System.out.print(commander.exec(line));
            }
            catch (NoSuchElementException nse) {
                System.err.println("Problem : " + nse);
            }
            catch (Exception e) {
                System.err.println("Problem : " + e);
            }
        }
        System.exit(0);
    }
}

