/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.services.login.user.AclDb;
import dmg.cells.services.login.user.AclPermissionException;
import dmg.cells.services.login.user.FileUserRelation;
import dmg.cells.services.login.user.InMemoryUserRelation;
import dmg.cells.services.login.user.UserAdminCommands;
import dmg.cells.services.login.user.UserMetaDb;
import dmg.cells.services.login.user.UserMetaDictionary;
import dmg.cells.services.login.user.UserRelationable;
import dmg.security.digest.Crypt;
import dmg.util.Args;
import dmg.util.Authorizable;
import dmg.util.CommandException;
import dmg.util.UserPasswords;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(AclCell.class);
    private String _cellName;
    private CellNucleus _nucleus;
    private Args _args;
    private AclDb _aclDb = null;
    private UserRelationable _userDb = null;
    private UserMetaDb _userMetaDb = null;
    private UserPasswords _sysPassword = null;
    private UserPasswords _egPassword = null;
    private Crypt _crypt = new Crypt();
    private static final String DUMMY_ADMIN = "5t2Hw7lNqVock";
    public String hh_set_passwd = "[-user=<userName>] [-old=<oldPasswd>] newPswd verifyPswd";

    public AclCell(String name, String argString) throws Throwable {
        super(name, argString, false);
        this._cellName = name;
        this._args = this.getArgs();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <dbPath>");
            }
            File dbBase = new File(this._args.argv(0));
            this._aclDb = new AclDb(new File(dbBase, "acls"));
            this._userDb = new InMemoryUserRelation(new FileUserRelation(new File(dbBase, "relations")));
            this._userMetaDb = new UserMetaDb(new File(dbBase, "meta"));
            UserAdminCommands uac = new UserAdminCommands(this._userDb, this._aclDb, this._userMetaDb);
            this.addCommandListener(uac);
            this.setCommandExceptionEnabled(true);
            String tmp = null;
            tmp = this._args.getOpt("syspassword");
            if (tmp != null) {
                this._sysPassword = new UserPasswords(new File(tmp));
                _log.info("using as SystemPasswordfile : " + tmp);
            }
            if ((tmp = this._args.getOpt("egpassword")) != null) {
                this._egPassword = new UserPasswords(new File(tmp));
                _log.info("using as EgPasswordfile : " + tmp);
            }
        }
        catch (Throwable e) {
            _log.warn("Exception while <init> : " + e, e);
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Object answer;
        block11: {
            Object obj = msg.getMessageObject();
            answer = "PANIX";
            try {
                _log.info("Message type : " + obj.getClass());
                if (obj instanceof Object[] && ((Object[])obj).length >= 3 && ((Object[])obj)[0].equals("request")) {
                    Object[] request = (Object[])obj;
                    String user = request[1] == null ? "unknown" : (String)request[1];
                    String command = (String)request[2];
                    _log.info(">" + command + "< request from " + user);
                    try {
                        if (command.equals("check-password")) {
                            answer = this.acl_check_password(request);
                            break block11;
                        }
                        if (command.equals("check-permission")) {
                            answer = this.acl_check_permission(request);
                            break block11;
                        }
                        if (command.equals("get-metainfo")) {
                            answer = this.acl_get_metainfo(request);
                            break block11;
                        }
                        throw new Exception("Command not found : " + command);
                    }
                    catch (Exception xe) {
                        throw new Exception("Problem : " + xe);
                    }
                }
                String r = "Illegal message object received from : " + msg.getSourcePath();
                _log.warn(r);
                throw new Exception(r);
            }
            catch (Exception iex) {
                answer = iex;
            }
        }
        if (answer instanceof Object[]) {
            ((Object[])answer)[0] = "response";
        }
        msg.revertDirection();
        msg.setMessageObject(answer);
        try {
            this.sendMessage(msg);
        }
        catch (Exception ioe) {
            _log.warn("Can't send acl_response : " + ioe, (Throwable)ioe);
        }
    }

    private Object acl_get_metainfo(Object[] request) throws Exception {
        int i;
        if (request.length < 5 || request[3] == null || request[4] == null) {
            throw new IllegalArgumentException("Not enough or illegal arguments for 'check-password'");
        }
        String userName = request[3].toString();
        UserMetaDictionary dict = this._userMetaDb.getDictionary(userName);
        if (dict == null) {
            throw new IllegalArgumentException("No such user : " + userName);
        }
        StringTokenizer st = new StringTokenizer(request[4].toString(), ",");
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(dict.valueOf(st.nextToken()));
        }
        Object[] r = new Object[5 + result.size()];
        for (i = 0; i < 5; ++i) {
            r[i] = (String)request[i];
        }
        for (i = 5; i < r.length; ++i) {
            r[i] = (String)result.get(i - 5);
        }
        return r;
    }

    private Object acl_check_password(Object[] request) throws Exception {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-password'");
        }
        Object[] response = new Object[6];
        for (int i = 0; i < 5; ++i) {
            response[i] = request[i];
        }
        response[1] = request[3];
        String userName = (String)request[3];
        String password = (String)request[4];
        response[5] = this.matchPassword(userName, password);
        return response;
    }

    private Object acl_check_permission(Object[] request) throws Exception {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-permission'");
        }
        Object[] response = new Object[6];
        for (int i = 0; i < 5; ++i) {
            response[i] = request[i];
        }
        response[1] = request[3];
        String userName = (String)request[3];
        String acl = (String)request[4];
        response[5] = this.checkPermission(userName, acl);
        return response;
    }

    private boolean checkPermission(String user, String acl) {
        if (user.equals("admin")) {
            return true;
        }
        try {
            if (this._aclDb.check(acl, user, this._userDb)) {
                return true;
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
        try {
            if (this._aclDb.check("super.access", user, this._userDb)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean matchPassword(String userName, String password) {
        String pswd = null;
        this.updatePassword();
        boolean answer = false;
        try {
            if (userName.equals("admin")) {
                if (!(this._sysPassword != null && (pswd = this._sysPassword.getPassword(userName)) != null || this._egPassword != null && (pswd = this._egPassword.getPassword(userName)) != null)) {
                    pswd = DUMMY_ADMIN;
                }
                return this._crypt.crypt(pswd, password).equals(pswd);
            }
            UserMetaDictionary dict = this._userMetaDb.getDictionary(userName);
            if (dict == null) {
                return false;
            }
            String dis = dict.valueOf("login");
            if (dis != null && dis.equals("no")) {
                return false;
            }
            if (!(this._sysPassword != null && (pswd = this._sysPassword.getPassword(userName)) != null || this._egPassword != null && (pswd = this._egPassword.getPassword(userName)) != null)) {
                return false;
            }
            return this._crypt.crypt(pswd, password).equals(pswd);
        }
        catch (Throwable t) {
            _log.warn("Found : " + t);
            return false;
        }
    }

    private void updatePassword() {
        try {
            if (this._sysPassword != null) {
                this._sysPassword.update();
            }
        }
        catch (Exception ee) {
            _log.warn("Updating failed : " + this._sysPassword);
        }
        try {
            if (this._egPassword != null) {
                this._egPassword.update();
            }
        }
        catch (Exception ee) {
            _log.warn("Updating failed : " + this._egPassword);
        }
    }

    private void checkPermission(Args args, String acl) throws Exception {
        if (!(args instanceof Authorizable)) {
            throw new AclPermissionException("Command not authorizable");
        }
        String user = ((Authorizable)((Object)args)).getAuthorizedPrincipal();
        if (user.equals("admin")) {
            return;
        }
        try {
            if (this._aclDb.check("super.access", user, this._userDb)) {
                return;
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
        if (!this._aclDb.check(acl, user, this._userDb)) {
            throw new AclPermissionException("Acl >" + acl + "< negative for " + user);
        }
    }

    public String ac_interrupted(Args args) throws CommandException {
        return "\n";
    }

    public String ac_set_passwd_$_2(Args args) throws Exception {
        String pswd2;
        if (this._egPassword == null) {
            throw new AclPermissionException("No private password file found");
        }
        if (!(args instanceof Authorizable)) {
            throw new AclPermissionException("Command not authorizable");
        }
        String pswd1 = args.argv(0);
        if (!pswd1.equals(pswd2 = args.argv(1))) {
            throw new IllegalArgumentException("pswd1 doesn't match pswd2");
        }
        String auth = ((Authorizable)((Object)args)).getAuthorizedPrincipal();
        String user = args.getOpt("user");
        user = user == null ? auth : user;
        String old = args.getOpt("old");
        String acl = "user." + user + ".setpassword";
        String[] record = null;
        if (!auth.equals("admin") && !this._aclDb.check(acl, auth, this._userDb)) {
            if (auth.equals(user)) {
                if (old == null) {
                    throw new IllegalArgumentException("-old=<oldPassword> option missing");
                }
            } else {
                throw new AclPermissionException("Acl >" + acl + "< negative for " + auth);
            }
            pswd2 = this._egPassword.getPassword(user);
            if (pswd2 == null) {
                throw new IllegalArgumentException("User not found in private passwd file");
            }
            if (!this._crypt.crypt(pswd2, old).equals(pswd2)) {
                throw new IllegalArgumentException("Old password doesn't match");
            }
            record = this._egPassword.getRecord(user);
            if (record == null) {
                throw new IllegalArgumentException("User " + user + " doesn't exist");
            }
        } else {
            record = this._egPassword.getRecord(user);
            if (record == null) {
                record = new String[]{user, this._crypt.crypt(user.substring(0, 2), pswd1)};
            }
        }
        this._egPassword.addRecord(record);
        this._egPassword.commit();
        return "";
    }
}

