/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.services.login.UserPrivileges;
import dmg.util.cdb.CdbContainable;
import dmg.util.cdb.CdbElementable;
import dmg.util.cdb.CdbFileRecordHandle;

public class UserHandle
extends CdbFileRecordHandle {
    private CdbContainable _container;
    private String _name;

    public UserHandle(String name, CdbContainable container, CdbElementable element) {
        super(name, container, element);
        this._container = container;
        this._name = name;
    }

    public void setEmail(String name) {
        this.setAttribute("e-mail", name);
    }

    public void setPassword(String password) {
        this.setAttribute("password", password);
    }

    public void setAllowed(String[] allowedList) {
        this.setAttribute("allowed", allowedList);
    }

    public void setDenied(String[] deniedList) {
        this.setAttribute("denied", deniedList);
    }

    public void addParent(String parent) {
        this.addListItem("parents", parent, true);
    }

    public String[] getParents() {
        return (String[])this.getAttribute("parents");
    }

    public String[] getChilds() {
        return (String[])this.getAttribute("childs");
    }

    public void removeParent(String parent) {
        this.removeListItem("parents", parent);
    }

    public void addChild(String child) {
        this.addListItem("childs", child, true);
    }

    public void removeChild(String child) {
        this.removeListItem("childs", child);
    }

    public UserPrivileges getUserPrivileges() {
        return new UserPrivileges(this._name, (String[])this.getAttribute("allowed"), (String[])this.getAttribute("denied"));
    }

    public void addAllowed(String allowed) {
        this.addListItem("allowed", allowed, true);
        this.removeListItem("denied", allowed);
    }

    public void removeAllowed(String allowed) {
        this.removeListItem("allowed", allowed);
    }

    public void addDenied(String denied) {
        this.addListItem("denied", denied, true);
        this.removeListItem("allowed", denied);
    }

    public void removeDenied(String denied) {
        this.removeListItem("denied", denied);
    }

    public String getPassword() {
        return (String)this.getAttribute("password");
    }

    public String getEmail() {
        return (String)this.getAttribute("e-mail");
    }

    public String getMode() {
        return (String)this.getAttribute("mode");
    }

    public boolean isGroup() {
        return this.getMode().equals("group");
    }

    public String[] getAllowed() {
        return (String[])this.getAttribute("allowed");
    }

    public String[] getDenied() {
        return (String[])this.getAttribute("allowed");
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            int i;
            this.open(1);
            if (this.isGroup()) {
                sb.append("Group   : " + this.getName() + "\n");
                String[] childs = this.getChilds();
                if (childs.length > 0) {
                    sb.append("Members : \n");
                    for (i = 0; i < childs.length; ++i) {
                        sb.append("          " + childs[i] + "\n");
                    }
                }
            } else {
                sb.append("User    : " + this.getName() + "\n");
            }
            sb.append("e-mail  : " + this.getEmail() + "\n");
            sb.append("passwd  : " + this.getPassword() + "\n");
            String[] parents = this.getParents();
            if (parents.length > 0) {
                sb.append("Parents : \n");
                for (i = 0; i < parents.length; ++i) {
                    sb.append("          " + parents[i] + "\n");
                }
            }
            sb.append("prives  : \n");
            sb.append(this.getUserPrivileges().toString());
            this.close(8);
        }
        catch (Exception e) {
            sb.append("PANIC : Exception " + e + "\n");
        }
        return sb.toString();
    }
}

