/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.collect.Maps;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.cells.services.login.SshSAuth_A;
import dmg.cells.services.login.StreamEngineFactory;
import dmg.cells.services.login.TelnetSAuth_A;
import dmg.util.Args;
import dmg.util.KeepAliveListener;
import dmg.util.StreamEngine;
import dmg.util.UserValidatable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager
extends CellAdapter
implements UserValidatable {
    private final CellNucleus _nucleus;
    private final Args _args;
    private final ListenThread _listenThread;
    private int _connectionDeniedCounter = 0;
    private String _locationManager = null;
    private int _loginCounter = 0;
    private int _loginFailures = 0;
    private boolean _sending = false;
    private Class<?> _loginClass = Object.class;
    private Constructor<?> _loginConstructor = null;
    private Constructor<?> _authConstructor = null;
    private Method _loginPrintMethod = null;
    private int _maxLogin = -1;
    private final Map<String, Object> _childHash = new HashMap<String, Object>();
    private int _childCount = 0;
    private String _authenticator = null;
    private KeepAliveThread _keepAlive = null;
    private LoginBrokerHandler _loginBrokerHandler = null;
    private static Logger _log = LoggerFactory.getLogger(LoginManager.class);
    private static Logger _logSocketIO = LoggerFactory.getLogger((String)"logger.dev.org.dcache.io.socket");
    private Class<?>[][] _loginConSignature = new Class[][]{{String.class, StreamEngine.class}, {String.class, StreamEngine.class, Args.class}};
    private Class<?>[] _authConSignature = new Class[]{CellNucleus.class, Args.class};
    private Class<?>[] _loginPntSignature = new Class[]{Integer.TYPE};
    private int _loginConType = -1;
    private String _protocol;
    private String _authClassName;
    private Class<?> _authClass;
    public String hh_set_keepalive = "<keepAliveValue/seconds>";
    public String hh_set_max_logins = "<maxNumberOfLogins>|-1";

    public LoginManager(String name, String argString) throws Exception {
        super(name, argString, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        try {
            Args args = this._args;
            if (args.argc() < 2) {
                throw new IllegalArgumentException("USAGE : ... <listenPort> <loginCellClass> [-prot=ssh|telnet|raw] [-auth=<authCell>] [-maxLogin=<n>|-1] [-keepAlive=<seconds>] [-acceptErrorWait=<msecs>] [args givenToLoginClass]");
            }
            this._protocol = args.getOpt("prot");
            this.checkProtocol();
            _log.info("Using Protocol : {}", (Object)this._protocol);
            int listenPort = Integer.parseInt(args.argv(0));
            args.shift();
            if (args.argc() > 0) {
                this._loginClass = Class.forName(args.argv(0));
                _log.info("Using login class : {}", (Object)this._loginClass.getName());
                args.shift();
            }
            this._authenticator = args.getOpt("authenticator");
            this._authenticator = this._authenticator == null ? "pam" : this._authenticator;
            this._authClassName = args.getOpt("auth");
            if (this._authClassName == null) {
                if (this._protocol.equals("ssh")) {
                    this._authClass = SshSAuth_A.class;
                } else if (this._protocol.equals("raw")) {
                    this._authClass = null;
                } else if (this._protocol.equals("telnet")) {
                    this._authClass = TelnetSAuth_A.class;
                }
                if (this._authClass != null) {
                    _log.info("Using authentication Module : " + this._authClass);
                }
            } else if (!this._authClassName.equals("none")) {
                _log.info("Using authentication Module : " + this._authClassName);
                this._authClass = Class.forName(this._authClassName);
            }
            if (this._authClass != null) {
                this._authConstructor = this._authClass.getConstructor(this._authConSignature);
                _log.info("Using authentication Constructor : " + this._authConstructor);
            } else {
                this._authConstructor = null;
                _log.info("No authentication used");
            }
            try {
                this._loginConstructor = this._loginClass.getConstructor(this._loginConSignature[1]);
                this._loginConType = 1;
            }
            catch (NoSuchMethodException nsme) {
                this._loginConstructor = this._loginClass.getConstructor(this._loginConSignature[0]);
                this._loginConType = 0;
            }
            _log.info("Using constructor : " + this._loginConstructor);
            try {
                this._loginPrintMethod = this._loginClass.getMethod("setPrintoutLevel", this._loginPntSignature);
            }
            catch (NoSuchMethodException pr) {
                _log.info("No setPrintoutLevel(int) found in " + this._loginClass.getName());
                this._loginPrintMethod = null;
            }
            String maxLogin = args.getOpt("maxLogin");
            if (maxLogin != null) {
                try {
                    this._maxLogin = Integer.parseInt(maxLogin);
                }
                catch (NumberFormatException ee) {
                    // empty catch block
                }
            }
            this._loginBrokerHandler = new LoginBrokerHandler();
            this.addCommandListener(this._loginBrokerHandler);
            if (this._loginBrokerHandler.isActive() && this._maxLogin < 0) {
                this._maxLogin = 100000;
            }
            if (this._maxLogin < 0) {
                _log.info("MaxLogin feature disabled");
            } else {
                this._nucleus.addCellEventListener(new LoginEventListener());
                _log.info("Maximum Logins set to :" + this._maxLogin);
            }
            String keepAliveValue = args.getOpt("keepAlive");
            long keepAlive = 0L;
            try {
                keepAlive = keepAliveValue == null ? 0L : Long.parseLong(keepAliveValue);
            }
            catch (NumberFormatException ee) {
                _log.warn("KeepAlive value not valid : " + keepAliveValue);
            }
            _log.info("Keep Alive set to " + keepAlive + " seconds");
            this._keepAlive = new KeepAliveThread(keepAlive *= 1000L);
            this._locationManager = args.getOpt("lm");
            this._listenThread = new ListenThread(listenPort);
            _log.info("Listening on port " + this._listenThread.getListenPort());
            this._nucleus.newThread(this._listenThread, "listen").start();
            this._nucleus.newThread(new LocationThread(), "Location").start();
            this._nucleus.newThread(this._keepAlive, "KeepAlive").start();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                _log.warn("LoginManger >" + this.getCellName() + "< got exception : " + e, (Throwable)e);
            }
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    private void checkProtocol() throws IllegalArgumentException {
        if (this._protocol == null) {
            this._protocol = "telnet";
        }
        if (!(this._protocol.equals("ssh") || this._protocol.equals("telnet") || this._protocol.equals("raw"))) {
            throw new IllegalArgumentException("Protocol must be telnet or ssh or raw");
        }
    }

    @Override
    public CellVersion getCellVersion() {
        try {
            Method m = this._loginClass.getMethod("getStaticCellVersion", null);
            return (CellVersion)m.invoke((Object)null, (Object[])null);
        }
        catch (Exception ee) {
            return super.getCellVersion();
        }
    }

    public String ac_set_keepalive_$_1(Args args) {
        long keepAlive = Long.parseLong(args.argv(0));
        this._keepAlive.setKeepAlive(keepAlive * 1000L);
        return "keepAlive value set to " + keepAlive + " seconds";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runKeepAlive() {
        ArrayList<Object> list = null;
        Map<String, Object> map = this._childHash;
        synchronized (map) {
            list = new ArrayList<Object>(this._childHash.values());
        }
        for (Object e : list) {
            if (!(e instanceof KeepAliveListener)) continue;
            try {
                ((KeepAliveListener)e).keepAlive();
            }
            catch (Throwable t) {
                _log.warn("Problem reported by : " + e + " : " + t);
            }
        }
    }

    @Override
    public String toString() {
        return "p=" + (this._listenThread == null ? "???" : "" + this._listenThread.getListenPort()) + ";c=" + this._loginClass.getName();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("  -- Login Manager $Revision: 1.46 $");
        pw.println("  Listen Port    : " + this._listenThread.getListenPort());
        pw.println("  Login Class    : " + this._loginClass);
        pw.println("  Protocol       : " + this._protocol);
        pw.println("  NioChannel     : " + (this._listenThread._serverSocket.getChannel() != null));
        pw.println("  Auth Class     : " + this._authClass);
        pw.println("  Logins created : " + this._loginCounter);
        pw.println("  Logins failed  : " + this._loginFailures);
        pw.println("  Logins denied  : " + this._connectionDeniedCounter);
        pw.println("  KeepAlive      : " + this._keepAlive.getKeepAlive() / 1000L);
        if (this._maxLogin > -1) {
            pw.println("  Logins/max     : " + this._childHash.size() + "(" + this._childCount + ")/" + this._maxLogin);
        }
        if (this._locationManager != null) {
            pw.println("  Location Mgr   : " + this._locationManager + " (" + (this._sending ? "Sending" : "Informed") + ")");
        }
        if (this._loginBrokerHandler != null) {
            pw.println("  LoginBroker Info :");
            this._loginBrokerHandler.getInfo(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_set_max_logins_$_1(Args args) throws Exception {
        int n = Integer.parseInt(args.argv(0));
        if (n > -1 && this._maxLogin < 0) {
            throw new IllegalArgumentException("Can't switch off maxLogin feature");
        }
        if (n < 0 && this._maxLogin > -1) {
            throw new IllegalArgumentException("Can't switch on maxLogin feature");
        }
        Map<String, Object> map = this._childHash;
        synchronized (map) {
            this._maxLogin = n;
            this.childrenCounterChanged();
        }
        return "";
    }

    @Override
    public void cleanUp() {
        _log.info("cleanUp requested by nucleus, closing listen socket");
        if (this._listenThread != null) {
            this._listenThread.shutdown();
        }
        _log.info("Bye Bye");
    }

    private void childrenCounterChanged() {
        int children = this._childHash.size();
        _log.info("New child count : " + children);
        if (this._loginBrokerHandler != null) {
            this._loginBrokerHandler.loadChanged(children, this._maxLogin);
        }
    }

    @Override
    public boolean validateUser(String userName, String password) {
        String[] request = new String[]{"request", userName, "check-password", userName, password};
        try {
            CellMessage msg = new CellMessage(new CellPath(this._authenticator), request);
            msg = this.sendAndWait(msg, 10000L);
            if (msg == null) {
                _log.warn("Pam request timed out {}", (Object[])Thread.currentThread().getStackTrace());
                return false;
            }
            Object[] r = (Object[])msg.getMessageObject();
            return (Boolean)r[5];
        }
        catch (NoRouteToCellException ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            return false;
        }
        catch (InterruptedException ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            return false;
        }
    }

    private class RunEngineThread
    implements Runnable {
        private Socket _socket = null;

        private RunEngineThread(Socket socket) {
            this._socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread t = Thread.currentThread();
            try {
                _log.info("acceptThread (" + t + "): creating protocol engine");
                StreamEngine engine = null;
                engine = LoginManager.this._authConstructor != null ? StreamEngineFactory.newStreamEngine(this._socket, LoginManager.this._protocol, LoginManager.this._nucleus, LoginManager.this.getArgs()) : StreamEngineFactory.newStreamEngineWithoutAuth(this._socket, LoginManager.this._protocol);
                String userName = Subjects.getDisplayName((Subject)engine.getSubject());
                _log.info("acceptThread (" + t + "): connection created for user " + userName);
                int p = userName.indexOf(64);
                if (p > -1) {
                    userName = p == 0 ? "unknown" : userName.substring(0, p);
                }
                Object[] args = LoginManager.this._loginConType == 0 ? new Object[]{LoginManager.this.getCellName() + "-" + userName + "*", engine} : new Object[]{LoginManager.this.getCellName() + "-" + userName + "*", engine, new Args(LoginManager.this.getArgs())};
                Object cell = LoginManager.this._loginConstructor.newInstance(args);
                if (LoginManager.this._loginPrintMethod != null) {
                    try {
                        Object[] a = new Object[]{LoginManager.this._nucleus.getPrintoutLevel()};
                        LoginManager.this._loginPrintMethod.invoke(cell, a);
                    }
                    catch (Exception eee) {
                        _log.warn("Can't setPritoutLevel of " + args[0]);
                    }
                }
                if (LoginManager.this._maxLogin > -1) {
                    try {
                        Method m = cell.getClass().getMethod("getCellName", new Class[0]);
                        String cellName = (String)m.invoke(cell, new Object[0]);
                        _log.info("Invoked cell name : " + cellName);
                        Map map = LoginManager.this._childHash;
                        synchronized (map) {
                            Object deadCell = LoginManager.this._childHash.put(cellName, cell);
                            if (deadCell != null) {
                                LoginManager.this._childHash.remove(cellName);
                                _log.warn("Cell died, removing " + cellName);
                            }
                            LoginManager.this.childrenCounterChanged();
                        }
                    }
                    catch (Exception ee) {
                        _log.warn("Can't determine child name " + ee, (Throwable)ee);
                    }
                }
                LoginManager.this._loginCounter++;
            }
            catch (Exception e) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                _log.warn("Exception in secure protocol : {}", (Object)e.toString());
                LoginManager.this._loginFailures++;
                Map map = LoginManager.this._childHash;
                synchronized (map) {
                    LoginManager.this._childCount--;
                }
            }
        }
    }

    private class ListenThread
    implements Runnable {
        private int _listenPort = 0;
        private ServerSocket _serverSocket = null;
        private boolean _shutdown = false;
        private Thread _this = null;
        private long _acceptErrorTimeout = 0L;
        private boolean _isDedicated = false;

        private ListenThread(int listenPort) throws Exception {
            this._listenPort = listenPort;
            try {
                this._acceptErrorTimeout = Long.parseLong(LoginManager.this._args.getOpt("acceptErrorWait"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.openPort();
        }

        private void openPort() throws Exception {
            String ssf = LoginManager.this._args.getOpt("socketfactory");
            String local = LoginManager.this._args.getOpt("listen");
            if (ssf == null) {
                InetSocketAddress socketAddress = null;
                if (local == null || local.equals("*") || local.equals("")) {
                    socketAddress = new InetSocketAddress(this._listenPort);
                } else {
                    socketAddress = new InetSocketAddress(InetAddress.getByName(local), this._listenPort);
                    this._isDedicated = true;
                }
                this._serverSocket = ServerSocketChannel.open().socket();
                this._serverSocket.bind(socketAddress);
                this._listenPort = this._serverSocket.getLocalPort();
            } else {
                Object obj;
                StringTokenizer st = new StringTokenizer(ssf, ",");
                if (st.countTokens() < 2) {
                    throw new IllegalArgumentException("Invalid Arguments for 'socketfactory'");
                }
                String tunnelFactoryClass = st.nextToken();
                String[] farctoryArgs = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    farctoryArgs[i] = st.nextToken();
                    ++i;
                }
                Class[] constructorArgClassA = new Class[]{String[].class, Map.class};
                Class[] constructorArgClassB = new Class[]{String[].class};
                Class<?> ssfClass = Class.forName(tunnelFactoryClass);
                Object[] args = null;
                Constructor<?> ssfConstructor = null;
                try {
                    ssfConstructor = ssfClass.getConstructor(constructorArgClassA);
                    args = new Object[2];
                    args[0] = farctoryArgs;
                    HashMap map = Maps.newHashMap(LoginManager.this.getDomainContext());
                    map.put("UserValidatable", LoginManager.this);
                    args[1] = map;
                }
                catch (Exception ee) {
                    ssfConstructor = ssfClass.getConstructor(constructorArgClassB);
                    args = new Object[]{farctoryArgs};
                }
                try {
                    obj = ssfConstructor.newInstance(args);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t.getMessage(), t);
                }
                Method meth = ssfClass.getMethod("createServerSocket", new Class[0]);
                this._serverSocket = (ServerSocket)meth.invoke(obj, new Object[0]);
                if (local == null || local.equals("*") || local.equals("")) {
                    this._serverSocket.bind(new InetSocketAddress(this._listenPort));
                } else {
                    this._serverSocket.bind(new InetSocketAddress(InetAddress.getByName(local), this._listenPort));
                    this._isDedicated = true;
                }
                _log.info("ListenThread : got serverSocket class : " + this._serverSocket.getClass().getName());
            }
            if (_logSocketIO.isDebugEnabled()) {
                _logSocketIO.debug("Socket BIND local = " + this._serverSocket.getInetAddress() + ":" + this._serverSocket.getLocalPort());
            }
            _log.info("Nio Socket Channel : " + (this._serverSocket.getChannel() != null));
        }

        public int getListenPort() {
            return this._listenPort;
        }

        public InetAddress[] getInetAddress() {
            InetAddress[] addresses = null;
            if (this._isDedicated) {
                if (this._serverSocket != null) {
                    addresses = new InetAddress[]{this._serverSocket.getInetAddress()};
                }
            } else {
                try {
                    Enumeration<NetworkInterface> ifList = NetworkInterface.getNetworkInterfaces();
                    Vector<InetAddress> v = new Vector<InetAddress>();
                    while (ifList.hasMoreElements()) {
                        NetworkInterface ne = ifList.nextElement();
                        Enumeration<InetAddress> ipList = ne.getInetAddresses();
                        while (ipList.hasMoreElements()) {
                            InetAddress ia = ipList.nextElement();
                            if (!(ia instanceof Inet4Address) || ia.isLoopbackAddress()) continue;
                            v.add(ia);
                        }
                    }
                    addresses = v.toArray(new InetAddress[v.size()]);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            return addresses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._this = Thread.currentThread();
            while (true) {
                Socket socket = null;
                try {
                    Object engine;
                    socket = this._serverSocket.accept();
                    socket.setKeepAlive(true);
                    socket.setTcpNoDelay(true);
                    if (_logSocketIO.isDebugEnabled()) {
                        _logSocketIO.debug("Socket OPEN (ACCEPT) remote = " + socket.getInetAddress() + ":" + socket.getPort() + " local = " + socket.getLocalAddress() + ":" + socket.getLocalPort());
                    }
                    _log.info("Nio Channel (accept) : " + (socket.getChannel() != null));
                    int currentChildHash = 0;
                    Map map = LoginManager.this._childHash;
                    synchronized (map) {
                        currentChildHash = LoginManager.this._childCount;
                    }
                    _log.info("New connection : " + currentChildHash);
                    if (LoginManager.this._maxLogin > 0 && currentChildHash > LoginManager.this._maxLogin) {
                        LoginManager.this._connectionDeniedCounter++;
                        _log.warn("Connection denied " + currentChildHash + " > " + LoginManager.this._maxLogin);
                        _logSocketIO.warn("number of allowed logins exceeded.");
                        engine = new ShutdownEngine(socket);
                        ((Thread)engine).start();
                        continue;
                    }
                    _log.info("Connection request from " + socket.getInetAddress());
                    engine = LoginManager.this._childHash;
                    synchronized (engine) {
                        LoginManager.this._childCount++;
                    }
                    LoginManager.this._nucleus.newThread(new RunEngineThread(socket), "ClientThread-" + socket.getInetAddress() + ":" + socket.getPort()).start();
                }
                catch (InterruptedIOException ioe) {
                    _log.warn("Listen thread interrupted");
                    try {
                        this._serverSocket.close();
                    }
                    catch (IOException ee) {}
                    break;
                }
                catch (IOException ioe) {
                    if (this._serverSocket.isClosed()) break;
                    _log.warn("Got an IO Exception ( closing server ) : " + ioe);
                    try {
                        this._serverSocket.close();
                    }
                    catch (IOException ee) {
                        // empty catch block
                    }
                    if (this._acceptErrorTimeout <= 0L) break;
                    _log.warn("Waiting " + this._acceptErrorTimeout + " msecs");
                    try {
                        Thread.sleep(this._acceptErrorTimeout);
                    }
                    catch (InterruptedException ee) {
                        _log.warn("Recovery halt interrupted");
                        break;
                    }
                    _log.warn("Resuming listener");
                    try {
                        this.openPort();
                    }
                    catch (Exception ee) {
                        _log.warn("openPort reported : " + ee);
                        _log.warn("Waiting " + this._acceptErrorTimeout + " msecs");
                        try {
                            Thread.sleep(this._acceptErrorTimeout);
                        }
                        catch (InterruptedException eee) {
                            _log.warn("Recovery halt interrupted");
                            break;
                        }
                    }
                }
            }
            _log.info("Listen thread finished");
        }

        public synchronized void shutdown() {
            _log.info("Listen thread shutdown requested");
            if (this._shutdown || this._serverSocket == null) {
                return;
            }
            this._shutdown = true;
            try {
                if (_logSocketIO.isDebugEnabled()) {
                    _logSocketIO.debug("Socket SHUTDOWN local = " + this._serverSocket.getInetAddress() + ":" + this._serverSocket.getLocalPort());
                }
                this._serverSocket.close();
            }
            catch (IOException ee) {
                _log.warn("ServerSocket close : " + ee);
            }
            if (this._serverSocket.getChannel() == null) {
                _log.info("Using faked connect to shutdown listen port");
                try {
                    new Socket("localhost", this._listenPort).close();
                }
                catch (IOException e) {
                    _log.warn("ServerSocket faked connect : " + e.getMessage());
                }
            }
            this._this.interrupt();
            _log.info("Shutdown sequence done");
        }

        public class ShutdownEngine
        extends Thread {
            private final Socket _socket;

            public ShutdownEngine(Socket socket) {
                super("Shutdown");
                this._socket = socket;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = this._socket.getInputStream();
                    outputStream = this._socket.getOutputStream();
                    outputStream.close();
                    byte[] buffer = new byte[1024];
                    while (inputStream.read(buffer, 0, buffer.length) > 0) {
                    }
                    inputStream.close();
                }
                catch (IOException ee) {
                    _log.warn("Shutdown : " + ee.getMessage());
                }
                finally {
                    try {
                        if (_logSocketIO.isDebugEnabled()) {
                            _logSocketIO.debug("Socket CLOSE (ACCEPT) remote = " + this._socket.getInetAddress() + ":" + this._socket.getPort() + " local = " + this._socket.getLocalAddress() + ":" + this._socket.getLocalPort());
                        }
                        this._socket.close();
                    }
                    catch (IOException iOException) {}
                }
                _log.info("Shutdown : done");
            }
        }
    }

    private class KeepAliveThread
    implements Runnable {
        private long _keepAlive = 0L;
        private final Object _lock = new Object();

        private KeepAliveThread(long keepAlive) {
            this._keepAlive = keepAlive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._lock;
            synchronized (object) {
                _log.info("KeepAlive Thread started");
                while (!Thread.interrupted()) {
                    try {
                        if (this._keepAlive < 1L) {
                            this._lock.wait();
                        } else {
                            this._lock.wait(this._keepAlive);
                        }
                    }
                    catch (InterruptedException ie) {
                        _log.info("KeepAlive thread done (interrupted)");
                        break;
                    }
                    if (this._keepAlive <= 0L) continue;
                    try {
                        LoginManager.this.runKeepAlive();
                    }
                    catch (Throwable t) {
                        _log.warn("runKeepAlive reported : " + t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setKeepAlive(long keepAlive) {
            Object object = this._lock;
            synchronized (object) {
                this._keepAlive = keepAlive;
                _log.info("Keep Alive value changed to " + this._keepAlive);
                this._lock.notifyAll();
            }
        }

        private long getKeepAlive() {
            return this._keepAlive;
        }
    }

    private class LocationThread
    implements Runnable {
        private LocationThread() {
        }

        @Override
        public void run() {
            int listenPort = LoginManager.this._listenThread.getListenPort();
            _log.info("Sending 'listeningOn " + LoginManager.this.getCellName() + " " + listenPort + "'");
            LoginManager.this._sending = true;
            String dest = LoginManager.this._locationManager;
            if (dest == null) {
                return;
            }
            CellPath path = new CellPath(dest);
            CellMessage msg = new CellMessage(path, "listening on " + LoginManager.this.getCellName() + " " + listenPort);
            int i = 0;
            while (!Thread.interrupted()) {
                _log.info("Sending (" + i + ") 'listening on " + LoginManager.this.getCellName() + " " + listenPort + "'");
                try {
                    if (LoginManager.this.sendAndWait(msg, 5000L) != null) {
                        _log.info("Portnumber successfully sent to " + dest);
                        LoginManager.this._sending = false;
                        break;
                    }
                    _log.warn("No reply from " + dest);
                }
                catch (InterruptedException ie) {
                    _log.warn("'send portnumber thread' interrupted");
                    break;
                }
                catch (Exception ee) {
                    _log.warn("Problem sending portnumber " + ee);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    _log.warn("'send portnumber thread' (sleep) interrupted");
                    break;
                }
                ++i;
            }
        }
    }

    private class LoginEventListener
    implements CellEventListener {
        private LoginEventListener() {
        }

        @Override
        public void cellCreated(CellEvent ce) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cellDied(CellEvent ce) {
            Map map = LoginManager.this._childHash;
            synchronized (map) {
                String removedCell = ce.getSource().toString();
                if (!removedCell.startsWith(LoginManager.this.getCellName())) {
                    return;
                }
                Object newCell = LoginManager.this._childHash.remove(removedCell);
                if (newCell == null) {
                    LoginManager.this._childHash.put(removedCell, new Object());
                    _log.warn("LoginEventListener : removing DEAD cell: " + removedCell);
                }
                _log.info("LoginEventListener : removing : " + removedCell);
                LoginManager.this._childCount--;
                LoginManager.this.childrenCounterChanged();
            }
        }

        @Override
        public void cellExported(CellEvent ce) {
        }

        @Override
        public void routeAdded(CellEvent ce) {
        }

        @Override
        public void routeDeleted(CellEvent ce) {
        }
    }

    public class LoginBrokerHandler
    implements Runnable {
        private static final long EAGER_UPDATE_TIME = 1000L;
        private String _loginBroker = null;
        private String _protocolFamily = null;
        private String _protocolVersion = null;
        private long _brokerUpdateTime = 300000L;
        private long _currentBrokerUpdateTime = 1000L;
        private double _brokerUpdateOffset = 0.1;
        private LoginBrokerInfo _info = null;
        private double _currentLoad = 0.0;
        public String hh_get_children = "[-binary]";
        public String hh_lb_set_update = "<updateTime/sec>";

        private LoginBrokerHandler() {
            this._loginBroker = LoginManager.this._args.getOpt("loginBroker");
            if (this._loginBroker == null) {
                return;
            }
            this._protocolFamily = LoginManager.this._args.getOpt("protocolFamily");
            if (this._protocolFamily == null) {
                this._protocolFamily = LoginManager.this._protocol;
            }
            this._protocolVersion = LoginManager.this._args.getOpt("protocolVersion");
            if (this._protocolVersion == null) {
                this._protocolVersion = "0.1";
            }
            String tmp = LoginManager.this._args.getOpt("brokerUpdateTime");
            try {
                this._brokerUpdateTime = Long.parseLong(tmp) * 1000L;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            tmp = LoginManager.this._args.getOpt("brokerUpdateOffset");
            if (tmp != null) {
                try {
                    this._brokerUpdateOffset = Double.parseDouble(tmp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._info = new LoginBrokerInfo(LoginManager.this._nucleus.getCellName(), LoginManager.this._nucleus.getCellDomainName(), this._protocolFamily, this._protocolVersion, LoginManager.this._loginClass.getName());
            this._info.setUpdateTime(this._brokerUpdateTime);
            LoginManager.this._nucleus.newThread(this, "loginBrokerHandler").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LoginBrokerHandler loginBrokerHandler = this;
                synchronized (loginBrokerHandler) {
                    while (!Thread.interrupted()) {
                        try {
                            this.runUpdate();
                        }
                        catch (Exception ie) {
                            _log.warn("Login Broker Thread reports : " + ie);
                        }
                        this.wait(this._currentBrokerUpdateTime);
                    }
                }
            }
            catch (Exception io) {
                _log.info("Login Broker Thread terminated due to " + io);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object ac_get_children(Args args) {
            boolean binary = args.hasOption("binary");
            Map map = LoginManager.this._childHash;
            synchronized (map) {
                if (binary) {
                    String[] list = new String[LoginManager.this._childHash.size()];
                    list = LoginManager.this._childHash.keySet().toArray(list);
                    return new LoginManagerChildrenInfo(LoginManager.this.getCellName(), LoginManager.this.getCellDomainName(), list);
                }
                StringBuilder sb = new StringBuilder();
                for (String child : LoginManager.this._childHash.keySet()) {
                    sb.append(child).append("\n");
                }
                return sb.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String ac_lb_set_update_$_1(Args args) {
            long update = Long.parseLong(args.argv(0)) * 1000L;
            if (update < 2000L) {
                throw new IllegalArgumentException("Update time out of range");
            }
            LoginBrokerHandler loginBrokerHandler = this;
            synchronized (loginBrokerHandler) {
                this._brokerUpdateTime = update;
                this._info.setUpdateTime(update);
                this.notifyAll();
            }
            return "";
        }

        private synchronized void runUpdate() {
            if (LoginManager.this._listenThread == null) {
                return;
            }
            InetAddress[] addresses = LoginManager.this._listenThread.getInetAddress();
            if (addresses == null || addresses.length == 0) {
                return;
            }
            String[] hosts = new String[addresses.length];
            int nextExternalIfIndex = 0;
            int nextInternalIfIndex = addresses.length - 1;
            for (int i = 0; i < addresses.length; ++i) {
                InetAddress addr = addresses[i];
                if (!(addr.isLinkLocalAddress() || addr.isLoopbackAddress() || addr.isSiteLocalAddress() || addr.isMulticastAddress())) {
                    hosts[nextExternalIfIndex++] = addr.getHostName();
                    continue;
                }
                hosts[nextInternalIfIndex--] = addr.getHostName();
            }
            this._info.setHosts(hosts);
            this._info.setPort(LoginManager.this._listenThread.getListenPort());
            this._info.setLoad(this._currentLoad);
            try {
                LoginManager.this.sendMessage(new CellMessage(new CellPath(this._loginBroker), this._info));
                this._currentBrokerUpdateTime = this._brokerUpdateTime;
            }
            catch (NoRouteToCellException ee) {
                _log.info("Failed to register with LoginBroker: {}", (Object)ee.getMessage());
                this._currentBrokerUpdateTime = 1000L;
            }
        }

        public void getInfo(PrintWriter pw) {
            if (this._loginBroker == null) {
                pw.println("    Login Broker : DISABLED");
                return;
            }
            pw.println("    LoginBroker      : " + this._loginBroker);
            pw.println("    Protocol Family  : " + this._protocolFamily);
            pw.println("    Protocol Version : " + this._protocolVersion);
            pw.println("    Update Time      : " + this._brokerUpdateTime / 1000L + " seconds");
            pw.println("    Update Offset    : " + (int)(this._brokerUpdateOffset * 100.0) + " %");
        }

        private boolean isActive() {
            return this._loginBroker != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadChanged(int children, int maxChildren) {
            if (this._loginBroker == null) {
                return;
            }
            LoginBrokerHandler loginBrokerHandler = this;
            synchronized (loginBrokerHandler) {
                this._currentLoad = (double)children / (double)maxChildren;
                if (Math.abs(this._info.getLoad() - this._currentLoad) > this._brokerUpdateOffset) {
                    this.notifyAll();
                }
            }
        }
    }
}

