/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingManager
extends CellAdapter
implements CellEventListener {
    private static final Logger _log = LoggerFactory.getLogger(RoutingManager.class);
    private final CellNucleus _nucleus;
    private final Args _args;
    private final Set<String> _localExports = new HashSet<String>();
    private final Map<String, Set<String>> _domainHash = new HashMap<String, Set<String>>();
    private final String _watchCell;
    private boolean _defaultInstalled = false;
    public String hh_ls = "[-x]";

    public RoutingManager(String name, String args) {
        super(name, "System", args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        this._nucleus.addCellEventListener(this);
        this._watchCell = this._args.argc() == 0 ? null : this._args.argv(0);
        this.start();
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        pw.println(" Our routing knowledge :");
        pw.append(" Local : ").println(this._localExports);
        for (Map.Entry<String, Set<String>> e : this._domainHash.entrySet()) {
            pw.append(" ").append(e.getKey()).append(" : ").println(e.getValue());
        }
    }

    private synchronized void setDefaultInstalled(boolean value) {
        this._defaultInstalled = value;
    }

    private synchronized boolean isDefaultInstalled() {
        return this._defaultInstalled;
    }

    private void addWellknown(String cell, String domain) {
        if (cell.startsWith("@")) {
            return;
        }
        try {
            this._nucleus.routeAdd(new CellRoute(cell, "*@" + domain, 2));
        }
        catch (IllegalArgumentException e) {
            _log.warn("Couldn't add wellknown route : " + e.getMessage());
        }
    }

    private void removeWellknown(String cell, String domain) {
        if (cell.startsWith("@")) {
            return;
        }
        try {
            this._nucleus.routeDelete(new CellRoute(cell, "*@" + domain, 2));
        }
        catch (IllegalArgumentException e) {
            _log.warn("Couldn't delete wellknown route : " + e.getMessage());
        }
    }

    private synchronized void updateUpstream() {
        ArrayList<String> all = new ArrayList<String>();
        _log.info("update requested to upstream Domains");
        all.add(this._nucleus.getCellDomainName());
        all.addAll(this._localExports);
        for (Set<String> cells : this._domainHash.values()) {
            all.addAll(cells);
        }
        String destinationManager = this._nucleus.getCellName();
        _log.info("Resending to " + destinationManager + " : " + all);
        try {
            CellPath path = new CellPath(destinationManager);
            String[] arr = all.toArray(new String[0]);
            this._nucleus.resendMessage(new CellMessage(path, arr));
        }
        catch (NoRouteToCellException e) {
            _log.info("Cannot send routing information to RoutingMgr: " + e.getMessage());
        }
    }

    private synchronized void addRoutingInfo(String[] info) {
        String domain = info[0];
        Set<String> oldCells = this._domainHash.get(domain);
        HashSet<String> newCells = new HashSet<String>();
        for (int i = 1; i < info.length; ++i) {
            newCells.add(info[i]);
        }
        if (oldCells == null) {
            _log.info("Adding new domain : " + domain);
            for (String cell : newCells) {
                this.addWellknown(cell, domain);
            }
        } else {
            _log.info("Updating domain : " + domain);
            for (String cell : newCells) {
                if (oldCells.remove(cell)) continue;
                _log.debug("Adding : " + cell);
                this.addWellknown(cell, domain);
            }
            for (String cell : oldCells) {
                _log.debug("Removing : " + cell);
                this.removeWellknown(cell, domain);
            }
        }
        this._domainHash.put(domain, newCells);
        if (this.isDefaultInstalled()) {
            this.updateUpstream();
        }
    }

    private synchronized void removeRoutingInfo(String domain) {
        _log.info("Removing all routes to domain : " + domain);
        Set<String> cells = this._domainHash.remove(domain);
        if (cells == null) {
            _log.info("No entry found for domain : " + domain);
            return;
        }
        for (String cell : cells) {
            this.removeWellknown(cell, domain);
        }
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Object obj = msg.getMessageObject();
        if (obj instanceof String[]) {
            String[] info = (String[])obj;
            if (info.length < 1) {
                _log.warn("Protocol error 1 in routing info");
                return;
            }
            _log.info("Routing info arrived for Domain : " + info[0]);
            this.addRoutingInfo(info);
        } else {
            _log.warn("Unidentified message ignored : " + obj);
        }
    }

    @Override
    public void cellCreated(CellEvent ce) {
        String name = (String)ce.getSource();
        _log.info("cellCreated : " + name);
    }

    @Override
    public synchronized void cellDied(CellEvent ce) {
        String name = (String)ce.getSource();
        _log.info("cellDied : " + name);
        this._localExports.remove(name);
        this.updateUpstream();
    }

    @Override
    public synchronized void cellExported(CellEvent ce) {
        String name = (String)ce.getSource();
        _log.info("cellExported : " + name);
        this._localExports.add(name);
        this.updateUpstream();
    }

    @Override
    public void routeAdded(CellEvent ce) {
        CellRoute cr = (CellRoute)ce.getSource();
        CellAddressCore gate = new CellAddressCore(cr.getTargetName());
        _log.info("Got 'route added' event : " + cr);
        if (cr.getRouteType() == 3) {
            if (this._watchCell != null && gate.getCellName().equals(this._watchCell)) {
                try {
                    CellRoute defRoute = new CellRoute("", "*@" + cr.getDomainName(), 4);
                    this._nucleus.routeAdd(defRoute);
                }
                catch (IllegalArgumentException e) {
                    _log.warn("Couldn't add default route : " + e.getMessage());
                }
            } else {
                _log.info("Downstream route added to Domain : " + cr.getDomainName());
                this.updateUpstream();
            }
        } else if (cr.getRouteType() == 4) {
            _log.info("Default route was added");
            this.setDefaultInstalled(true);
            this.updateUpstream();
        }
    }

    @Override
    public void routeDeleted(CellEvent ce) {
        CellRoute cr = (CellRoute)ce.getSource();
        CellAddressCore gate = new CellAddressCore(cr.getTargetName());
        if (cr.getRouteType() == 3) {
            if (this._watchCell != null && gate.getCellName().equals(this._watchCell)) {
                CellRoute defRoute = new CellRoute("", "*@" + cr.getDomainName(), 4);
                this._nucleus.routeDelete(defRoute);
            } else {
                this.removeRoutingInfo(cr.getDomainName());
            }
        } else if (cr.getRouteType() == 4) {
            this.setDefaultInstalled(false);
        }
    }

    public String ac_update(Args args) {
        this.updateUpstream();
        return "Done";
    }

    @Deprecated
    public synchronized Object ac_ls_$_0(Args args) {
        Object[] info;
        if (!args.hasOption("x")) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(os);
            this.getInfo(pw);
            pw.flush();
            info = os.toString();
        } else {
            Object[] infoArray = new Object[]{this._nucleus.getCellDomainName(), this._localExports, this._domainHash};
            info = infoArray;
        }
        return info;
    }
}

