/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.UOID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogger {
    private static final Logger deliver = LoggerFactory.getLogger((String)"events.org.dcache.cells.deliver");
    private static final Logger send = LoggerFactory.getLogger((String)"events.org.dcache.cells.send");
    private static final Logger queue = LoggerFactory.getLogger((String)"events.org.dcache.cells.queue");
    private static final String DELIVER_BEGIN = "org.dcache.cells.deliver.begin";
    private static final String DELIVER_END = "org.dcache.cells.deliver.end";
    private static final String SEND_BEGIN = "org.dcache.cells.send.begin";
    private static final String SEND_END = "org.dcache.cells.send.end";
    private static final String QUEUE_BEGIN = "org.dcache.cells.queue.begin";
    private static final String QUEUE_END = "org.dcache.cells.queue.end";

    private static String getMessage(CellMessage envelope) {
        Object o = envelope.getMessageObject();
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return "\"" + (String)o + "\"";
        }
        return o.getClass().getSimpleName();
    }

    private static String toString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static void deliverBegin(CellMessage envelope) {
        if (deliver.isInfoEnabled()) {
            deliver.info(String.format("event=%s uoid=%s lastuoid=%s session=%s message=%s source=%s destination=%s", DELIVER_BEGIN, envelope.getUOID(), envelope.getLastUOID(), EventLogger.toString(envelope.getSession()), EventLogger.getMessage(envelope), envelope.getSourcePath(), envelope.getDestinationPath()));
        }
    }

    public static void deliverEnd(Object session, UOID uoid) {
        if (deliver.isInfoEnabled()) {
            deliver.info(String.format("event=%s uoid=%s session=%s", DELIVER_END, uoid, EventLogger.toString(session)));
        }
    }

    public static void sendBegin(CellNucleus nucleus, CellMessage envelope, String mode) {
        if (send.isInfoEnabled() && !envelope.isStreamMode()) {
            CellPath source = envelope.getSourcePath();
            if (source.hops() == 0) {
                source = new CellPath();
                source.add(nucleus.getThisAddress());
            }
            send.info(String.format("event=%s uoid=%s lastuoid=%s session=%s mode=%s message=%s source=%s destination=%s", SEND_BEGIN, envelope.getUOID(), envelope.getLastUOID(), EventLogger.toString(envelope.getSession()), mode, EventLogger.getMessage(envelope), source, envelope.getDestinationPath()));
        }
    }

    public static void sendEnd(CellMessage envelope) {
        if (send.isInfoEnabled() && !envelope.isStreamMode()) {
            send.info(String.format("event=%s uoid=%s session=%s", SEND_END, envelope.getUOID(), EventLogger.toString(envelope.getSession())));
        }
    }

    public static void queueBegin(CellEvent event) {
        if (queue.isInfoEnabled() && event.getClass().equals(MessageEvent.class)) {
            CellMessage envelope = ((MessageEvent)event).getMessage();
            queue.info(String.format("event=%s uoid=%s lastuoid=%s session=%s source=%s destination=%s", QUEUE_BEGIN, envelope.getUOID(), envelope.getLastUOID(), EventLogger.toString(envelope.getSession()), envelope.getSourcePath(), envelope.getDestinationPath()));
        }
    }

    public static void queueEnd(CellEvent event) {
        if (queue.isInfoEnabled() && event.getClass().equals(MessageEvent.class)) {
            CellMessage envelope = ((MessageEvent)event).getMessage();
            queue.info(String.format("event=%s uoid=%s session=%s", QUEUE_END, envelope.getUOID(), EventLogger.toString(envelope.getSession())));
        }
    }
}

