/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CellAddressCore;
import dmg.util.Args;
import dmg.util.Formats;
import java.io.Serializable;
import java.util.Arrays;

public class CellRoute
implements Cloneable,
Serializable {
    static final long serialVersionUID = 4566260400288960984L;
    private final String _destCell;
    private final String _destDomain;
    private final String _gateway;
    private final int _type;
    public static final int AUTO = 0;
    public static final int EXACT = 1;
    public static final int WELLKNOWN = 2;
    public static final int DOMAIN = 3;
    public static final int DEFAULT = 4;
    public static final int DUMPSTER = 5;
    public static final int ALIAS = 6;
    private static final String[] __typeNames = new String[]{"Auto", "Exact", "Wellknown", "Domain", "Default", "Dumpster", "Alias"};
    private static final int _destLength = 15;
    private static final int _domainLength = 15;
    private static final int _gateLength = 25;

    private static int getTypeOf(Args args) {
        if (args.argc() == 0) {
            throw new IllegalArgumentException("Not enough arguments");
        }
        String opt = args.optc() == 0 ? "-auto" : args.optv(0);
        int type = 0;
        if (opt.equals("auto")) {
            type = 0;
        } else if (opt.equals("domain")) {
            type = 3;
        } else if (opt.equals("wellknown")) {
            type = 2;
        } else if (opt.equals("exact")) {
            type = 1;
        } else if (opt.equals("default")) {
            type = 4;
        } else if (opt.equals("dumpster")) {
            type = 5;
        } else if (opt.equals("alias")) {
            type = 6;
        }
        if (args.argc() == 1) {
            if (type != 4 && type != 5) {
                throw new IllegalArgumentException("Not enough arguments");
            }
        } else if (args.argc() == 2) {
            if (type == 4 || type == 5) {
                throw new IllegalArgumentException("Too many arguments");
            }
        } else {
            throw new IllegalArgumentException("Too many arguments");
        }
        return type;
    }

    private static int getTypeOf(String type) {
        int i = Arrays.asList(__typeNames).indexOf(type);
        if (i == -1) {
            throw new IllegalArgumentException("Illegal Route Type: " + type);
        }
        return i;
    }

    public CellRoute(Args args) throws IllegalArgumentException {
        this(args.argc() != 2 ? null : args.argv(0), args.argc() != 2 ? args.argv(0) : args.argv(1), CellRoute.getTypeOf(args));
    }

    public CellRoute(String dest, String gateway, String type) throws IllegalArgumentException {
        this(dest, gateway, CellRoute.getTypeOf(type));
    }

    public CellRoute(String dest, String gateway, int type) throws IllegalArgumentException {
        String domain;
        String cell;
        this._gateway = gateway;
        if (dest == null || dest.equals("")) {
            cell = null;
            domain = null;
        } else {
            int ind = dest.indexOf(64);
            if (ind < 0) {
                cell = dest;
                domain = null;
            } else {
                cell = dest.substring(0, ind);
                domain = ind == dest.length() - 1 ? null : dest.substring(ind + 1);
            }
        }
        switch (type) {
            case 1: 
            case 6: {
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination cell spec.");
                this._destCell = cell;
                this._destDomain = domain == null ? "local" : domain;
                this._type = type;
                break;
            }
            case 2: {
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination cell spec.");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"WELLKNOWN doesn't accept domain");
                this._destCell = cell;
                this._destDomain = "*";
                this._type = type;
                break;
            }
            case 3: {
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"DOMAIN doesn't accept cell");
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination domain spec.");
                this._destDomain = cell;
                this._destCell = "*";
                this._type = type;
                break;
            }
            case 5: {
                Preconditions.checkArgument((cell == null ? 1 : 0) != 0, (Object)"DUMPSTER doesn't accept cell");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"DUMPSTER doesn't accept domain");
                this._destDomain = "*";
                this._destCell = "*";
                this._type = type;
                break;
            }
            case 4: {
                Preconditions.checkArgument((cell == null ? 1 : 0) != 0, (Object)"DEFAULT doesn't accept cell");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"DEFAULT doesn't accept domain");
                this._destDomain = "*";
                this._destCell = "*";
                this._type = type;
                break;
            }
            case 0: {
                if (cell != null && domain != null) {
                    this._type = cell.equals("*") && domain.equals("*") ? 4 : (cell.equals("*") ? 3 : (domain.equals("*") ? 2 : 1));
                    this._destCell = cell;
                    this._destDomain = domain;
                    break;
                }
                if (domain != null) {
                    this._destCell = "*";
                    this._destDomain = domain;
                    this._type = 3;
                    break;
                }
                if (cell != null) {
                    this._destCell = cell;
                    this._destDomain = "*";
                    this._type = 2;
                    break;
                }
                this._destCell = "*";
                this._destDomain = "*";
                this._type = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Route type");
            }
        }
    }

    public String getCellName() {
        return this._destCell;
    }

    public String getDomainName() {
        return this._destDomain;
    }

    public String getTargetName() {
        return this._gateway;
    }

    public int getRouteType() {
        return this._type;
    }

    public CellAddressCore getTarget() {
        return new CellAddressCore(this._gateway);
    }

    public String getRouteTypeName() {
        return __typeNames[this._type];
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._destCell, this._destDomain});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellRoute)) {
            return false;
        }
        CellRoute route = (CellRoute)o;
        return route._destCell.equals(this._destCell) && route._destDomain.equals(this._destDomain);
    }

    public static String headerToString() {
        return Formats.field("Dest Cell", 15, 1) + Formats.field("Dest Domain", 15, 1) + Formats.field("Gateway", 25, 1) + Formats.field("Type", 10, 1);
    }

    public String toString() {
        return Formats.field(this._destCell, 15, 1) + Formats.field(this._destDomain, 15, 1) + Formats.field(this._gateway, 25, 1) + Formats.field(__typeNames[this._type], 10, 2);
    }
}

