/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellGlue;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellLock;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellRoutingTable;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.EventLogger;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.SystemCell;
import dmg.cells.nucleus.UOID;
import dmg.util.BufferedLineWriter;
import dmg.util.Pinboard;
import dmg.util.Slf4jErrorWriter;
import dmg.util.Slf4jInfoWriter;
import dmg.util.logback.FilterThresholds;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellNucleus
implements ThreadFactory {
    private static final int PINBOARD_DEFAULT_SIZE = 200;
    private static final int INITIAL = 0;
    private static final int ACTIVE = 1;
    private static final int REMOVING = 2;
    private static final int DEAD = 3;
    private static CellGlue __cellGlue = null;
    private final String _cellName;
    private final String _cellType;
    private ThreadGroup _threads = null;
    private final Cell _cell;
    private final Date _creationTime = new Date();
    private int _state = 0;
    private int _printoutLevel = 0;
    private static final Logger _logMessages = LoggerFactory.getLogger((String)"logger.org.dcache.cells.messages");
    private static final Logger _logNucleus = LoggerFactory.getLogger(CellNucleus.class);
    private final Logger _logCell;
    private final Map<UOID, CellLock> _waitHash = new HashMap<UOID, CellLock>();
    private String _cellClass;
    private volatile ExecutorService _callbackExecutor;
    private volatile ExecutorService _messageExecutor;
    private boolean _isPrivateCallbackExecutor = true;
    private boolean _isPrivateMessageExecutor = true;
    private Pinboard _pinboard;
    private FilterThresholds _loggingThresholds;
    public static final int PRINT_CELL = 1;
    public static final int PRINT_ERROR_CELL = 2;
    public static final int PRINT_NUCLEUS = 4;
    public static final int PRINT_ERROR_NUCLEUS = 8;
    public static final int PRINT_FATAL = 16;
    public static final int PRINT_ERRORS = 10;
    public static final int PRINT_EVERYTHING = 31;
    private static final CellEvent LAST_MESSAGE_EVENT = new LastMessageEvent();

    public CellNucleus(Cell cell, String name) {
        this(cell, name, "Generic");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CellNucleus(Cell cell, String name, String type) {
        this.setPinboard(new Pinboard(200));
        this._logCell = LoggerFactory.getLogger(cell.getClass());
        if (__cellGlue == null) {
            if (!(cell instanceof SystemCell)) throw new IllegalArgumentException("System must be first Cell");
            __cellGlue = new CellGlue(name);
            this._cellName = "System";
            this._cellType = "System";
            __cellGlue.setSystemNucleus(this);
        } else {
            if (cell instanceof SystemCell) {
                throw new IllegalArgumentException("System already exists");
            }
            String cellName = name.replace('@', '+');
            if (cellName == null || cellName.equals("")) {
                cellName = "*";
            }
            if (cellName.charAt(cellName.length() - 1) == '*') {
                cellName = cellName.length() == 1 ? "$-" + this.getUnique() : cellName.substring(0, cellName.length() - 1) + "-" + this.getUnique();
            }
            this._cellName = cellName;
            this._cellType = type;
        }
        this._cell = cell;
        this._cellClass = this._cell.getClass().getName();
        try {
            this._threads = new ThreadGroup(__cellGlue.getMasterThreadGroup(), this._cellName + "-threads");
        }
        catch (SecurityException se) {
            this._threads = null;
        }
        this._callbackExecutor = Executors.newSingleThreadExecutor(this);
        this._messageExecutor = Executors.newSingleThreadExecutor(this);
        this._state = 1;
        this._printoutLevel = __cellGlue.getDefaultPrintoutLevel();
        __cellGlue.addCell(this._cellName, this);
        _logNucleus.info("Created : " + name);
    }

    public static CellNucleus getLogTargetForCell(String cell) {
        CellNucleus nucleus = null;
        if (__cellGlue != null) {
            if (cell != null) {
                nucleus = __cellGlue.getCell(cell);
            }
            if (nucleus == null) {
                nucleus = __cellGlue.getSystemNucleus();
            }
        }
        return nucleus;
    }

    void setSystemNucleus(CellNucleus nucleus) {
        __cellGlue.setSystemNucleus(nucleus);
    }

    boolean isSystemNucleus() {
        return this == __cellGlue.getSystemNucleus();
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getCellType() {
        return this._cellType;
    }

    public String getCellClass() {
        return this._cellClass;
    }

    public void setCellClass(String cellClass) {
        this._cellClass = cellClass;
    }

    public CellAddressCore getThisAddress() {
        return new CellAddressCore(this._cellName, __cellGlue.getCellDomainName());
    }

    public CellDomainInfo getCellDomainInfo() {
        return __cellGlue.getCellDomainInfo();
    }

    public String getCellDomainName() {
        return __cellGlue.getCellDomainName();
    }

    public List<String> getCellNames() {
        return __cellGlue.getCellNames();
    }

    public CellInfo getCellInfo(String name) {
        return __cellGlue.getCellInfo(name);
    }

    public CellInfo getCellInfo() {
        return __cellGlue.getCellInfo(this.getCellName());
    }

    public Map<String, Object> getDomainContext() {
        return __cellGlue.getCellContext();
    }

    public Reader getDomainContextReader(String contextName) throws FileNotFoundException {
        Object o = __cellGlue.getCellContext(contextName);
        if (o == null) {
            throw new FileNotFoundException("Context not found : " + contextName);
        }
        return new StringReader(o.toString());
    }

    public void setDomainContext(String contextName, Object context) {
        __cellGlue.getCellContext().put(contextName, context);
    }

    public Object getDomainContext(String str) {
        return __cellGlue.getCellContext(str);
    }

    public String[][] getClassProviders() {
        return __cellGlue.getClassProviders();
    }

    public synchronized void setClassProvider(String selection, String provider) {
        __cellGlue.setClassProvider(selection, provider);
    }

    Cell getThisCell() {
        return this._cell;
    }

    CellInfo _getCellInfo() {
        CellInfo info = new CellInfo();
        info.setCellName(this.getCellName());
        info.setDomainName(this.getCellDomainName());
        info.setCellType(this.getCellType());
        info.setCreationTime(this._creationTime);
        try {
            info.setCellVersion(CellNucleus.getCellVersionByObject(this._cell));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            info.setPrivateInfo(this._cell.getInfo());
        }
        catch (Exception e) {
            info.setPrivateInfo("Not yet/No more available\n");
        }
        try {
            info.setShortInfo(this._cell.toString());
        }
        catch (Exception e) {
            info.setShortInfo("Not yet/No more available");
        }
        info.setCellClass(this._cellClass);
        try {
            info.setEventQueueSize(this.getEventQueueSize());
            info.setState(this._state);
            info.setThreadCount(this._threads.activeCount());
        }
        catch (Exception e) {
            info.setEventQueueSize(0);
            info.setState(0);
            info.setThreadCount(0);
        }
        return info;
    }

    public void setPrintoutLevel(int level) {
        this._printoutLevel = level;
    }

    public int getPrintoutLevel() {
        return this._printoutLevel;
    }

    public void setPrintoutLevel(String cellName, int level) {
        __cellGlue.setPrintoutLevel(cellName, level);
    }

    public int getPrintoutLevel(String cellName) {
        return __cellGlue.getPrintoutLevel(cellName);
    }

    public synchronized void setLoggingThresholds(FilterThresholds thresholds) {
        this._loggingThresholds = thresholds;
    }

    public synchronized FilterThresholds getLoggingThresholds() {
        return this._loggingThresholds;
    }

    public synchronized void setPinboard(Pinboard pinboard) {
        this._pinboard = pinboard;
    }

    public synchronized Pinboard getPinboard() {
        return this._pinboard;
    }

    public synchronized void setAsyncCallback(boolean asyncCallback) {
        if (asyncCallback) {
            this.setCallbackExecutor(Executors.newCachedThreadPool(this));
        } else {
            this.setCallbackExecutor(Executors.newSingleThreadExecutor(this));
        }
        this._isPrivateCallbackExecutor = true;
    }

    public synchronized void setCallbackExecutor(ExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        if (this._isPrivateCallbackExecutor) {
            this._callbackExecutor.shutdown();
        }
        this._callbackExecutor = executor;
        this._isPrivateCallbackExecutor = false;
    }

    public synchronized void setMessageExecutor(ExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        if (this._isPrivateMessageExecutor) {
            this._messageExecutor.shutdown();
        }
        this._messageExecutor = executor;
        this._isPrivateMessageExecutor = false;
    }

    private synchronized void shutdownPrivateExecutors() {
        if (this._isPrivateCallbackExecutor) {
            this._callbackExecutor.shutdown();
        }
        if (this._isPrivateMessageExecutor) {
            this._messageExecutor.shutdown();
        }
    }

    public void sendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.sendMessage(msg, true, true);
    }

    public void resendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.sendMessage(msg, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean locally, boolean remotely) throws SerializationException, NoRouteToCellException {
        if (!msg.isStreamMode()) {
            msg.touch();
        }
        EventLogger.sendBegin(this, msg, "async");
        try {
            __cellGlue.sendMessage(this, msg, locally, remotely);
        }
        finally {
            EventLogger.sendEnd(msg);
        }
    }

    public CellMessage sendAndWait(CellMessage msg, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException {
        return this.sendAndWait(msg, true, true, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellMessage sendAndWait(CellMessage msg, boolean local, boolean remote, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException {
        if (!msg.isStreamMode()) {
            msg.touch();
        }
        msg.setTtl(timeout);
        EventLogger.sendBegin(this, msg, "blocking");
        UOID uoid = msg.getUOID();
        try {
            CellLock lock = new CellLock();
            Object object = this._waitHash;
            synchronized (object) {
                this._waitHash.put(uoid, lock);
            }
            _logNucleus.info("sendAndWait : adding to hash : " + uoid);
            __cellGlue.sendMessage(this, msg, local, remote);
            object = lock;
            synchronized (object) {
                long start = System.currentTimeMillis();
                while (lock.getObject() == null && timeout > 0L) {
                    lock.wait(timeout);
                    timeout -= System.currentTimeMillis() - start;
                }
            }
            CellMessage answer = (CellMessage)lock.getObject();
            if (answer == null) {
                CellMessage start = null;
                return start;
            }
            Object obj = (answer = new CellMessage(answer)).getMessageObject();
            if (obj instanceof NoRouteToCellException) {
                throw (NoRouteToCellException)obj;
            }
            if (obj instanceof SerializationException) {
                throw (SerializationException)obj;
            }
            CellMessage cellMessage = answer;
            return cellMessage;
        }
        finally {
            Map<UOID, CellLock> map = this._waitHash;
            synchronized (map) {
                this._waitHash.remove(uoid);
            }
            EventLogger.sendEnd(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UOID, CellLock> getWaitQueue() {
        HashMap<UOID, CellLock> hash = new HashMap<UOID, CellLock>();
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            hash.putAll(this._waitHash);
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWaitQueue() {
        int size;
        ArrayList<CellLock> expired = new ArrayList<CellLock>();
        long now = System.currentTimeMillis();
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            Iterator<CellLock> i = this._waitHash.values().iterator();
            while (i.hasNext()) {
                CellLock lock = i.next();
                if (lock == null || lock.isSync() || lock.getTimeout() >= now) continue;
                expired.add(lock);
                i.remove();
            }
            size = this._waitHash.size();
        }
        for (CellLock lock : expired) {
            try {
                CellMessage envelope = lock.getMessage();
                EventLogger.sendEnd(envelope);
                lock.getCallback().answerTimedOut(envelope);
            }
            catch (RuntimeException e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean local, boolean remote, CellMessageAnswerable callback, long timeout) throws SerializationException {
        if (!msg.isStreamMode()) {
            msg.touch();
        }
        msg.setTtl(timeout);
        EventLogger.sendBegin(this, msg, "callback");
        UOID uoid = msg.getUOID();
        boolean success = false;
        try {
            CellLock lock = new CellLock(msg, callback, timeout);
            Map<UOID, CellLock> map = this._waitHash;
            synchronized (map) {
                this._waitHash.put(uoid, lock);
            }
            __cellGlue.sendMessage(this, msg, local, remote);
            success = true;
        }
        catch (NoRouteToCellException e) {
            if (callback != null) {
                callback.exceptionArrived(msg, e);
            }
        }
        finally {
            if (!success) {
                Map<UOID, CellLock> map = this._waitHash;
                synchronized (map) {
                    this._waitHash.remove(uoid);
                }
                EventLogger.sendEnd(msg);
            }
        }
    }

    public void addCellEventListener(CellEventListener listener) {
        __cellGlue.addCellEventListener(this, listener);
    }

    public void export() {
        __cellGlue.export(this);
    }

    public void kill() {
        __cellGlue.kill(this);
    }

    public void kill(String cellName) throws IllegalArgumentException {
        __cellGlue.kill(this, cellName);
    }

    public void listThreadGroupOf(String cellName) {
        __cellGlue.threadGroupList(cellName);
    }

    public void threadGroupList() {
        Thread[] threads = new Thread[this._threads.activeCount()];
        this._threads.enumerate(threads);
        for (Thread thread : threads) {
            _logNucleus.warn("Thread: " + thread.getName() + " [" + (thread.isAlive() ? "A" : "-") + (thread.isDaemon() ? "D" : "-") + (thread.isInterrupted() ? "I" : "-") + "] (" + thread.getPriority() + ") " + (Object)((Object)thread.getState()));
            for (StackTraceElement s : thread.getStackTrace()) {
                _logNucleus.warn("    " + s.toString());
            }
        }
    }

    public boolean join(String cellName, long timeout) throws InterruptedException {
        return __cellGlue.join(cellName, timeout);
    }

    private Collection<Thread> getNonDaemonThreads(ThreadGroup group) {
        Thread[] threads = new Thread[group.activeCount()];
        int count = group.enumerate(threads);
        ArrayList<Thread> nonDaemonThreads = new ArrayList<Thread>(count);
        for (int i = 0; i < count; ++i) {
            Thread thread = threads[i];
            if (thread.isDaemon()) continue;
            nonDaemonThreads.add(thread);
        }
        return nonDaemonThreads;
    }

    private boolean joinThreads(Collection<Thread> threads, long timeout) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            long wait = deadline - System.currentTimeMillis();
            if (wait <= 0L) {
                return false;
            }
            thread.join(wait);
            if (!thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    private void killThreads(Collection<Thread> threads) throws InterruptedException {
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            _logNucleus.info("killerThread : interrupting " + thread.getName());
            thread.interrupt();
        }
    }

    private Runnable wrapLoggingContext(final Runnable runnable) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CDC cdc = CDC.reset(CellNucleus.this);
                try {
                    runnable.run();
                }
                finally {
                    cdc.restore();
                }
            }
        };
    }

    @Override
    public Thread newThread(Runnable target) {
        return new Thread(this._threads, this.wrapLoggingContext(target));
    }

    public Thread newThread(Runnable target, String name) {
        return new Thread(this._threads, this.wrapLoggingContext(target), name);
    }

    Thread[] getThreads(String cellName) {
        return __cellGlue.getThreads(cellName);
    }

    public ThreadGroup getThreadGroup() {
        return this._threads;
    }

    Thread[] getThreads() {
        if (this._threads == null) {
            return new Thread[0];
        }
        int threadCount = this._threads.activeCount();
        Thread[] list = new Thread[threadCount];
        int rc = this._threads.enumerate(list);
        if (rc == list.length) {
            return list;
        }
        Thread[] ret = new Thread[rc];
        System.arraycopy(list, 0, ret, 0, rc);
        return ret;
    }

    int getUnique() {
        return __cellGlue.getUnique();
    }

    int getEventQueueSize() {
        if (this._messageExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)this._messageExecutor;
            return executor.getQueue().size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToEventQueue(CellEvent ce) {
        if (ce instanceof RoutedMessageEvent && !(this._cell instanceof CellTunnel)) {
            ce = new MessageEvent(((RoutedMessageEvent)ce).getMessage());
        }
        try {
            CellMessage msg;
            if (ce instanceof MessageEvent && (msg = ((MessageEvent)ce).getMessage()) != null) {
                CellLock lock;
                _logNucleus.info("addToEventQueue : message arrived : " + msg);
                Object object = this._waitHash;
                synchronized (object) {
                    lock = this._waitHash.remove(msg.getLastUOID());
                }
                if (lock != null) {
                    _logNucleus.info("addToEventQueue : lock found for : " + msg);
                    if (lock.isSync()) {
                        _logNucleus.info("addToEventQueue : is synchronous : " + msg);
                        object = lock;
                        synchronized (object) {
                            lock.setObject(msg);
                            lock.notifyAll();
                        }
                        _logNucleus.info("addToEventQueue : dest. was triggered : " + msg);
                    } else {
                        _logNucleus.info("addToEventQueue : is asynchronous : " + msg);
                        try {
                            this._callbackExecutor.execute(new CallbackTask(lock, msg));
                        }
                        catch (RejectedExecutionException e) {
                            Map<UOID, CellLock> map = this._waitHash;
                            synchronized (map) {
                                this._waitHash.put(msg.getLastUOID(), lock);
                            }
                            throw e;
                        }
                    }
                    return;
                }
            }
            this._messageExecutor.execute(new DeliverMessageTask(ce));
        }
        catch (RejectedExecutionException e) {
            _logNucleus.error("Message queue overflow. Dropping " + ce);
        }
    }

    void sendKillEvent(KillEvent ce) {
        _logNucleus.info("sendKillEvent : received {}", (Object)ce);
        KillerThread thread = new KillerThread(ce);
        thread.start();
        _logNucleus.info("sendKillEvent : {} started on group {}", (Object)thread.getName(), (Object)thread.getThreadGroup().getName());
    }

    public static CellVersion getCellVersionByObject(Object obj) throws Exception {
        Class<?> c = obj.getClass();
        Method m = c.getMethod("getCellVersion", null);
        return (CellVersion)m.invoke(obj, (Object[])null);
    }

    public static CellVersion getCellVersionByClass(Class<?> c) throws Exception {
        Method m = c.getMethod("getCellVersion", null);
        return (CellVersion)m.invoke((Object)null, (Object[])null);
    }

    public Cell createNewCell(String cellClass, String cellName, String cellArgs, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        try {
            Object[] args = new Object[]{cellArgs};
            return (Cell)__cellGlue._newInstance(cellClass, cellName, args, systemOnly);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw e;
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return __cellGlue.loadClass(className);
    }

    public Object createNewCell(String className, String cellName, String[] argsClassNames, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassCastException {
        if (argsClassNames == null) {
            return __cellGlue._newInstance(className, cellName, args, false);
        }
        return __cellGlue._newInstance(className, cellName, argsClassNames, args, false);
    }

    public Cell createNewCell(String cellClass, String cellName, Socket socket, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        Object[] args = new Object[]{socket};
        return (Cell)__cellGlue._newInstance(cellClass, cellName, args, systemOnly);
    }

    public void routeAdd(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeAdd(route);
    }

    public void routeDelete(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeDelete(route);
    }

    CellRoute routeFind(CellAddressCore addr) {
        return __cellGlue.getRoutingTable().find(addr);
    }

    CellRoutingTable getRoutingTable() {
        return __cellGlue.getRoutingTable();
    }

    CellRoute[] getRoutingList() {
        return __cellGlue.getRoutingList();
    }

    CellTunnelInfo[] getCellTunnelInfos() {
        return __cellGlue.getCellTunnelInfos();
    }

    public Writer createErrorLogWriter() {
        return new BufferedLineWriter(new Slf4jErrorWriter(this._logCell));
    }

    public Writer createInfoLogWriter() {
        return new BufferedLineWriter(new Slf4jInfoWriter(this._logCell));
    }

    private class DeliverMessageTask
    extends AbstractNucleusTask {
        private final CellEvent _event;

        public DeliverMessageTask(CellEvent event) {
            this._event = event;
            EventLogger.queueBegin(this._event);
        }

        @Override
        public void innerRun() {
            EventLogger.queueEnd(this._event);
            if (this._event instanceof LastMessageEvent) {
                _logNucleus.info("messageThread : LastMessageEvent arrived");
                CellNucleus.this._cell.messageArrived((MessageEvent)this._event);
            } else if (this._event instanceof RoutedMessageEvent) {
                _logNucleus.info("messageThread : RoutedMessageEvent arrived");
                CellNucleus.this._cell.messageArrived((RoutedMessageEvent)this._event);
            } else if (this._event instanceof MessageEvent) {
                CellMessage msg;
                MessageEvent msgEvent = (MessageEvent)this._event;
                _logNucleus.info("messageThread : MessageEvent arrived");
                try {
                    msg = new CellMessage(msgEvent.getMessage());
                }
                catch (SerializationException e) {
                    CellMessage envelope = msgEvent.getMessage();
                    CellNucleus.this._logCell.error(String.format("Discarding a malformed message from %s with UOID %s and session [%s]: %s", envelope.getSourcePath(), envelope.getUOID(), envelope.getSession(), e.getMessage()), (Throwable)e);
                    return;
                }
                CDC.setMessageContext(msg);
                try {
                    if (_logMessages.isDebugEnabled()) {
                        String messageObject = msg.getMessageObject() == null ? "NULL" : msg.getMessageObject().getClass().getName();
                        _logMessages.debug("nucleusMessageArrived src=" + msg.getSourceAddress() + " dest=" + msg.getDestinationAddress() + " [" + messageObject + "] UOID=" + msg.getUOID().toString());
                    }
                    _logNucleus.info("messageThread : delivering message : " + msg);
                    CellNucleus.this._cell.messageArrived(new MessageEvent(msg));
                    _logNucleus.info("messageThread : delivering message done : " + msg);
                }
                catch (RuntimeException e) {
                    if (!msg.isReply()) {
                        try {
                            msg.revertDirection();
                            msg.setMessageObject(e);
                            CellNucleus.this.sendMessage(msg);
                        }
                        catch (NoRouteToCellException f) {
                            CellNucleus.this._logCell.error("PANIC : Problem returning answer : " + f);
                        }
                    }
                    throw e;
                }
                finally {
                    CDC.clearMessageContext();
                }
            }
        }
    }

    private class CallbackTask
    extends AbstractNucleusTask {
        private final CellLock _lock;
        private final CellMessage _message;

        public CallbackTask(CellLock lock, CellMessage message) {
            this._lock = lock;
            this._message = message;
        }

        @Override
        public void innerRun() {
            Object obj;
            CellMessage answer;
            CellMessageAnswerable callback = this._lock.getCallback();
            try {
                answer = new CellMessage(this._message);
                this._lock.getCdc().restore();
                obj = answer.getMessageObject();
            }
            catch (SerializationException e) {
                _logNucleus.warn(e.getMessage());
                obj = e;
                answer = null;
            }
            EventLogger.sendEnd(this._lock.getMessage());
            if (obj instanceof Exception) {
                callback.exceptionArrived(this._lock.getMessage(), (Exception)obj);
            } else {
                callback.answerArrived(this._lock.getMessage(), answer);
            }
            _logNucleus.info("addToEventQueue : callback done for : " + this._message);
        }
    }

    private abstract class AbstractNucleusTask
    implements Runnable {
        private AbstractNucleusTask() {
        }

        protected abstract void innerRun();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CDC cdc = CDC.reset(CellNucleus.this);
            try {
                this.innerRun();
            }
            catch (Throwable e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
            finally {
                cdc.restore();
            }
        }
    }

    private class KillerThread
    extends Thread {
        private final KillEvent _event;

        public KillerThread(KillEvent event) {
            super(__cellGlue.getKillerThreadGroup(), "killer-" + CellNucleus.this._cellName);
            this._event = event;
        }

        @Override
        public void run() {
            _logNucleus.info("killerThread : started");
            CellNucleus.this._state = 2;
            CellNucleus.this.addToEventQueue(LAST_MESSAGE_EVENT);
            try {
                CellNucleus.this._cell.prepareRemoval(this._event);
            }
            catch (Throwable e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
            CellNucleus.this.shutdownPrivateExecutors();
            _logNucleus.info("killerThread : waiting for all threads in {} to finish", (Object)CellNucleus.this._threads);
            try {
                Collection threads = CellNucleus.this.getNonDaemonThreads(CellNucleus.this._threads);
                while (!CellNucleus.this.joinThreads(threads, 1000L)) {
                    CellNucleus.this.killThreads(threads);
                }
                CellNucleus.this._threads.destroy();
            }
            catch (IllegalThreadStateException e) {
                CellNucleus.this._threads.setDaemon(true);
            }
            catch (InterruptedException e) {
                _logNucleus.warn("killerThread : Interrupted while waiting for threads");
            }
            __cellGlue.destroy(CellNucleus.this);
            CellNucleus.this._state = 3;
            _logNucleus.info("killerThread : stopped");
        }
    }
}

