/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellExceptionMessage;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellRoutingTable;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.CellUrl;
import dmg.cells.nucleus.ClassLoaderProvider;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.util.CollectionFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CellGlue {
    private final String _cellDomainName;
    private final Map<String, CellNucleus> _cellList = CollectionFactory.newConcurrentHashMap();
    private final Map<String, List<CellEventListener>> _cellEventListener = CollectionFactory.newConcurrentHashMap();
    private final Map<String, CellNucleus> _killedCellList = CollectionFactory.newConcurrentHashMap();
    private final Map<String, Object> _cellContext = CollectionFactory.newConcurrentHashMap();
    private final AtomicInteger _uniqueCounter = new AtomicInteger(100);
    public int _printoutLevel = 0;
    public int _defPrintoutLevel = 10;
    private CellNucleus _systemNucleus = null;
    private ClassLoaderProvider _classLoader = null;
    private CellRoutingTable _routingTable = new CellRoutingTable();
    private ThreadGroup _masterThreadGroup = null;
    private ThreadGroup _killerThreadGroup = null;
    private static final Logger _logMessages = LoggerFactory.getLogger((String)"logger.org.dcache.cells.messages");
    private static final Logger _logGlue = LoggerFactory.getLogger(CellGlue.class);
    private static final int MAX_ROUTE_LEVELS = 16;

    CellGlue(String cellDomainName) {
        String cellDomainNameLocal = cellDomainName;
        if (cellDomainName == null || cellDomainName.equals("")) {
            cellDomainNameLocal = "*";
        }
        if (cellDomainNameLocal.charAt(cellDomainNameLocal.length() - 1) == '*') {
            cellDomainNameLocal = cellDomainNameLocal.substring(0, cellDomainNameLocal.length()) + System.currentTimeMillis();
        }
        this._cellDomainName = cellDomainNameLocal;
        this._classLoader = new ClassLoaderProvider();
        this._masterThreadGroup = new ThreadGroup("Master-Thread-Group");
        this._killerThreadGroup = new ThreadGroup("Killer-Thread-Group");
        new CellUrl(this);
    }

    ThreadGroup getMasterThreadGroup() {
        return this._masterThreadGroup;
    }

    ThreadGroup getKillerThreadGroup() {
        return this._killerThreadGroup;
    }

    synchronized void addCell(String name, CellNucleus cell) throws IllegalArgumentException {
        if (this._killedCellList.get(name) != null) {
            throw new IllegalArgumentException("Name Mismatch ( cell " + name + " exist  )");
        }
        if (this._cellList.get(name) != null) {
            throw new IllegalArgumentException("Name Mismatch ( cell " + name + " exist )");
        }
        this._cellList.put(name, cell);
        this.sendToAll(new CellEvent(name, 3));
    }

    void setSystemNucleus(CellNucleus nucleus) {
        this._systemNucleus = nucleus;
    }

    CellNucleus getSystemNucleus() {
        return this._systemNucleus;
    }

    String[][] getClassProviders() {
        return this._classLoader.getProviders();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setClassProvider(String selection, String provider) {
        String type = null;
        String value = null;
        int pos = provider.indexOf(58);
        if (pos < 0) {
            if (provider.indexOf(47) >= 0) {
                type = "dir";
                value = provider;
            } else if (provider.indexOf(64) >= 0) {
                type = "cells";
                value = provider;
            } else if (provider.equals("system")) {
                type = "system";
            } else {
                if (!provider.equals("none")) throw new IllegalArgumentException("Can't determine provider type");
                type = "none";
            }
        } else {
            type = provider.substring(0, pos);
            value = provider.substring(pos + 1);
        }
        if (type.equals("dir")) {
            File file = new File(value);
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Not a directory : " + value);
            }
            this._classLoader.addFileProvider(selection, new File(value));
            return;
        } else if (type.equals("cell")) {
            this._classLoader.addCellProvider(selection, this._systemNucleus, new CellPath(value));
            return;
        } else if (type.equals("system")) {
            this._classLoader.addSystemProvider(selection);
            return;
        } else {
            if (!type.equals("none")) throw new IllegalArgumentException("Provider type not supported : " + type);
            this._classLoader.removeSystemProvider(selection);
        }
    }

    synchronized void export(CellNucleus cell) {
        this.sendToAll(new CellEvent(cell.getCellName(), 5));
    }

    private Class _loadClass(String className) throws ClassNotFoundException {
        return this._classLoader.loadClass(className);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this._classLoader.loadClass(className);
    }

    Object _newInstance(String className, String cellName, Object[] args, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        Class newClass = null;
        newClass = systemOnly ? Class.forName(className) : this._loadClass(className);
        Object[] arguments = new Object[args.length + 1];
        arguments[0] = cellName;
        for (int i = 0; i < args.length; ++i) {
            arguments[i + 1] = args[i];
        }
        Class[] argClass = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argClass[i] = arguments[i].getClass();
        }
        return newClass.getConstructor(argClass).newInstance(arguments);
    }

    Object _newInstance(String className, String cellName, String[] argsClassNames, Object[] args, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        Class newClass = null;
        newClass = systemOnly ? Class.forName(className) : this._loadClass(className);
        Object[] arguments = new Object[args.length + 1];
        arguments[0] = cellName;
        for (int i = 0; i < args.length; ++i) {
            arguments[i + 1] = args[i];
        }
        Class[] argClasses = new Class[arguments.length];
        ClassLoader loader = newClass.getClassLoader();
        argClasses[0] = String.class;
        if (loader == null) {
            for (int i = 1; i < argClasses.length; ++i) {
                argClasses[i] = Class.forName(argsClassNames[i - 1]);
            }
        } else {
            for (int i = 1; i < argClasses.length; ++i) {
                argClasses[i] = loader.loadClass(argsClassNames[i - 1]);
            }
        }
        return newClass.getConstructor(argClasses).newInstance(arguments);
    }

    Map<String, Object> getCellContext() {
        return this._cellContext;
    }

    Object getCellContext(String str) {
        return this._cellContext.get(str);
    }

    CellDomainInfo getCellDomainInfo() {
        CellDomainInfo info = new CellDomainInfo(this._cellDomainName);
        return info;
    }

    public void routeAdd(CellRoute route) {
        this._routingTable.add(route);
        this.sendToAll(new CellEvent(route, 7));
    }

    public void routeDelete(CellRoute route) {
        this._routingTable.delete(route);
        this.sendToAll(new CellEvent(route, 8));
    }

    CellRoutingTable getRoutingTable() {
        return this._routingTable;
    }

    CellRoute[] getRoutingList() {
        return this._routingTable.getRoutingList();
    }

    synchronized CellTunnelInfo[] getCellTunnelInfos() {
        ArrayList<CellTunnelInfo> v = new ArrayList<CellTunnelInfo>();
        for (CellNucleus cellNucleus : this._cellList.values()) {
            Cell c = cellNucleus.getThisCell();
            if (!(c instanceof CellTunnel)) continue;
            v.add(((CellTunnel)((Object)c)).getCellTunnelInfo());
        }
        return v.toArray(new CellTunnelInfo[v.size()]);
    }

    synchronized List<String> getCellNames() {
        int size = this._cellList.size() + this._killedCellList.size();
        ArrayList<String> allCells = new ArrayList<String>(size);
        allCells.addAll(this._cellList.keySet());
        allCells.addAll(this._killedCellList.keySet());
        return allCells;
    }

    int getUnique() {
        return this._uniqueCounter.incrementAndGet();
    }

    CellInfo getCellInfo(String name) {
        CellNucleus nucleus = this._cellList.get(name);
        if (nucleus == null && (nucleus = this._killedCellList.get(name)) == null) {
            return null;
        }
        return nucleus._getCellInfo();
    }

    Thread[] getThreads(String name) {
        CellNucleus nucleus = this._cellList.get(name);
        if (nucleus == null && (nucleus = this._killedCellList.get(name)) == null) {
            return null;
        }
        return nucleus.getThreads();
    }

    private void sendToAll(CellEvent event) {
        for (List<CellEventListener> listners : this._cellEventListener.values()) {
            for (CellEventListener hallo : listners) {
                if (hallo == null) {
                    this.say("event distributor found NULL");
                    continue;
                }
                try {
                    switch (event.getEventType()) {
                        case 3: {
                            hallo.cellCreated(event);
                            break;
                        }
                        case 5: {
                            hallo.cellExported(event);
                            break;
                        }
                        case 4: {
                            hallo.cellDied(event);
                            break;
                        }
                        case 7: {
                            hallo.routeAdded(event);
                            break;
                        }
                        case 8: {
                            hallo.routeDeleted(event);
                        }
                    }
                }
                catch (Exception anye) {
                    this.say("Exception while sending " + event + " ex : " + anye);
                }
            }
        }
    }

    void setPrintoutLevel(int level) {
        this._printoutLevel = level;
    }

    int getPrintoutLevel() {
        return this._printoutLevel;
    }

    int getDefaultPrintoutLevel() {
        return this._defPrintoutLevel;
    }

    void setPrintoutLevel(String cellName, int level) {
        if (cellName.equals("CellGlue")) {
            this.setPrintoutLevel(level);
            return;
        }
        if (cellName.equals("default")) {
            this._defPrintoutLevel = level;
            return;
        }
        CellNucleus nucleus = this._cellList.get(cellName);
        if (nucleus != null) {
            nucleus.setPrintoutLevel(level);
        }
    }

    int getPrintoutLevel(String cellName) {
        if (cellName.equals("CellGlue")) {
            return this.getPrintoutLevel();
        }
        if (cellName.equals("default")) {
            return this.getDefaultPrintoutLevel();
        }
        CellNucleus nucleus = this._cellList.get(cellName);
        if (nucleus != null) {
            return nucleus.getPrintoutLevel();
        }
        return -1;
    }

    void say(String str) {
        if ((this._printoutLevel & 4) != 0) {
            _logGlue.warn(str);
        } else {
            _logGlue.info(str);
        }
    }

    void esay(String str) {
        if ((this._printoutLevel & 4) != 0) {
            _logGlue.error(str);
        } else {
            _logGlue.info(str);
        }
    }

    String getCellDomainName() {
        return this._cellDomainName;
    }

    void kill(CellNucleus nucleus) {
        this._kill(nucleus, nucleus, 0L);
    }

    void kill(CellNucleus sender, String cellName) throws IllegalArgumentException {
        CellNucleus nucleus = this._cellList.get(cellName);
        if (nucleus == null) {
            throw new IllegalArgumentException("Cell Not Found : " + cellName);
        }
        this._kill(sender, nucleus, 0L);
    }

    void threadGroupList(String cellName) {
        CellNucleus nucleus = this._cellList.get(cellName);
        if (nucleus == null) {
            nucleus = this._killedCellList.get(cellName);
        }
        if (nucleus != null) {
            nucleus.threadGroupList();
        } else {
            _logGlue.warn("cell " + cellName + " is not running");
        }
    }

    CellNucleus getCell(String cellName) {
        CellNucleus nucleus = this._cellList.get(cellName);
        if (nucleus == null) {
            nucleus = this._killedCellList.get(cellName);
        }
        return nucleus;
    }

    synchronized boolean join(String cellName, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            while (this.getCell(cellName) != null) {
                this.wait();
            }
            return true;
        }
        while (this.getCell(cellName) != null && timeout > 0L) {
            long time = System.currentTimeMillis();
            this.wait(timeout);
            timeout -= System.currentTimeMillis() - time;
        }
        return timeout > 0L;
    }

    synchronized void destroy(CellNucleus nucleus) {
        String name = nucleus.getCellName();
        this._killedCellList.remove(name);
        this.say("destroy : sendToAll : killed" + name);
        this.notifyAll();
    }

    private synchronized void _kill(CellNucleus source, CellNucleus destination, long to) {
        CellPath sourceAddr = new CellPath(source.getCellName(), this.getCellDomainName());
        KillEvent killEvent = new KillEvent(sourceAddr, to);
        String cellToKill = destination.getCellName();
        CellNucleus destNucleus = this._cellList.remove(cellToKill);
        if (destNucleus == null) {
            this.esay("Warning : (name not found in _kill) " + cellToKill);
            return;
        }
        this._cellEventListener.remove(cellToKill);
        this.sendToAll(new CellEvent(cellToKill, 4));
        this._killedCellList.put(cellToKill, destNucleus);
        destNucleus.sendKillEvent(killEvent);
    }

    void sendMessage(CellNucleus nucleus, CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.sendMessage(nucleus, msg, true, true);
    }

    void sendMessage(CellNucleus nucleus, CellMessage msg, boolean resolveLocally, boolean resolveRemotely) throws SerializationException, NoRouteToCellException {
        boolean firstSend = !msg.isStreamMode();
        CellMessage transponder = msg;
        if (firstSend) {
            transponder = new CellMessage(msg);
            transponder.addSourceAddress(nucleus.getThisAddress());
        }
        if (transponder.getSourcePath().hops() > 30) {
            this.esay("Hop count exceeds 30, dumping : " + transponder);
            return;
        }
        CellPath destination = transponder.getDestinationPath();
        CellAddressCore destCore = destination.getCurrent();
        String cellName = destCore.getCellName();
        String domainName = destCore.getCellDomainName();
        this.say("sendMessage : " + transponder.getUOID() + " send to " + destination);
        if (_logMessages.isDebugEnabled()) {
            CellMessage messageToSend = transponder.isStreamMode() ? new CellMessage(transponder) : transponder;
            String messageObject = messageToSend.getMessageObject() == null ? "NULL" : messageToSend.getMessageObject().getClass().getName();
            _logMessages.debug("glueSendMessage src=" + messageToSend.getSourceAddress() + " dest=" + messageToSend.getDestinationAddress() + " [" + messageObject + "] UOID=" + messageToSend.getUOID().toString());
        }
        if (!firstSend && cellName.equals("*")) {
            this.say("sendMessage : * detected ; skipping destination");
            destination.next();
            destCore = destination.getCurrent();
        }
        transponder.isRouted(false);
        for (int iter = 0; iter < 16; ++iter) {
            CellRoute route;
            cellName = destCore.getCellName();
            domainName = destCore.getCellDomainName();
            this.say("sendMessage : next hop at " + iter + " : " + cellName + "@" + domainName);
            CellNucleus destNucleus = this._cellList.get(cellName);
            if (domainName.equals(this._cellDomainName)) {
                if (cellName.equals("*")) {
                    this.say("sendMessagex : * detected ; skipping destination");
                    destination.next();
                    destCore = destination.getCurrent();
                    continue;
                }
                if (destNucleus == null) {
                    if (firstSend) {
                        throw new NoRouteToCellException(transponder.getUOID(), destination, "Initial Send");
                    }
                    this.sendException(nucleus, transponder, destination, cellName);
                    return;
                }
                if (iter == 0) {
                    destNucleus.addToEventQueue(new MessageEvent(transponder));
                } else {
                    transponder.isRouted(true);
                    transponder.addSourceAddress(new CellAddressCore("*", this._cellDomainName));
                    destNucleus.addToEventQueue(new RoutedMessageEvent(transponder));
                }
                return;
            }
            if (domainName.equals("local") && (resolveLocally || iter != 0)) {
                if (destNucleus != null) {
                    if (iter == 0) {
                        destNucleus.addToEventQueue(new MessageEvent(transponder));
                    } else {
                        transponder.isRouted(true);
                        transponder.addSourceAddress(new CellAddressCore("*", this._cellDomainName));
                        destNucleus.addToEventQueue(new RoutedMessageEvent(transponder));
                    }
                    return;
                }
                if (iter == 16) {
                    this.say("sendMessage : max route iteration reached : " + destination);
                    if (firstSend) {
                        throw new NoRouteToCellException(transponder.getUOID(), destination, "Initial Send");
                    }
                    this.sendException(nucleus, transponder, destination, cellName);
                    return;
                }
            } else if (domainName.equals("local") && !resolveRemotely && iter == 0) {
                throw new NoRouteToCellException(transponder.getUOID(), destination, " ! resolve remotely : " + destCore);
            }
            if ((route = this._routingTable.find(destCore)) == null || iter == 16) {
                this.say("sendMessage : no route destination for : " + destCore);
                if (firstSend) {
                    throw new NoRouteToCellException(transponder.getUOID(), destination, "Missing routing entry for " + destCore);
                }
                this.sendException(nucleus, transponder, destination, destCore.toString());
                return;
            }
            this.say("sendMessage : using route : " + route);
            destCore = route.getTarget();
            if (route.getRouteType() != 6) continue;
            destination.replaceCurrent(destCore);
        }
    }

    private void sendException(CellNucleus nucleus, CellMessage msg, CellPath destination, String routeTarget) throws SerializationException, NoRouteToCellException {
        this.say("sendMessage : Route target Not found : " + routeTarget);
        NoRouteToCellException exception = new NoRouteToCellException(msg.getUOID(), destination, "Tunnel cell >" + routeTarget + "< not found at >" + this._cellDomainName + "<");
        CellPath retAddr = (CellPath)msg.getSourcePath().clone();
        retAddr.revert();
        CellExceptionMessage ret = new CellExceptionMessage(retAddr, exception);
        this.esay("Sending CellException to " + retAddr);
        ret.setLastUOID(msg.getUOID());
        this.sendMessage(nucleus, ret);
    }

    void addCellEventListener(CellNucleus nucleus, CellEventListener listener) {
        List<CellEventListener> v = this._cellEventListener.get(nucleus.getCellName());
        if (v == null) {
            v = CollectionFactory.newCopyOnWriteArrayList();
            this._cellEventListener.put(nucleus.getCellName(), v);
        }
        v.add(listener);
    }

    public String toString() {
        return this._cellDomainName;
    }
}

