/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.CanonTopo;
import dmg.cells.applets.spy.LinkPair;
import dmg.cells.network.CellDomainNode;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;

class TopologyPanel
extends Panel {
    private TopoCanvas _topo = new TopoCanvas();
    private ActionListener _callback;

    public TopologyPanel() {
        super(new BorderLayout());
        this.add((Component)this._topo, "Center");
        this.setBackground(Color.blue);
    }

    public void addActionListener(ActionListener l) {
        this._callback = l;
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void setTopology(CellDomainNode[] in) {
        CanonTopo topo = new CanonTopo(in);
        this._topo.setCanonical(topo);
    }

    private class TopoCanvas
    extends Canvas
    implements MouseListener {
        private Hashtable _domainPositions = new Hashtable();
        private Font _font = new Font("SansSerif", 2, 18);
        private CanonTopo _canonical = null;
        private double _baseA = 0.0;

        public TopoCanvas() {
            this.addMouseListener(this);
        }

        public void setCanonical(CanonTopo canonical) {
            this._canonical = canonical;
            this.repaint();
            this._baseA = 0.0;
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            Color base = Color.red;
            for (int i = 0; i < 4; ++i) {
                g.setColor(base);
                g.drawRect(i, i, d.width - 2 * i - 1, d.height - 2 * i - 1);
                base = base.darker();
            }
            if (this._canonical == null) {
                return;
            }
            this.drawTopology(this._canonical, g);
        }

        private void drawTopology(CanonTopo topo, Graphics g) {
            int i;
            Dimension d = this.getSize();
            int domains = topo.domains();
            if (domains <= 0) {
                return;
            }
            String[] domainNames = new String[domains];
            for (int i2 = 0; i2 < domainNames.length; ++i2) {
                domainNames[i2] = topo.getDomain(i2);
            }
            if (domains == 1) {
                g.setFont(this._font);
                FontMetrics fm = g.getFontMetrics();
                int h = fm.getHeight();
                int l = fm.stringWidth(domainNames[0]);
                int x = (d.width - l) / 2;
                int y = (d.height + h) / 2;
                g.drawString(domainNames[0], x, y);
                return;
            }
            g.setFont(this._font);
            FontMetrics fm = g.getFontMetrics();
            int desc = fm.getMaxDescent();
            int acs = fm.getMaxAscent();
            int h = fm.getHeight();
            int l = 0;
            int[] dX = new int[domains];
            int[] dY = new int[domains];
            this.calculatePositions(d, dX, dY, topo);
            g.setColor(Color.white);
            for (i = 0; i < topo.links(); ++i) {
                LinkPair pair = topo.getLinkPair(i);
                int left = pair.getBottom();
                int right = pair.getTop();
                g.drawLine(dX[left], dY[left], dX[right], dY[right]);
            }
            this._domainPositions.clear();
            for (i = 0; i < domains; ++i) {
                l = fm.stringWidth(domainNames[i]);
                h = acs + desc;
                int x = dX[i] - l / 2;
                int y = dY[i] - acs;
                Color col = Color.green;
                g.setColor(col);
                this._domainPositions.put(new Rectangle(x - 2, y - 2, l + 4, h + 4), domainNames[i]);
                col = Color.red;
                g.fillRect(x - 2, y - 2, l + 4, h + 4);
                col = col.darker();
                g.setColor(col);
                g.drawRect(x - 3, y - 3, l + 5, h + 5);
                col = col.darker();
                g.setColor(col);
                g.drawRect(x - 4, y - 4, l + 7, h + 7);
                g.setColor(Color.red);
                g.drawString(domainNames[i], x, dY[i]);
            }
        }

        private void calculatePositions(Dimension d, int[] dX, int[] dY, CanonTopo topo) {
            int domains = dX.length;
            int r = d.height > d.width ? d.width : d.height;
            r = (int)((double)r / 2.0 * 0.8);
            int x0 = d.width / 2;
            int y0 = d.height / 2;
            double dAngle = Math.PI * 2 / (double)domains;
            double A0 = Math.PI * 2 * this._baseA;
            for (int i = 0; i < domains; ++i) {
                dX[i] = (int)((double)x0 + (double)r * Math.sin(A0 + dAngle * (double)i));
                dY[i] = (int)((double)y0 - (double)r * Math.cos(A0 + dAngle * (double)i));
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Point p = ev.getPoint();
            Enumeration e = this._domainPositions.keys();
            Rectangle r = null;
            String domain = null;
            while (e.hasMoreElements()) {
                r = (Rectangle)e.nextElement();
                if (!r.contains(p)) continue;
                domain = (String)this._domainPositions.get(r);
                break;
            }
            if (domain == null) {
                this._baseA += 0.05;
                this.repaint();
                return;
            }
            if (TopologyPanel.this._callback != null) {
                TopologyPanel.this._callback.actionPerformed(new ActionEvent(TopologyPanel.this, 0, domain));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

