/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.network.CellDomainNode;
import dmg.cells.services.MessageObjectFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class RoutingPanel
extends Panel
implements ActionListener,
FrameArrivable {
    private DomainConnection _connection;
    private Button _updateButton;
    private Label _topLabel;
    private TextArea _routeText;
    private Font _bigFont = new Font("SansSerif", 2, 18);
    private Font _smallFont = new Font("SansSerif", 3, 14);
    private Font _textFont = new Font("Monospaced", 2, 14);
    private CellDomainNode _domainNode = null;
    private boolean _useColor = false;

    RoutingPanel(DomainConnection connection) {
        this._connection = connection;
        boolean bl = this._useColor = System.getProperty("bw") == null;
        if (this._useColor) {
            this.setBackground(Color.orange);
        }
        this.setLayout(new BorderLayout());
        this._topLabel = new Label("Routing", 1);
        this._topLabel.setFont(this._bigFont);
        this.add((Component)this._topLabel, "North");
        this._updateButton = new Button("Update Routing");
        this._updateButton.addActionListener(this);
        this.add((Component)this._updateButton, "South");
        this._routeText = new TextArea();
        this._routeText.setFont(this._textFont);
        if (this._useColor) {
            this._routeText.setBackground(Color.magenta);
        }
        this.add((Component)this._routeText, "Center");
    }

    @Override
    public Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }

    public void showDomain(CellDomainNode domainNode) {
        this._topLabel.setText(" Routing Table of " + domainNode.getName());
        this._domainNode = domainNode;
        this.updateDomain();
    }

    private void updateDomain() {
        if (this._domainNode == null) {
            return;
        }
        this._connection.send(this._domainNode.getAddress(), "getroutes", this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        Object o = event.getSource();
        if (o == this._updateButton) {
            this.updateDomain();
        }
    }

    public void clear() {
        this._topLabel.setText("<Routing Table>");
        this._routeText.setText("");
    }

    @Override
    public void frameArrived(MessageObjectFrame frame) {
        Object obj = frame.getObject();
        if (obj instanceof String) {
            this._routeText.setText(obj.toString());
        } else if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            this._routeText.setText("Routing : \n");
            for (int i = 0; i < array.length; ++i) {
                this._routeText.append(array[i].toString() + "\n");
            }
        }
    }
}

