/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.login;

import dmg.cells.applets.login.SshActionPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PanelSwitchBoard
extends SshActionPanel
implements ActionListener,
ItemListener {
    private CardLayout _cards = null;
    private Panel _cardPanel = null;
    private Panel _buttonPanel = null;
    private CheckboxGroup _checkGroup = new CheckboxGroup();
    private Font _font = new Font("TimesRoman", 0, 24);
    private boolean _useBoxes = false;
    private int _b = 14;

    @Override
    public Insets getInsets() {
        return new Insets(this._b, this._b, this._b, this._b);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int h = this._b / 2;
        g.setColor(Color.white);
        int[] xs = new int[4];
        int[] ys = new int[4];
        xs[0] = h;
        ys[0] = h;
        xs[1] = d.width - h - 1;
        ys[1] = h;
        xs[2] = d.width - h - 1;
        ys[2] = d.height - h - 1;
        xs[3] = h;
        ys[3] = d.height - h - 1;
        g.drawPolygon(xs, ys, xs.length);
    }

    public PanelSwitchBoard() {
        this(false);
    }

    public PanelSwitchBoard(boolean useBoxes) {
        this._useBoxes = useBoxes;
        if (!useBoxes) {
            this._PanelSwitchBoardButtons();
        } else {
            this._PanelSwitchBoardBoxes();
        }
    }

    private void _PanelSwitchBoardBoxes() {
        this.setBackground(new Color(190, 190, 190));
        this.setLayout(new BorderLayout());
        this._cardPanel = new Panel();
        this._cards = new CardLayout();
        this._cardPanel.setLayout(this._cards);
        BorderLayout bl = new BorderLayout();
        bl.setHgap(10);
        bl.setVgap(10);
        GridLayout gl = new GridLayout(0, 1);
        gl.setHgap(10);
        gl.setVgap(10);
        Panel leftPanel = new Panel(bl);
        this._buttonPanel = new Panel(gl);
        Label label = new Label("Panels", 1);
        label.setFont(this._font);
        Button b = new Button("Back");
        b.addActionListener(this);
        b.setFont(this._font);
        Panel centerPanel = new Panel(new BorderLayout());
        centerPanel.add((Component)this._buttonPanel, "North");
        leftPanel.add((Component)label, "North");
        leftPanel.add((Component)centerPanel, "Center");
        leftPanel.add((Component)b, "South");
        super.add((Component)leftPanel, "West");
        super.add((Component)this._cardPanel, "Center");
    }

    private void _PanelSwitchBoardButtons() {
        this.setLayout(new BorderLayout());
        this._cardPanel = new Panel();
        this._cards = new CardLayout();
        this._cardPanel.setLayout(this._cards);
        GridLayout gl = new GridLayout(0, 1);
        gl.setHgap(10);
        gl.setVgap(10);
        this._buttonPanel = new Panel(gl);
        Button b = new Button("Back");
        b.addActionListener(this);
        Label label = new Label("Panels", 1);
        label.setFont(this._font);
        this._buttonPanel.add(label);
        this._buttonPanel.add(b);
        Panel buttonFrame = new Panel(new BorderLayout());
        buttonFrame.add((Component)this._buttonPanel, "North");
        super.add((Component)buttonFrame, "West");
        super.add((Component)this._cardPanel, "Center");
    }

    public void add(Component comp, String name) {
        this._cardPanel.add(comp, name);
        if (this._useBoxes) {
            Checkbox box = new Checkbox(name, this._checkGroup, false);
            box.addItemListener(this);
            this._buttonPanel.add(box);
        } else {
            Button b = new Button(name);
            b.addActionListener(this);
            this._buttonPanel.add(b);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        String command = ((Checkbox)event.getSource()).getLabel();
        this._cards.show(this._cardPanel, command);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Back")) {
            this.informActionListeners("exit");
            return;
        }
        this._cards.show(this._cardPanel, command);
    }
}

