/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sequencing;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.sequencing.Sequence;

public abstract class StandardSequence
extends Sequence {
    public StandardSequence() {
    }

    public StandardSequence(String name) {
        super(name);
    }

    public StandardSequence(String name, int size) {
        super(name, size);
    }

    public StandardSequence(String name, int size, int initialValue) {
        super(name, size, initialValue);
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    protected abstract Number updateAndSelectSequence(Accessor var1, AbstractSession var2, String var3, int var4);

    public abstract boolean shouldAcquireValueAfterInsert();

    public abstract boolean shouldUseTransaction();

    public Object getGeneratedValue(Accessor accessor, AbstractSession writeSession, String seqName) {
        if (this.shouldUsePreallocation()) {
            return null;
        }
        Number value = this.updateAndSelectSequence(accessor, writeSession, seqName, 1);
        if (value == null) {
            throw DatabaseException.errorPreallocatingSequenceNumbers();
        }
        return value;
    }

    public Vector getGeneratedVector(Accessor accessor, AbstractSession writeSession, String seqName, int size) {
        if (this.shouldUsePreallocation()) {
            Number value = this.updateAndSelectSequence(accessor, writeSession, seqName, size);
            if (value == null) {
                throw DatabaseException.errorPreallocatingSequenceNumbers();
            }
            return this.createVector(value, seqName, size);
        }
        return null;
    }

    public boolean shouldOverrideExistingValue(String seqName, Object existingValue) {
        if (this.shouldAcquireValueAfterInsert()) {
            return true;
        }
        return existingValue instanceof BigDecimal ? ((BigDecimal)existingValue).signum() <= 0 : (existingValue instanceof BigInteger ? ((BigInteger)existingValue).signum() <= 0 : existingValue instanceof Number && ((Number)existingValue).longValue() <= 0L);
    }

    protected Vector createVector(Number sequence, String seqName, int size) {
        BigDecimal increment = new BigDecimal(1);
        BigDecimal nextSequence = sequence instanceof BigDecimal ? (BigDecimal)sequence : new BigDecimal(sequence.doubleValue());
        Vector<BigDecimal> sequencesForName = new Vector<BigDecimal>(size);
        if ((nextSequence = nextSequence.subtract(new BigDecimal(size))).doubleValue() < -1.0) {
            throw ValidationException.sequenceSetupIncorrectly(seqName);
        }
        for (int index = size; index > 0; --index) {
            nextSequence = nextSequence.add(increment);
            sequencesForName.addElement(nextSequence);
        }
        return sequencesForName;
    }

    public void setInitialValue(int initialValue) {
        if (initialValue <= 0) {
            initialValue = 1;
        }
        super.setInitialValue(initialValue);
    }
}

