/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import oracle.toplink.essentials.internal.weaving.AttributeDetails;
import oracle.toplink.essentials.internal.weaving.ClassDetails;
import oracle.toplink.essentials.internal.weaving.TopLinkMethodWeaver;
import oracle.toplink.libraries.asm.Attribute;
import oracle.toplink.libraries.asm.ClassAdapter;
import oracle.toplink.libraries.asm.ClassWriter;
import oracle.toplink.libraries.asm.CodeVisitor;
import oracle.toplink.libraries.asm.Constants;
import oracle.toplink.libraries.asm.Label;
import oracle.toplink.libraries.asm.attrs.Annotation;
import oracle.toplink.libraries.asm.attrs.RuntimeVisibleAnnotations;

public class TopLinkClassWeaver
extends ClassAdapter
implements Constants {
    public static final String VHI_CLASSNAME = "oracle.toplink.essentials.indirection.WeavedAttributeValueHolderInterface";
    public static final String VH_SHORT_SIGNATURE = "oracle/toplink/essentials/indirection/ValueHolder";
    public static final String VHI_SHORT_SIGNATURE = "oracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface";
    public static final String VHI_SIGNATURE = "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;";
    public static final String TW_SHORT_SIGNATURE = "oracle/toplink/essentials/internal/weaving/TopLinkWeaved";
    protected ClassDetails classDetails;
    public boolean alreadyWeaved = false;
    public boolean weavedVH = false;

    public TopLinkClassWeaver(ClassWriter classWriter, ClassDetails classDetails) {
        super(classWriter);
        this.classDetails = classDetails;
    }

    public void addValueHolder(AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        RuntimeVisibleAnnotations annotations = null;
        if (attributeDetails.getGetterMethodName() == null || attributeDetails.getGetterMethodName().equals("")) {
            annotations = this.getTransientAnnotation();
        }
        this.weavedVH = true;
        this.cv.visitField(2, "_toplink_" + attribute + "_vh", VHI_SIGNATURE, null, annotations);
    }

    public void addGetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        CodeVisitor cv_get_VH = this.cv.visitMethod(1, "_toplink_get" + attribute + "_vh", "()Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;", null, null);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isCoordinatedWithProperty", "()Z");
        Label l0 = new Label();
        cv_get_VH.visitJumpInsn(154, l0);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isNewlyWeavedValueHolder", "()Z");
        Label l1 = new Label();
        cv_get_VH.visitJumpInsn(153, l1);
        cv_get_VH.visitLabel(l0);
        cv_get_VH.visitVarInsn(25, 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        } else {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), "_toplink_get" + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        }
        cv_get_VH.visitVarInsn(58, 1);
        cv_get_VH.visitVarInsn(25, 1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;");
        cv_get_VH.visitJumpInsn(165, l1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitVarInsn(25, 1);
        if (attributeDetails.getSetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V");
        } else {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), "_toplink_set" + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V");
        }
        cv_get_VH.visitLabel(l1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, className, "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitInsn(176);
        cv_get_VH.visitMaxs(0, 0);
    }

    public void addSetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        CodeVisitor cv_set_value = this.cv.visitMethod(1, "_toplink_set" + attribute + "_vh", "(Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;)V", null, null);
        cv_set_value.visitVarInsn(25, 0);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitFieldInsn(181, className, "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isInstantiated", "()Z");
        Label l0 = new Label();
        cv_set_value.visitJumpInsn(153, l0);
        cv_set_value.visitVarInsn(25, 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_set_value.visitMethodInsn(182, className, attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        } else {
            cv_set_value.visitMethodInsn(182, className, "_toplink_get" + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        }
        cv_set_value.visitVarInsn(58, 2);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;");
        cv_set_value.visitVarInsn(58, 3);
        cv_set_value.visitVarInsn(25, 2);
        cv_set_value.visitVarInsn(25, 3);
        cv_set_value.visitJumpInsn(165, l0);
        cv_set_value.visitVarInsn(25, 0);
        cv_set_value.visitVarInsn(25, 3);
        cv_set_value.visitTypeInsn(192, attributeDetails.getReferenceClass().replace('.', '/'));
        if (attributeDetails.getSetterMethodName() != null) {
            cv_set_value.visitMethodInsn(182, className, attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V");
        } else {
            cv_set_value.visitMethodInsn(182, className, "_toplink_set" + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V");
        }
        cv_set_value.visitLabel(l0);
        cv_set_value.visitInsn(177);
        cv_set_value.visitMaxs(0, 0);
    }

    public void addSetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        CodeVisitor cv_set = this.cv.visitMethod(1, "_toplink_set" + attribute, "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V", null, null);
        cv_set.visitVarInsn(25, 0);
        cv_set.visitFieldInsn(180, classDetails.getClassName(), "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_set.visitVarInsn(25, 1);
        cv_set.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "setValue", "(Ljava/lang/Object;)V");
        cv_set.visitVarInsn(25, 0);
        cv_set.visitVarInsn(25, 1);
        cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute, "L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        cv_set.visitInsn(177);
        cv_set.visitMaxs(0, 0);
    }

    public void addGetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        CodeVisitor cv_get = this.cv.visitMethod(1, "_toplink_get" + attribute, "()L" + attributeDetails.getReferenceClass().replace('.', '/') + ";", null, null);
        cv_get.visitVarInsn(25, 0);
        cv_get.visitVarInsn(25, 0);
        cv_get.visitFieldInsn(180, classDetails.getClassName(), "_toplink_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;");
        cv_get.visitTypeInsn(192, attributeDetails.getReferenceClass().replace('.', '/'));
        cv_get.visitFieldInsn(181, classDetails.getClassName(), attribute, "L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        cv_get.visitVarInsn(25, 0);
        cv_get.visitFieldInsn(180, classDetails.getClassName(), attribute, "L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
        cv_get.visitInsn(176);
        cv_get.visitMaxs(0, 0);
    }

    private RuntimeVisibleAnnotations getTransientAnnotation() {
        RuntimeVisibleAnnotations attrs = new RuntimeVisibleAnnotations();
        Annotation transientAnnotation = new Annotation("Ljavax/persistence/Transient;");
        attrs.annotations.add(transientAnnotation);
        return attrs;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        for (int i = 0; i < interfaces.length; ++i) {
            String s = interfaces[i];
            if (!TW_SHORT_SIGNATURE.equals(s)) continue;
            this.alreadyWeaved = true;
            break;
        }
        if (!this.alreadyWeaved) {
            int len = 1 + interfaces.length;
            String[] newInterfaces = new String[len];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            newInterfaces[interfaces.length] = TW_SHORT_SIGNATURE;
            super.visit(version, access, name, superName, newInterfaces, sourceFile);
        } else {
            super.visit(version, access, name, superName, interfaces, sourceFile);
        }
    }

    public CodeVisitor visitMethod(int access, String methodName, String desc, String[] exceptions, Attribute attrs) {
        if (!this.alreadyWeaved) {
            return new TopLinkMethodWeaver(this, methodName, desc, this.cv.visitMethod(access, methodName, desc, exceptions, attrs));
        }
        return super.visitMethod(access, methodName, desc, exceptions, attrs);
    }

    public void visitAttribute(Attribute attr) {
        if (!this.alreadyWeaved) {
            this.cv.visitAttribute(attr);
        } else {
            super.visitAttribute(attr);
        }
    }

    public void visitEnd() {
        if (!this.alreadyWeaved) {
            CodeVisitor cv_weavedValueHolders = this.cv.visitMethod(1, "weavedValueHolders", "()Z", null, null);
            if (this.classDetails.weavedValueHolders()) {
                cv_weavedValueHolders.visitInsn(4);
            } else {
                cv_weavedValueHolders.visitInsn(3);
            }
            cv_weavedValueHolders.visitInsn(172);
            cv_weavedValueHolders.visitMaxs(0, 0);
        }
        for (AttributeDetails attributeDetails : this.classDetails.getAttributesMap().values()) {
            if (!attributeDetails.weaveValueHolders() || this.alreadyWeaved || attributeDetails.isAttributeOnSuperClass()) continue;
            this.addValueHolder(attributeDetails);
            this.addGetterMethodForValueHolder(this.classDetails, attributeDetails);
            this.addSetterMethodForValueHolder(this.classDetails, attributeDetails);
            if (!attributeDetails.isMappedWithAttributeAccess()) continue;
            this.addSetterMethodForFieldAccess(this.classDetails, attributeDetails);
            this.addGetterMethodForFieldAccess(this.classDetails, attributeDetails);
        }
        super.visitEnd();
    }
}

