/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitOfWorkChangeSet
implements Serializable,
oracle.toplink.essentials.changesets.UnitOfWorkChangeSet {
    protected transient Hashtable objectChanges;
    protected transient Hashtable newObjectChangeSets;
    protected transient IdentityHashtable cloneToObjectChangeSet;
    protected transient IdentityHashtable objectChangeSetToUOWClone;
    protected IdentityHashtable aggregateList;
    protected IdentityHashtable allChangeSets;
    protected IdentityHashtable deletedObjects;
    protected boolean hasChanges;
    protected boolean hasForcedChanges;
    private transient Vector sdkAllChangeSets;
    private transient int objectChangeSetCounter = 0;

    public UnitOfWorkChangeSet() {
        this.setHasChanges(false);
    }

    public UnitOfWorkChangeSet(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objectIn = new ObjectInputStream(byteIn);
        this.allChangeSets = (IdentityHashtable)objectIn.readObject();
        this.deletedObjects = (IdentityHashtable)objectIn.readObject();
    }

    public void addDeletedObjects(IdentityHashtable deletedObjects, AbstractSession session) {
        Enumeration enumtr = deletedObjects.keys();
        while (enumtr.hasMoreElements()) {
            Object object = enumtr.nextElement();
            this.addDeletedObject(object, session);
        }
    }

    public void addDeletedObject(Object object, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(object);
        if (!descriptor.isAggregateCollectionDescriptor()) {
            ObjectChangeSet set = descriptor.getObjectBuilder().createObjectChangeSet(object, this, false, session);
            set.setShouldBeDeleted(true);
            this.getDeletedObjects().put(set, set);
        }
    }

    public void addObjectChangeSet(ObjectChangeSet objectChanges) {
        if (objectChanges == null) {
            return;
        }
        boolean objectChangeSetHasChanges = objectChanges.hasChanges();
        if (objectChangeSetHasChanges) {
            this.setHasChanges(true);
            this.hasForcedChanges = this.hasForcedChanges || objectChanges.hasForcedChanges();
        } else {
            this.hasForcedChanges = true;
        }
        if (!objectChanges.isAggregate()) {
            if (objectChangeSetHasChanges) {
                this.getAllChangeSets().put(objectChanges, objectChanges);
            }
            if (objectChanges.getCacheKey() != null) {
                Hashtable<ObjectChangeSet, ObjectChangeSet> table = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objectChanges.getClassName());
                if (table == null) {
                    table = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                    this.getObjectChanges().put(objectChanges.getClassName(), table);
                    table.put(objectChanges, objectChanges);
                } else {
                    table.put(objectChanges, objectChanges);
                }
            }
        }
    }

    public void addNewObjectChangeSet(ObjectChangeSet objectChanges, AbstractSession session) {
        if (objectChanges == null) {
            return;
        }
        IdentityHashtable changeSetTable = (IdentityHashtable)this.getNewObjectChangeSets().get(objectChanges.getClassType(session));
        if (changeSetTable == null) {
            changeSetTable = new IdentityHashtable();
            this.getNewObjectChangeSets().put(objectChanges.getClassType(session), changeSetTable);
        }
        changeSetTable.put(objectChanges, objectChanges);
    }

    public ObjectChangeSet findObjectChangeSet(ObjectChangeSet changeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        Hashtable changes = (Hashtable)this.getObjectChanges().get(changeSet.getClassName());
        ObjectChangeSet potential = null;
        if (changes != null) {
            potential = (ObjectChangeSet)changes.get(changeSet);
        }
        if (potential == null) {
            potential = (ObjectChangeSet)this.getObjectChangeSetForClone(changeSet.getUnitOfWorkClone());
        }
        return potential;
    }

    public ObjectChangeSet findOrIntegrateObjectChangeSet(ObjectChangeSet tofind, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (tofind == null) {
            return tofind;
        }
        ObjectChangeSet localChangeSet = this.findObjectChangeSet(tofind, mergeFromChangeSet);
        if (localChangeSet == null) {
            localChangeSet = new ObjectChangeSet(tofind.getPrimaryKeys(), tofind.getClassType(), tofind.getUnitOfWorkClone(), this, tofind.isNew());
            this.addObjectChangeSetForIdentity(localChangeSet, localChangeSet.getUnitOfWorkClone());
        }
        return localChangeSet;
    }

    public void addObjectChangeSetForIdentity(ObjectChangeSet objectChanges, Object object) {
        if (objectChanges == null || object == null) {
            return;
        }
        if (objectChanges.isAggregate()) {
            this.getAggregateList().put(objectChanges, objectChanges);
        }
        this.getObjectChangeSetToUOWClone().put(objectChanges, object);
        this.getCloneToObjectChangeSet().put(object, objectChanges);
    }

    protected IdentityHashtable getAggregateList() {
        if (this.aggregateList == null) {
            this.aggregateList = new IdentityHashtable();
        }
        return this.aggregateList;
    }

    @Override
    public IdentityHashtable getAllChangeSets() {
        if (this.allChangeSets == null) {
            this.allChangeSets = new IdentityHashtable();
        }
        return this.allChangeSets;
    }

    public IdentityHashtable getCloneToObjectChangeSet() {
        if (this.cloneToObjectChangeSet == null) {
            this.cloneToObjectChangeSet = new IdentityHashtable();
        }
        return this.cloneToObjectChangeSet;
    }

    @Override
    public IdentityHashtable getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashtable();
        }
        return this.deletedObjects;
    }

    public Hashtable getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new Hashtable(2);
        }
        return this.objectChanges;
    }

    public Set<Class> findUpdatedObjectsClasses() {
        if (this.objectChanges == null || this.objectChanges.isEmpty()) {
            return null;
        }
        HashSet<Class> updatedObjectsClasses = new HashSet<Class>(this.getObjectChanges().size());
        block0: for (Hashtable table : this.getObjectChanges().values()) {
            for (ObjectChangeSet changeSet : table.keySet()) {
                if (changeSet.isNew()) continue;
                updatedObjectsClasses.add(changeSet.getClassType());
                continue block0;
            }
        }
        return updatedObjectsClasses;
    }

    @Override
    public oracle.toplink.essentials.changesets.ObjectChangeSet getObjectChangeSetForClone(Object clone) {
        if (clone == null || this.getCloneToObjectChangeSet() == null) {
            return null;
        }
        return (oracle.toplink.essentials.changesets.ObjectChangeSet)this.getCloneToObjectChangeSet().get(clone);
    }

    protected IdentityHashtable getObjectChangeSetToUOWClone() {
        if (this.objectChangeSetToUOWClone == null) {
            this.objectChangeSetToUOWClone = new IdentityHashtable();
        }
        return this.objectChangeSetToUOWClone;
    }

    @Override
    public Object getUOWCloneForObjectChangeSet(oracle.toplink.essentials.changesets.ObjectChangeSet changeSet) {
        if (changeSet == null || this.getObjectChangeSetToUOWClone() == null) {
            return null;
        }
        return this.getObjectChangeSetToUOWClone().get(changeSet);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges || !this.getDeletedObjects().isEmpty();
    }

    public void setHasChanges(boolean flag) {
        this.hasChanges = flag;
    }

    public boolean hasForcedChanges() {
        return this.hasForcedChanges;
    }

    public ObjectChangeSet mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        ObjectChangeSet localChangeSet = this.findOrIntegrateObjectChangeSet(objectChangeSet, mergeFromChangeSet);
        if (localChangeSet != null) {
            localChangeSet.mergeObjectChanges(objectChangeSet, this, mergeFromChangeSet);
        }
        return localChangeSet;
    }

    public void mergeUnitOfWorkChangeSet(UnitOfWorkChangeSet mergeFromChangeSet, AbstractSession session, boolean postCommit) {
        for (Hashtable table : mergeFromChangeSet.getObjectChanges().values()) {
            for (ObjectChangeSet objectChangeSet : table.values()) {
                if ((objectChangeSet = this.mergeObjectChanges(objectChangeSet, mergeFromChangeSet)).isNew() && !postCommit) {
                    this.addNewObjectChangeSet(objectChangeSet, session);
                    continue;
                }
                this.addObjectChangeSet(objectChangeSet);
            }
        }
        Enumeration deletedEnum = mergeFromChangeSet.getDeletedObjects().elements();
        while (deletedEnum.hasMoreElements()) {
            ObjectChangeSet objectChangeSet = (ObjectChangeSet)deletedEnum.nextElement();
            ObjectChangeSet localObjectChangeSet = this.findObjectChangeSet(objectChangeSet, mergeFromChangeSet);
            if (localObjectChangeSet == null) {
                localObjectChangeSet = objectChangeSet;
            }
            this.getDeletedObjects().put(localObjectChangeSet, localObjectChangeSet);
        }
    }

    public void putNewObjectInChangesList(ObjectChangeSet objectChangeSet, AbstractSession session) {
        this.addObjectChangeSet(objectChangeSet);
        this.removeObjectChangeSetFromNewList(objectChangeSet, session);
    }

    public void removeObjectChangeSetFromNewList(ObjectChangeSet objectChangeSet, AbstractSession session) {
        IdentityHashtable table = (IdentityHashtable)this.getNewObjectChangeSets().get(objectChangeSet.getClassType(session));
        if (table != null) {
            table.remove(objectChangeSet);
        }
    }

    public void removeObjectChangeSet(ObjectChangeSet objectChanges) {
        if (objectChanges == null) {
            return;
        }
        Object object = this.getObjectChangeSetToUOWClone().get(objectChanges);
        if (objectChanges.isAggregate()) {
            this.getAggregateList().remove(objectChanges);
        } else {
            Hashtable table = (Hashtable)this.getObjectChanges().get(object.getClass().getName());
            if (table != null) {
                table.remove(objectChanges);
            }
        }
        this.getObjectChangeSetToUOWClone().remove(objectChanges);
        if (object != null) {
            this.getCloneToObjectChangeSet().remove(object);
        }
        this.getAllChangeSets().remove(objectChanges);
    }

    protected void setCloneToObjectChangeSet(IdentityHashtable newCloneToObjectChangeSet) {
        this.cloneToObjectChangeSet = newCloneToObjectChangeSet;
    }

    protected void setObjectChanges(Hashtable objectChanges) {
        this.objectChanges = objectChanges;
    }

    protected void setObjectChangeSetToUOWClone(IdentityHashtable newObjectChangeSetToUOWClone) {
        this.objectChangeSetToUOWClone = newObjectChangeSetToUOWClone;
    }

    public Hashtable getNewObjectChangeSets() {
        if (this.newObjectChangeSets == null) {
            this.newObjectChangeSets = new Hashtable();
        }
        return this.newObjectChangeSets;
    }

    public void setInternalAllChangeSets(Vector objectChangeSets) {
        if (objectChangeSets == null) {
            return;
        }
        this.sdkAllChangeSets = objectChangeSets;
        for (int i = 0; i < objectChangeSets.size(); ++i) {
            ObjectChangeSet objChangeSet = (ObjectChangeSet)objectChangeSets.elementAt(i);
            objChangeSet.setUOWChangeSet(this);
            if (objChangeSet.isAggregate()) {
                this.getAggregateList().put(objChangeSet, objChangeSet);
            } else if (objChangeSet.shouldBeDeleted()) {
                this.getDeletedObjects().put(objChangeSet, objChangeSet);
            } else {
                this.getAllChangeSets().put(objChangeSet, objChangeSet);
            }
            if (objChangeSet.getCacheKey() == null) continue;
            Hashtable<ObjectChangeSet, ObjectChangeSet> table = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objChangeSet.getClassName());
            if (table == null) {
                table = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                this.getObjectChanges().put(objChangeSet.getClassName(), table);
            }
            table.put(objChangeSet, objChangeSet);
        }
    }
}

