/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.descriptors;

import java.util.Stack;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;

public abstract class DescriptorIterator {
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    protected IdentityHashtable visitedObjects = new IdentityHashtable();
    protected Stack visitedStack = new Stack();
    protected AbstractSession session;
    protected DatabaseMapping currentMapping;
    protected ClassDescriptor currentDescriptor;
    protected Object result;
    protected boolean shouldIterateOverIndirectionObjects = true;
    protected boolean shouldIterateOverUninstantiatedIndirectionObjects = false;
    protected boolean shouldIterateOverWrappedObjects = true;
    protected boolean shouldIterateOnIndirectionObjects = false;
    protected boolean shouldIterateOnAggregates = false;
    protected boolean shouldIterateOnPrimitives = false;
    protected boolean shouldBreak = false;
    protected int cascadeDepth = 3;

    public int getCascadeDepth() {
        return this.cascadeDepth;
    }

    public ClassDescriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public DatabaseMapping getCurrentMapping() {
        return this.currentMapping;
    }

    protected ClassDescriptor getDescriptorFor(Object object) {
        ClassDescriptor result = this.getSession().getDescriptor(object);
        if (result == null) {
            throw DescriptorException.missingDescriptor(object.getClass().getName());
        }
        return result;
    }

    public Object getResult() {
        return this.result;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getVisitedGrandparent() {
        Object parent = this.getVisitedStack().pop();
        Object result = this.getVisitedStack().peek();
        this.getVisitedStack().push(parent);
        return result;
    }

    public IdentityHashtable getVisitedObjects() {
        return this.visitedObjects;
    }

    public Object getVisitedParent() {
        return this.getVisitedStack().peek();
    }

    public Stack getVisitedStack() {
        return this.visitedStack;
    }

    protected void internalIterateAggregateObject(Object aggregateObject) {
        this.iterate(aggregateObject);
    }

    protected void internalIterateIndirectContainer(IndirectContainer container) {
        this.iterate(container);
    }

    protected void internalIteratePrimitive(Object primitiveValue) {
        this.iterate(primitiveValue);
    }

    protected void internalIterateReferenceObject(Object referenceObject) {
        this.iterate(referenceObject);
    }

    protected void internalIterateValueHolder(ValueHolderInterface valueHolder) {
        this.iterate(valueHolder);
    }

    protected abstract void iterate(Object var1);

    public void iterateForAggregateMapping(Object aggregateObject, DatabaseMapping mapping, ClassDescriptor descriptor) {
        if (aggregateObject == null) {
            return;
        }
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(descriptor);
        if (this.shouldIterateOnAggregates()) {
            this.internalIterateAggregateObject(aggregateObject);
            if (this.shouldBreak()) {
                this.setShouldBreak(false);
                return;
            }
        }
        this.iterateReferenceObjects(aggregateObject);
    }

    public void iterateIndirectContainerForMapping(IndirectContainer container, DatabaseMapping mapping) {
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnIndirectionObjects()) {
            this.internalIterateIndirectContainer(container);
        }
        if (this.shouldIterateOverUninstantiatedIndirectionObjects() || this.shouldIterateOverIndirectionObjects() && container.isInstantiated()) {
            mapping.iterateOnRealAttributeValue(this, container);
        }
    }

    public void iteratePrimitiveForMapping(Object primitiveValue, DatabaseMapping mapping) {
        if (primitiveValue == null) {
            return;
        }
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnPrimitives()) {
            this.internalIteratePrimitive(primitiveValue);
        }
    }

    public void iterateReferenceObjectForMapping(Object referenceObject, DatabaseMapping mapping) {
        if (!(this.shouldCascadeAllParts() || this.shouldCascadePrivateParts() && mapping.isPrivateOwned())) {
            return;
        }
        ClassDescriptor rd = mapping.getReferenceDescriptor();
        if (!this.shouldIterateOverWrappedObjects() && rd != null && rd.hasWrapperPolicy()) {
            return;
        }
        if (referenceObject == null) {
            return;
        }
        if (this.getVisitedObjects().containsKey(referenceObject)) {
            return;
        }
        this.getVisitedObjects().put(referenceObject, referenceObject);
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(this.getDescriptorFor(referenceObject));
        this.internalIterateReferenceObject(referenceObject);
        if (this.shouldBreak()) {
            this.setShouldBreak(false);
            return;
        }
        this.iterateReferenceObjects(referenceObject);
    }

    protected void iterateReferenceObjects(Object sourceObject) {
        this.getVisitedStack().push(sourceObject);
        this.getCurrentDescriptor().getObjectBuilder().iterate(this);
        this.getVisitedStack().pop();
    }

    public void iterateValueHolderForMapping(ValueHolderInterface valueHolder, DatabaseMapping mapping) {
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnIndirectionObjects()) {
            this.internalIterateValueHolder(valueHolder);
        }
        if (this.shouldIterateOverUninstantiatedIndirectionObjects() || this.shouldIterateOverIndirectionObjects() && valueHolder.isInstantiated()) {
            mapping.iterateOnRealAttributeValue(this, valueHolder.getValue());
        }
    }

    public void setCascadeDepth(int cascadeDepth) {
        this.cascadeDepth = cascadeDepth;
    }

    public void setCurrentDescriptor(ClassDescriptor currentDescriptor) {
        this.currentDescriptor = currentDescriptor;
    }

    public void setCurrentMapping(DatabaseMapping currentMapping) {
        this.currentMapping = currentMapping;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setShouldBreak(boolean shouldBreak) {
        this.shouldBreak = shouldBreak;
    }

    public void setShouldIterateOnAggregates(boolean shouldIterateOnAggregates) {
        this.shouldIterateOnAggregates = shouldIterateOnAggregates;
    }

    public void setShouldIterateOnIndirectionObjects(boolean shouldIterateOnIndirectionObjects) {
        this.shouldIterateOnIndirectionObjects = shouldIterateOnIndirectionObjects;
    }

    public void setShouldIterateOnPrimitives(boolean shouldIterateOnPrimitives) {
        this.shouldIterateOnPrimitives = shouldIterateOnPrimitives;
    }

    public void setShouldIterateOverIndirectionObjects(boolean shouldIterateOverIndirectionObjects) {
        this.shouldIterateOverIndirectionObjects = shouldIterateOverIndirectionObjects;
    }

    public void setShouldIterateOverUninstantiatedIndirectionObjects(boolean shouldIterateOverUninstantiatedIndirectionObjects) {
        this.shouldIterateOverUninstantiatedIndirectionObjects = shouldIterateOverUninstantiatedIndirectionObjects;
    }

    public void setShouldIterateOverWrappedObjects(boolean shouldIterateOverWrappedObjects) {
        this.shouldIterateOverWrappedObjects = shouldIterateOverWrappedObjects;
    }

    public void setVisitedObjects(IdentityHashtable visitedObjects) {
        this.visitedObjects = visitedObjects;
    }

    protected void setVisitedStack(Stack visitedStack) {
        this.visitedStack = visitedStack;
    }

    public boolean shouldBreak() {
        return this.shouldBreak;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadeDepth() == 3;
    }

    public boolean shouldCascadeNoParts() {
        return this.getCascadeDepth() == 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadeDepth() == 3 || this.getCascadeDepth() == 2;
    }

    public boolean shouldIterateOnAggregates() {
        return this.shouldIterateOnAggregates;
    }

    public boolean shouldIterateOnIndirectionObjects() {
        return this.shouldIterateOnIndirectionObjects;
    }

    public boolean shouldIterateOnPrimitives() {
        return this.shouldIterateOnPrimitives;
    }

    public boolean shouldIterateOverIndirectionObjects() {
        return this.shouldIterateOverIndirectionObjects;
    }

    public boolean shouldIterateOverUninstantiatedIndirectionObjects() {
        return this.shouldIterateOverUninstantiatedIndirectionObjects;
    }

    public boolean shouldIterateOverWrappedObjects() {
        return this.shouldIterateOverWrappedObjects;
    }

    public void startIterationOn(Object sourceObject) {
        if (this.getVisitedObjects().containsKey(sourceObject)) {
            return;
        }
        this.getVisitedObjects().put(sourceObject, sourceObject);
        this.setCurrentMapping(null);
        this.setCurrentDescriptor(this.getSession().getDescriptor(sourceObject));
        this.iterate(sourceObject);
        if (this.getCurrentDescriptor() != null && !this.shouldCascadeNoParts() && !this.shouldBreak()) {
            this.iterateReferenceObjects(sourceObject);
        }
    }
}

