/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import javax.jdo.JDOException;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class EntityTransactionImpl
implements EntityTransaction {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    ObjectManager om;

    public EntityTransactionImpl(ObjectManager om) {
        this.om = om;
    }

    public boolean isActive() {
        return this.om.getTransaction().isActive();
    }

    public void begin() {
        this.assertNotActive();
        try {
            this.om.getTransaction().begin();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
        catch (JDOException jdoe) {
            throw NucleusJPAHelper.getJPAExceptionForJDOException(jdoe);
        }
    }

    public void commit() {
        this.assertActive();
        if (this.om.getTransaction().getRollbackOnly()) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug((Object)LOCALISER.msg("015020"));
            }
            throw new RollbackException(LOCALISER.msg("015020"));
        }
        try {
            this.om.getTransaction().commit();
        }
        catch (NucleusTransactionException jpte) {
            Throwable cause = jpte.getCause();
            PersistenceException pe = null;
            pe = cause instanceof JDOException ? NucleusJPAHelper.getJPAExceptionForJDOException((JDOException)cause) : NucleusJPAHelper.getJPAExceptionForNucleusException((NucleusException)cause);
            throw new RollbackException(LOCALISER.msg("015007"), (Throwable)pe);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
        catch (JDOException jdoe) {
            throw NucleusJPAHelper.getJPAExceptionForJDOException(jdoe);
        }
    }

    public void rollback() {
        this.assertActive();
        try {
            this.om.getTransaction().rollback();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
        catch (JDOException jdoe) {
            throw NucleusJPAHelper.getJPAExceptionForJDOException(jdoe);
        }
    }

    public boolean getRollbackOnly() {
        this.assertActive();
        return this.om.getTransaction().getRollbackOnly();
    }

    public void setRollbackOnly() {
        this.assertActive();
        this.om.getTransaction().setRollbackOnly();
    }

    public void setOption(String option, int value) {
        this.om.getTransaction().setOption(option, value);
    }

    public void setOption(String option, boolean value) {
        this.om.getTransaction().setOption(option, value);
    }

    public void setOption(String option, String value) {
        this.om.getTransaction().setOption(option, value);
    }

    protected void assertActive() {
        if (!this.om.getTransaction().isActive()) {
            throw new IllegalStateException(LOCALISER.msg("015040"));
        }
    }

    protected void assertNotActive() {
        if (this.om.getTransaction().isActive()) {
            throw new IllegalStateException(LOCALISER.msg("015032"));
        }
    }
}

