/*
 * Decompiled with CFR 0.152.
 */
package fnal.vox.security;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.globus.gsi.gssapi.SSLUtil;

public class ReadWriteSocket {
    private BufferedReader reader = null;
    private PrintStream writer = null;
    private InputStream in = null;
    private OutputStream out = null;
    private DataInputStream din = null;
    private DataOutputStream dout = null;
    private Socket clientSocket = null;
    private int MAXLENGTH = 5000;

    public ReadWriteSocket(Socket socket) {
        this.clientSocket = socket;
        try {
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            this.reader = new BufferedReader(new InputStreamReader(this.in));
            this.writer = new PrintStream(this.out);
            this.din = new DataInputStream(this.in);
            this.dout = new DataOutputStream(this.out);
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
        }
    }

    public String readLine() throws Exception {
        String string = "";
        string = this.reader.readLine();
        System.out.println("Recieved ---> " + string);
        return string;
    }

    public void writeLine(String string) throws Exception {
        this.writer.println(string);
        System.out.println("Sent ---> " + string);
    }

    public void writeToken(byte[] byArray) throws Exception {
        this.out.write(byArray);
        this.out.flush();
    }

    public void sendMessage(String string) throws Exception {
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
        this.out.flush();
    }

    public String recvMessage() throws Exception {
        String string = "";
        char[] cArray = new char[this.MAXLENGTH];
        int n = this.reader.read(cArray, 0, this.MAXLENGTH - 1);
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = cArray[i];
        }
        return String.valueOf(cArray2);
    }

    public byte[] readToken() throws Exception {
        return SSLUtil.readSslMessage((InputStream)this.in);
    }

    public byte[] readKerberosToken() throws Exception {
        byte[] byArray = new byte[this.din.readInt()];
        this.din.readFully(byArray);
        return byArray;
    }

    public void writeKerberosToken(byte[] byArray) throws Exception {
        this.dout.writeInt(byArray.length);
        this.dout.write(byArray);
        this.dout.flush();
    }

    public void closeAll() {
        try {
            this.reader.close();
            this.writer.close();
            this.din.close();
            this.dout.close();
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
        }
    }
}

