/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.portmap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dcache.xdr.OncRpcClient;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcAuthTypeNone;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.portmap.OncPortmapClient;
import org.dcache.xdr.portmap.PortmapV2Client;
import org.dcache.xdr.portmap.RpcbindV4Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPortmapClient
implements OncPortmapClient {
    private static final Logger _log = LoggerFactory.getLogger(GenericPortmapClient.class);
    private final RpcAuth _auth = new RpcAuthTypeNone();
    private final OncPortmapClient _portmapClient;

    public GenericPortmapClient(XdrTransport transport) {
        OncPortmapClient portmapClient = new RpcbindV4Client(new RpcCall(100000, 4, this._auth, transport));
        if (!portmapClient.ping()) {
            portmapClient = new PortmapV2Client(new RpcCall(100000, 2, this._auth, transport));
            if (!portmapClient.ping()) {
                throw new IllegalStateException("portmap service not available");
            }
            _log.debug("Using portmap V2");
        }
        this._portmapClient = portmapClient;
    }

    @Override
    public void dump() throws OncRpcException, IOException {
        this._portmapClient.dump();
    }

    @Override
    public boolean ping() {
        return this._portmapClient.ping();
    }

    @Override
    public boolean setPort(int program, int version, String netid2, String addr, String owner) throws OncRpcException, IOException {
        return this._portmapClient.setPort(program, version, netid2, addr, owner);
    }

    @Override
    public String getPort(int program, int version, String netid2) throws OncRpcException, IOException {
        return this._portmapClient.getPort(program, version, netid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws UnknownHostException, InterruptedException, IOException, OncRpcException {
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName("127.0.0.1"), 17, 111);
        XdrTransport transport = rpcClient.connect();
        GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
        try {
            portmapClient.ping();
            portmapClient.setPort(100003, 4, "tcp", "127.0.0.2.8.4", System.getProperty("user.name"));
            portmapClient.dump();
            System.out.println("getport: " + portmapClient.getPort(100000, 4, "tcp"));
        }
        finally {
            rpcClient.close();
        }
    }
}

