/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.gss;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.security.auth.Subject;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcAuthError;
import org.dcache.xdr.RpcAuthException;
import org.dcache.xdr.RpcAuthVerifier;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;
import org.glassfish.grizzly.Buffer;

public class RpcAuthGss
implements RpcAuth,
XdrAble {
    private final int _type = 6;
    private RpcAuthVerifier _verifier = new RpcAuthVerifier(6, new byte[0]);
    private int _version;
    private int _proc;
    private int _sequence;
    private int _service;
    private byte[] _handle;
    private Buffer _header;
    private Subject _subject = new Subject();

    public byte[] getHandle() {
        return this._handle;
    }

    public void setHandle(byte[] handle) {
        this._handle = handle;
    }

    public int getProc() {
        return this._proc;
    }

    public void setProc(int proc) {
        this._proc = proc;
    }

    public int getService() {
        return this._service;
    }

    public void setService(int svc) {
        this._service = svc;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public int type() {
        return 6;
    }

    @Override
    public RpcAuthVerifier getVerifier() {
        return this._verifier;
    }

    public void setVerifier(RpcAuthVerifier verifier) {
        this._verifier = verifier;
    }

    public int getSequence() {
        return this._sequence;
    }

    Buffer getHeader() {
        return this._header.asReadOnlyBuffer();
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        int len = xdr.xdrDecodeInt();
        this._header = ((Xdr)xdr).body().duplicate();
        this._header.limit(this._header.position() + len);
        this._header.position(this._header.position() - 32);
        this._version = xdr.xdrDecodeInt();
        this._proc = xdr.xdrDecodeInt();
        this._sequence = xdr.xdrDecodeInt();
        this._service = xdr.xdrDecodeInt();
        this._handle = xdr.xdrDecodeDynamicOpaque();
        Buffer b = ((Xdr)xdr).body().slice();
        b.order(ByteOrder.BIG_ENDIAN);
        if (b.remaining() < 4) {
            throw new RpcAuthException("bad verifier (seal broken)", new RpcAuthError(3));
        }
        int verifierSize = b.getInt();
        if (verifierSize < 0 || verifierSize > b.remaining()) {
            throw new RpcAuthException("bad verifier (seal broken)", new RpcAuthError(3));
        }
        this._verifier.xdrDecode(xdr);
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeInt(6);
        this._verifier.xdrEncode(xdr);
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

