/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xdr
implements XdrDecodingStream,
XdrEncodingStream {
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_INT = 4;
    public static final int MAX_XDR_SIZE = 524288;
    private static final Logger _log = LoggerFactory.getLogger(Xdr.class);
    protected Buffer _body;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public Xdr(int size) {
        this(MemoryManager.DEFAULT_MEMORY_MANAGER.allocate(size));
    }

    public Xdr(Buffer body) {
        this._body = body;
        this._body.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void beginDecoding() {
        this._body.rewind();
    }

    @Override
    public void endDecoding() {
        this._body.rewind();
    }

    @Override
    public void beginEncoding() {
        this._body.clear();
    }

    @Override
    public void endEncoding() {
        this._body.flip();
    }

    @Override
    public int xdrDecodeInt() {
        int val = this._body.getInt();
        _log.debug("Decoding int {}", (Object)val);
        return val;
    }

    @Override
    public int[] xdrDecodeIntVector() {
        int len = this.xdrDecodeInt();
        _log.debug("Decoding int array with len = {}", (Object)len);
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            ints[i] = this.xdrDecodeInt();
        }
        return ints;
    }

    public long[] xdrDecodeLongVector() {
        int len = this.xdrDecodeInt();
        _log.debug("Decoding long array with len = {}", (Object)len);
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = this.xdrDecodeLong();
        }
        return longs;
    }

    @Override
    public void xdrDecodeOpaque(byte[] buf, int offset, int len) {
        int padding = 4 - (len & 3) & 3;
        _log.debug("padding zeros: {}", (Object)padding);
        this._body.get(buf, offset, len);
        this._body.position(this._body.position() + padding);
    }

    public void xdrDecodeOpaque(byte[] buf, int len) {
        this.xdrDecodeOpaque(buf, 0, len);
    }

    @Override
    public byte[] xdrDecodeOpaque(int len) {
        byte[] opaque = new byte[len];
        this.xdrDecodeOpaque(opaque, len);
        return opaque;
    }

    @Override
    public byte[] xdrDecodeDynamicOpaque() {
        int length = this.xdrDecodeInt();
        byte[] opaque = new byte[length];
        if (length != 0) {
            this.xdrDecodeOpaque(opaque, 0, length);
        }
        return opaque;
    }

    @Override
    public String xdrDecodeString() {
        String ret;
        int len = this.xdrDecodeInt();
        _log.debug("Decoding string with len = {}", (Object)len);
        if (len > 0) {
            byte[] bytes = new byte[len];
            this.xdrDecodeOpaque(bytes, 0, len);
            ret = new String(bytes);
        } else {
            ret = "";
        }
        return ret;
    }

    @Override
    public boolean xdrDecodeBoolean() {
        int bool = this.xdrDecodeInt();
        return bool != 0;
    }

    @Override
    public long xdrDecodeLong() {
        return this._body.getLong();
    }

    @Override
    public ByteBuffer xdrDecodeByteBuffer() {
        int len = this.xdrDecodeInt();
        int padding = 4 - (len & 3) & 3;
        ByteBuffer slice = this._body.toByteBuffer().slice();
        slice.rewind();
        slice.limit(len);
        this._body.position(this._body.position() + len + padding);
        return slice;
    }

    @Override
    public void xdrEncodeInt(int value) {
        _log.debug("Encode int {}", (Object)value);
        this.ensureCapacity(4);
        this._body.putInt(value);
    }

    public Buffer body() {
        return this._body;
    }

    @Override
    public void xdrEncodeIntVector(int[] values) {
        _log.debug("Encode int array {}", (Object)Arrays.toString(values));
        this.ensureCapacity(4 + 4 * values.length);
        this._body.putInt(values.length);
        for (int value : values) {
            this._body.putInt(value);
        }
    }

    public void xdrEncodeLongVector(long[] values) {
        _log.debug("Encode int array {}", (Object)Arrays.toString(values));
        this.ensureCapacity(4 + 8 * values.length);
        this._body.putInt(values.length);
        for (long value : values) {
            this._body.putLong(value);
        }
    }

    @Override
    public void xdrEncodeString(String string) {
        _log.debug("Encode String:  {}", (Object)string);
        if (string == null) {
            string = "";
        }
        this.xdrEncodeDynamicOpaque(string.getBytes());
    }

    @Override
    public void xdrEncodeOpaque(byte[] bytes, int offset, int len) {
        _log.debug("Encode Opaque, len = {}", (Object)len);
        int padding = 4 - (len & 3) & 3;
        this.ensureCapacity(len + padding);
        this._body.put(bytes, offset, len);
        this._body.put(paddingZeros, 0, padding);
    }

    @Override
    public void xdrEncodeOpaque(byte[] bytes, int len) {
        this.xdrEncodeOpaque(bytes, 0, len);
    }

    @Override
    public void xdrEncodeDynamicOpaque(byte[] opaque) {
        this.xdrEncodeInt(opaque.length);
        this.xdrEncodeOpaque(opaque, 0, opaque.length);
    }

    @Override
    public void xdrEncodeBoolean(boolean bool) {
        this.xdrEncodeInt(bool ? 1 : 0);
    }

    @Override
    public void xdrEncodeLong(long value) {
        this.ensureCapacity(8);
        this._body.putLong(value);
    }

    @Override
    public void xdrEncodeByteBuffer(ByteBuffer buf) {
        buf.flip();
        int len = buf.remaining();
        int padding = 4 - (len & 3) & 3;
        this.xdrEncodeInt(len);
        this.ensureCapacity(len + padding);
        this._body.put(buf);
        this._body.position(this._body.position() + padding);
    }

    public void close() {
        this._body.tryDispose();
    }

    private void ensureCapacity(int size) {
        if (this._body.remaining() < size) {
            int oldCapacity = this._body.capacity();
            int newCapacity = Math.max(oldCapacity * 3 / 2 + 1, oldCapacity + size);
            if (this._body.isComposite()) {
                Buffer addon = MemoryManager.DEFAULT_MEMORY_MANAGER.allocate(newCapacity - this._body.capacity());
                ((CompositeBuffer)this._body).append((Object)addon);
            } else {
                this._body = MemoryManager.DEFAULT_MEMORY_MANAGER.reallocate(this._body, newCapacity);
            }
        }
    }
}

