/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import org.dcache.xdr.GrizzlyXdrTransport;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.RpcException;
import org.dcache.xdr.RpcMessage;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.Xdr;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcProtocolFilter
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(RpcProtocolFilter.class);
    private final ReplyQueue<Integer, RpcReply> _replyQueue;

    public RpcProtocolFilter() {
        this(null);
    }

    public RpcProtocolFilter(ReplyQueue<Integer, RpcReply> replyQueue) {
        this._replyQueue = replyQueue;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Xdr xdr = (Xdr)ctx.getMessage();
        if (xdr == null) {
            _log.error("Parser returns bad XDR");
            return ctx.getStopAction();
        }
        xdr.beginDecoding();
        RpcMessage message = new RpcMessage(xdr);
        GrizzlyXdrTransport transport = new GrizzlyXdrTransport(ctx);
        if (message.type() == 0) {
            RpcCall call = new RpcCall(message.xid(), xdr, transport);
            try {
                call.accept();
                ctx.setMessage((Object)call);
            }
            catch (RpcException e) {
                call.reject(e.getStatus(), e.getRpcReply());
                _log.info("RPC request rejected: {}", (Object)e.getMessage());
                return ctx.getStopAction();
            }
            catch (OncRpcException e) {
                _log.info("failed to process RPC request: {}", (Object)e.getMessage());
                return ctx.getStopAction();
            }
        }
        try {
            RpcReply reply = new RpcReply(message.xid(), xdr, transport);
            if (this._replyQueue != null) {
                this._replyQueue.put(message.xid(), reply);
            }
        }
        catch (OncRpcException e) {
            _log.warn("failed to decode reply:", (Throwable)e);
        }
        return ctx.getInvokeAction();
    }
}

