/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.xdr.MismatchInfo;
import org.dcache.xdr.OncRpcAcceptedException;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcRejectedException;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcCredential;
import org.dcache.xdr.RpcMessage;
import org.dcache.xdr.RpcMismatchReply;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCall {
    private static final Logger _log = LoggerFactory.getLogger(RpcCall.class);
    private static final AtomicInteger NEXT_XID = new AtomicInteger(0);
    private int _xid;
    private static final int RPCVERS = 2;
    private int _prog;
    private int _version;
    private int _proc;
    private int _rpcvers;
    private RpcAuth _cred;
    private final XdrTransport _transport;
    private final Xdr _xdr;

    public RpcCall(int prog, int ver, RpcAuth cred, XdrTransport transport) {
        this(prog, ver, cred, new Xdr(524288), transport);
    }

    public RpcCall(int prog, int ver, RpcAuth cred, Xdr xdr, XdrTransport transport) {
        this._prog = prog;
        this._version = ver;
        this._cred = cred;
        this._transport = transport;
        this._xdr = xdr;
        this._proc = 0;
    }

    public RpcCall(int xid, Xdr xdr, XdrTransport transport) {
        this._xid = xid;
        this._xdr = xdr;
        this._transport = transport;
    }

    public RpcCall(int xid, int prog, int ver, int proc, RpcAuth cred, Xdr xdr, XdrTransport transport) {
        this._xid = xid;
        this._prog = prog;
        this._version = ver;
        this._proc = proc;
        this._cred = cred;
        this._xdr = xdr;
        this._transport = transport;
        this._rpcvers = 2;
    }

    public void accept() throws IOException, OncRpcException {
        this._rpcvers = this._xdr.xdrDecodeInt();
        if (this._rpcvers != 2) {
            throw new RpcMismatchReply(this._rpcvers, 2);
        }
        this._prog = this._xdr.xdrDecodeInt();
        this._version = this._xdr.xdrDecodeInt();
        this._proc = this._xdr.xdrDecodeInt();
        this._cred = RpcCredential.decode(this._xdr);
    }

    public int getProgram() {
        return this._prog;
    }

    public int getProgramVersion() {
        return this._version;
    }

    public int getProcedure() {
        return this._proc;
    }

    public RpcAuth getCredential() {
        return this._cred;
    }

    public XdrTransport getTransport() {
        return this._transport;
    }

    public int getXid() {
        return this._xid;
    }

    public Xdr getXdr() {
        return this._xdr;
    }

    public String toString() {
        return String.format("RPCv%d call: program=%d, version=%d, procedure=%d", this._rpcvers, this._prog, this._version, this._proc);
    }

    public void reject(int status, XdrAble reason) {
        Xdr xdr = this._xdr;
        try {
            RpcMessage replyMessage = new RpcMessage(this._xid, 1);
            xdr.beginEncoding();
            replyMessage.xdrEncode(this._xdr);
            xdr.xdrEncodeInt(1);
            xdr.xdrEncodeInt(status);
            reason.xdrEncode(this._xdr);
            xdr.endEncoding();
            this._transport.send(xdr);
        }
        catch (OncRpcException e) {
            _log.warn("Xdr exception: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            _log.error("Failed send reply: {}", (Object)e.getMessage());
        }
    }

    public void reply(XdrAble reply) {
        this.acceptedReply(0, reply);
    }

    public void acceptedReply(int state, XdrAble reply) {
        Xdr xdr = this._xdr;
        try {
            RpcMessage replyMessage = new RpcMessage(this._xid, 1);
            xdr.beginEncoding();
            replyMessage.xdrEncode(this._xdr);
            xdr.xdrEncodeInt(0);
            this._cred.getVerifier().xdrEncode(xdr);
            xdr.xdrEncodeInt(state);
            reply.xdrEncode(xdr);
            xdr.endEncoding();
            this._transport.send(xdr);
        }
        catch (OncRpcException e) {
            _log.warn("Xdr exception: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            _log.error("Failed send reply: {}", (Object)e.getMessage());
        }
    }

    public void retrieveCall(XdrAble args) throws OncRpcException, IOException {
        args.xdrDecode(this._xdr);
        this._xdr.endDecoding();
    }

    public void failProgramMismatch(int min, int max) {
        this.acceptedReply(2, new MismatchInfo(min, max));
    }

    public void failProgramUnavailable() {
        this.acceptedReply(1, XdrVoid.XDR_VOID);
    }

    public void failProcedureUnavailable() {
        this.acceptedReply(3, XdrVoid.XDR_VOID);
    }

    public void call(int procedure, XdrAble args, XdrAble result) throws OncRpcException, IOException {
        this.call(procedure, args, result, Integer.MAX_VALUE);
    }

    public void call(int procedure, XdrAble args, XdrAble result, int timeout) throws OncRpcException, IOException {
        RpcReply reply;
        int xid = NEXT_XID.incrementAndGet();
        Xdr xdr = new Xdr(524288);
        xdr.beginEncoding();
        RpcMessage rpcMessage = new RpcMessage(xid, 0);
        rpcMessage.xdrEncode(xdr);
        xdr.xdrEncodeInt(2);
        xdr.xdrEncodeInt(this._prog);
        xdr.xdrEncodeInt(this._version);
        xdr.xdrEncodeInt(procedure);
        this._cred.xdrEncode(xdr);
        args.xdrEncode(xdr);
        xdr.endEncoding();
        this._transport.getReplyQueue().registerKey(xid);
        this._transport.send(xdr);
        try {
            reply = this._transport.getReplyQueue().get(xid, timeout);
            if (reply == null) {
                _log.info("Did not get reply in time");
                throw new IOException("Did not get reply in time");
            }
        }
        catch (InterruptedException e) {
            _log.error("call processing interrupted");
            throw new IOException(e.getMessage());
        }
        if (!reply.isAccepted() || reply.getAcceptStatus() != 0) {
            _log.info("reply not succeeded {0}", (Object)reply);
            if (reply.isAccepted()) {
                throw new OncRpcAcceptedException(reply.getAcceptStatus());
            }
            throw new OncRpcRejectedException(reply.getRejectStatus());
        }
        reply.getReplyResult(result);
    }
}

