/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrTransport;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.asyncqueue.PushBackContext;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyXdrTransport
implements XdrTransport {
    private final FilterChainContext _context;
    private static final PushBackHandler RERTY_ON_PUSHBACK = new RetryPushBackHandler();
    private static final Logger _log = LoggerFactory.getLogger(GrizzlyXdrTransport.class);

    public GrizzlyXdrTransport(FilterChainContext context) {
        this._context = context;
    }

    @Override
    public void send(Xdr xdr) throws IOException {
        Buffer buffer = xdr.body();
        buffer.allowBufferDispose(true);
        this._context.write(this._context.getAddress(), (Object)buffer, null, RERTY_ON_PUSHBACK);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this._context.getConnection().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this._context.getAddress();
    }

    @Override
    public ReplyQueue<Integer, RpcReply> getReplyQueue() {
        return null;
    }

    private static class RetryPushBackHandler
    implements PushBackHandler {
        private RetryPushBackHandler() {
        }

        public void onAccept(Connection connection, WritableMessage message) {
        }

        public void onPushBack(Connection connection, WritableMessage message, PushBackContext pushBackContext) {
            pushBackContext.retryWhenPossible();
        }
    }
}

