/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.client;

import java.rmi.RemoteException;
import java.util.TreeSet;
import java.util.Vector;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.ctx.provider.BaseObligationHandler;
import org.opensaml.xacml.ctx.provider.ObligationProcessingContext;
import org.opensaml.xacml.ctx.provider.ObligationProcessingException;
import org.opensaml.xacml.ctx.provider.ObligationService;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensciencegrid.authz.xacml.client.LocalIDObligationHandler;
import org.opensciencegrid.authz.xacml.client.XACMLClient;
import org.opensciencegrid.authz.xacml.common.LocalId;
import org.opensciencegrid.authz.xacml.stubs.Response;

public class MapCredentialsClient
extends XACMLClient {
    public LocalId mapCredentials(String string) throws Exception {
        StatusType statusType;
        Response response = null;
        try {
            response = this.authorize(string);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType = this.convertToXACML(response);
        ResultType resultType = xACMLAuthzDecisionStatementType.getResponse().getResult();
        if (resultType.getDecision().getDecision() == DecisionType.DECISION.Indeterminate && (statusType = resultType.getStatus()) != null && statusType.getStatusCode().getValue().equals("urn:oasis:names:tc:xacml:1.0:status:processing-error")) {
            String string2 = statusType.getStatusMessage().getValue();
            throw new Exception("XACML server error: " + string2);
        }
        statusType = new ObligationProcessingContext(resultType);
        ObligationService obligationService = new ObligationService();
        LocalIDObligationHandler localIDObligationHandler = new LocalIDObligationHandler();
        obligationService.addObligationhandler(localIDObligationHandler.getSubjectHandler());
        obligationService.addObligationhandler(localIDObligationHandler.getUIDGIDHandler());
        obligationService.addObligationhandler(localIDObligationHandler.getSecondaryGIDSHandler());
        TreeSet<String> treeSet = new TreeSet<String>();
        for (BaseObligationHandler baseObligationHandler : obligationService.getObligationHandlers()) {
            treeSet.add(baseObligationHandler.getObligationId());
        }
        ObligationsType obligationsType = statusType.getAuthorizationDecisionResult().getObligations();
        for (ObligationType obligationType : obligationsType.getObligations()) {
            if (treeSet.contains(obligationType.getObligationId())) continue;
            throw new ObligationProcessingException("Unknown obligation in response: " + obligationType.getObligationId());
        }
        try {
            obligationService.processObligations((ObligationProcessingContext)statusType);
        }
        catch (ObligationProcessingException obligationProcessingException) {
            logger.error((Object)("Exception in obligation handling " + obligationProcessingException.getMessage()));
            throw obligationProcessingException;
        }
        return localIDObligationHandler.getLocalID();
    }

    Response authorize(String string) throws RemoteException {
        String string2 = null;
        SubjectType subjectType = this.getSubjectType(string2);
        ResourceType resourceType = this.getResourceType(string2);
        ActionType actionType = this.getActionType(string2);
        Vector<String> vector = new Vector<String>();
        vector.add("http://authz-interop.org/xacml/obligation/username");
        vector.add("http://authz-interop.org/xacml/obligation/uidgid");
        vector.add("http://authz-interop.org/xacml/obligation/secondary-gids");
        EnvironmentType environmentType = MapCredentialsClient.getEnvironmentType(vector, string2);
        return this.authorize(subjectType, resourceType, actionType, environmentType, string);
    }
}

