/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.StorageInfoExtractable;
import diskCacheV111.vehicles.StorageInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPnfsExtractor
implements StorageInfoExtractable {
    @Override
    public StorageInfo getStorageInfo(String pnfsMountpoint, PnfsId pnfsId) throws CacheException {
        try {
            PnfsFile x = PnfsFile.getFileByPnfsId(pnfsMountpoint, pnfsId);
            if (x == null) {
                throw new CacheException(37, "Not a valid PnfsId " + pnfsId);
            }
            if (x.isDirectory()) {
                return this.extractDirectory(pnfsMountpoint, x);
            }
            if (x.isFile()) {
                StorageInfo storageInfo = this.extractFile(pnfsMountpoint, x);
                if (storageInfo.getFileSize() == 0L) {
                    storageInfo.setFileSize(x.length());
                }
                if (!storageInfo.isStored()) {
                    storageInfo.setIsStored(!"<Unknown>".equals(storageInfo.getBitfileId()));
                }
                if (!storageInfo.isStored()) {
                    storageInfo.setIsNew(storageInfo.getFileSize() == 0L && x.getLevelFile(2).length() == 0L);
                }
                return storageInfo;
            }
            if (x.isLink()) {
                return this.getStorageInfo(pnfsMountpoint, new PnfsFile(x.getCanonicalPath()).getPnfsId());
            }
            throw new CacheException(34, "Invalid file type " + pnfsId);
        }
        catch (IOException e) {
            throw new CacheException(33, "Unexpected IO exeption: " + e);
        }
    }

    @Override
    public abstract void setStorageInfo(String var1, PnfsId var2, StorageInfo var3, int var4) throws CacheException;

    protected abstract StorageInfo extractDirectory(String var1, PnfsFile var2) throws CacheException;

    protected abstract StorageInfo extractFile(String var1, PnfsFile var2) throws CacheException;

    protected List<String> readLines(File file) throws CacheException {
        BufferedReader br = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                line = line.trim();
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw new CacheException(37, "File not found when opening level " + file);
        }
        catch (IOException e) {
            throw new CacheException(37, "Failed to read from level-1 " + file);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

