/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.namespace.provider.EmptyTrash;
import diskCacheV111.namespace.provider.Trash;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.PnfsId;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PnfsFile
extends File {
    private static final long serialVersionUID = -5470614764547228403L;
    private static Trash _trash = new EmptyTrash("empty trash");
    private static final Logger _logNameSpace = LoggerFactory.getLogger((String)("logger.dev.org.dcache.namespace." + PnfsFile.class.getName()));
    private static final int ST_FILE_FMT = 61440;
    private static final int ST_REGULAR = 32768;
    private static final int ST_DIRECTORY = 16384;
    private static final int ST_SYMLINK = 40960;
    private static final int ST_PERMISSION = 511;
    private static final int MODE_INDEX = 0;
    private static final int UID_INDEX = 1;
    private static final int GID_INDEX = 2;
    private static final int ACCESS_TIME_INDEX = 3;
    private static final int MODIFICATION_TIME_INDEX = 4;
    private static final int CREATION_TIME_INDEX = 5;
    private static final int NUMBER_OF_FIELDS_IN_GETATTR = 6;
    private static final int ACCESS_TIME_FACTOR = 1000;
    private static final int MODIFICATION_TIME_FACTOR = 1000;
    private static final int CREATION_TIME_FACTOR = 1000;
    private static final int MODE_BASE = 8;
    private static final int UID_BASE = 10;
    private static final int GID_BASE = 10;
    private static final int ACCESS_TIME_BASE = 16;
    private static final int MODIFICATION_TIME_BASE = 16;
    private static final int CREATION_TIME_BASE = 16;
    public static final Set<FileAttribute> GETATTR_ATTRIBUTES = EnumSet.of(FileAttribute.ACCESS_TIME, new FileAttribute[]{FileAttribute.CREATION_TIME, FileAttribute.MODIFICATION_TIME, FileAttribute.MODE, FileAttribute.OWNER, FileAttribute.OWNER_GROUP, FileAttribute.SIMPLE_TYPE, FileAttribute.TYPE});
    private PnfsId _pnfsId;

    private static String getCanonicalPath(File f) throws CacheException {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CacheException(10011, "Failed to resolve " + f + ": " + e.getMessage());
        }
    }

    public PnfsFile(String path) throws CacheException {
        super(PnfsFile.getCanonicalPath(new File(path)));
    }

    public PnfsFile(File path, String file) throws CacheException {
        super(PnfsFile.getCanonicalPath(new File(path, file)));
    }

    private PnfsFile(String mp, String file, PnfsId id) throws CacheException {
        super(PnfsFile.getCanonicalPath(new File(mp, file)));
        this._pnfsId = id;
    }

    @Override
    public boolean exists() {
        if (this._pnfsId != null) {
            try {
                FileAttributes attributes = new FileAttributes();
                this.readGetAttr(new File(this.getParent()), attributes);
                if (attributes.getFileType() == FileType.LINK) {
                    return true;
                }
            }
            catch (CacheException ex) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return super.exists();
    }

    public void readGetAttr(File mp, FileAttributes attributes) throws CacheException, IOException {
        PnfsId pnfsId = this.getPnfsId();
        File metafile = new File(mp, ".(getattr)(" + pnfsId.getId() + ")");
        RandomAccessFile raf = new RandomAccessFile(metafile, "r");
        try {
            String line = raf.readLine();
            if (line == null) {
                throw new CacheException("Cannot read meta [" + pnfsId + "]");
            }
            try {
                String[] s = line.split(":");
                if (s.length < 6) {
                    throw new IOException("Illegal meta data format : " + pnfsId + " (" + line + ")");
                }
                int mode = Integer.parseInt(s[0], 8);
                int uid = Integer.parseInt(s[1], 10);
                int gid = Integer.parseInt(s[2], 10);
                long accessTime = Long.parseLong(s[3], 16);
                long modificationTime = Long.parseLong(s[4], 16);
                long creationTime = Long.parseLong(s[5], 16);
                switch (mode & 0xF000) {
                    case 32768: {
                        attributes.setFileType(FileType.REGULAR);
                        break;
                    }
                    case 16384: {
                        attributes.setFileType(FileType.DIR);
                        break;
                    }
                    case 40960: {
                        attributes.setFileType(FileType.LINK);
                        break;
                    }
                    default: {
                        attributes.setFileType(FileType.SPECIAL);
                    }
                }
                attributes.setMode(mode & 0x1FF);
                attributes.setOwner(uid);
                attributes.setGroup(gid);
                attributes.setAccessTime(accessTime * 1000L);
                attributes.setModificationTime(modificationTime * 1000L);
                attributes.setCreationTime(creationTime * 1000L);
            }
            catch (NumberFormatException e) {
                throw new IOException("Illegal meta data format: " + pnfsId + " (" + line + ")");
            }
        }
        catch (FileNotFoundException e) {
            boolean deleted = PnfsFile.isDeleted(pnfsId);
            if (deleted) {
                throw new FileNotFoundCacheException("No such file or directory [" + pnfsId + "]");
            }
            throw new NotInTrashCacheException("Not in trash: " + pnfsId);
        }
        finally {
            raf.close();
        }
    }

    public boolean isPnfs() {
        if (this.isDirectory()) {
            File f = new File(this, ".(const)(x)");
            return f.exists();
        }
        if (this.isFile()) {
            String dirString = this.getParent();
            if (dirString == null) {
                return false;
            }
            File f = new File(dirString, ".(const)(x)");
            return f.exists();
        }
        return false;
    }

    @Override
    public boolean delete() {
        if (this._pnfsId == null) {
            return super.delete();
        }
        return false;
    }

    public static boolean isDeleted(PnfsId pnfsId) {
        return _trash.isFound(pnfsId.getId());
    }

    public static void setTrash(Trash trash) {
        if (trash == null) {
            throw new IllegalArgumentException("'trash' is not defined.");
        }
        _trash = trash;
    }

    public boolean setLength(long length) {
        File setSizeCommand = null;
        if (this._pnfsId == null) {
            if (!this.isFile()) {
                return false;
            }
            String dirString = this.getParent();
            if (dirString == null) {
                return false;
            }
            setSizeCommand = new File(dirString, ".(fset)(" + this.getName() + ")(size)(" + length + ")");
            if (length == 0L) {
                return true;
            }
            try {
                if (setSizeCommand.length() != 0L) {
                    setSizeCommand.delete();
                }
                setSizeCommand.createNewFile();
                return this.length() == length;
            }
            catch (IOException e) {
                return false;
            }
        }
        String parent = this.getParent();
        setSizeCommand = new File(parent, ".(pset)(" + this._pnfsId + ")(size)(" + length + ")");
        if (length == 0L) {
            return true;
        }
        try {
            if (setSizeCommand.length() != 0L) {
                setSizeCommand.delete();
            }
            setSizeCommand.createNewFile();
            return setSizeCommand.length() == length;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public File getLevelFile(int level) {
        if (level <= 0 && level > 7) {
            throw new IllegalArgumentException("Illegal Level " + level);
        }
        if (this._pnfsId != null) {
            return new File(this.getParent() + "/.(puse)(" + this._pnfsId + ")(" + level + ")");
        }
        String dirString = this.getParent();
        if (dirString == null) {
            return null;
        }
        return new File(dirString, ".(use)(" + level + ")(" + this.getName() + ")");
    }

    public PnfsId getPnfsId() throws CacheException {
        String idString;
        if (this._pnfsId != null) {
            return this._pnfsId;
        }
        if (!this.exists()) {
            throw new FileNotFoundCacheException("path " + this + " not found");
        }
        String dirString = this.getParent();
        if (dirString == null) {
            throw new FileNotFoundCacheException("path " + this + " not found");
        }
        File f = new File(dirString, ".(id)(" + this.getName() + ")");
        try {
            try {
                idString = PnfsFile.readLine(f);
            }
            catch (FileNotFoundException e) {
                try {
                    f.createNewFile();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                try {
                    idString = PnfsFile.readLine(f);
                }
                catch (FileNotFoundException ee) {
                    throw new FileNotFoundCacheException("File not found");
                }
                _logNameSpace.warn("First attempt to retrieve PNFS ID of " + this + " failed. Second attempt succeeded " + "after clearing negative cache entry. " + "This is caused by a known PNFS problem.");
            }
        }
        catch (IOException e) {
            throw new CacheException(10011, "Failed to read PNFS ID of file: " + e.getMessage());
        }
        if (idString == null) {
            throw new FileNotFoundCacheException("Path " + this + " not found (empty id file)");
        }
        return new PnfsId(idString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLine(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            String string = raf.readLine();
            return string;
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException e) {
                _logNameSpace.warn("Failed to close file [" + file + "]: ", (Throwable)e);
            }
        }
    }

    public String[] getTags() {
        if (this._pnfsId == null) {
            return this._getRealTags();
        }
        String[][] v = this.getPTags();
        String[] ar = new String[v.length];
        for (int i = 0; i < v.length; ++i) {
            ar[i] = v[0][i];
        }
        return ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getPTags() {
        if (this._pnfsId == null) {
            throw new IllegalArgumentException("Not a pFile");
        }
        String mountpoint = this.getParent();
        File f = new File(mountpoint, ".(ptags)(" + this._pnfsId + ")");
        BufferedReader br = null;
        String line = null;
        String id = null;
        String name = null;
        StringTokenizer st = null;
        ArrayList<String[]> v = new ArrayList<String[]>();
        String[] pair = null;
        try {
            br = new BufferedReader(new FileReader(f), 512);
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line);
                try {
                    id = new PnfsId(st.nextToken()).toString();
                    name = st.nextToken();
                }
                catch (Exception we) {
                    continue;
                }
                pair = new String[]{name, id};
                v.add(pair);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ee) {}
            }
        }
        String[][] sv = new String[v.size()][];
        return (String[][])v.toArray((T[])sv);
    }

    @Override
    public boolean isDirectory() {
        if (this._pnfsId == null) {
            return super.isDirectory();
        }
        String type = this.getPnfsFileType();
        return type.charAt(2) == 'I' && type.charAt(5) == 'd';
    }

    @Override
    public boolean isFile() {
        if (this._pnfsId == null) {
            return super.isFile();
        }
        String type = this.getPnfsFileType();
        return type.charAt(2) == 'I' && type.charAt(6) == 'r';
    }

    public boolean isLink() {
        if (this._pnfsId == null) {
            return super.isFile();
        }
        String type = this.getPnfsFileType();
        return type.charAt(2) == 'I' && type.charAt(7) == 'l';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPnfsFileType() {
        if (this._pnfsId == null) {
            throw new IllegalArgumentException("Not in P mode");
        }
        File f = new File(this.getParent(), ".(showid)(" + this._pnfsId + ")");
        BufferedReader br = null;
        String line = null;
        String tmp = null;
        StringTokenizer st = null;
        try {
            br = new BufferedReader(new FileReader(f), 1024);
            while (true) {
                if ((line = br.readLine()) == null) break;
                st = new StringTokenizer(line);
                try {
                    tmp = st.nextToken();
                    if (!tmp.equals("Type")) continue;
                    tmp = st.nextToken();
                    tmp = st.nextToken();
                    if (tmp.length() != 11) {
                        throw new Exception("Illegal 'showid' format");
                    }
                    String string = tmp;
                    return string;
                }
                catch (NoSuchElementException we) {
                    try {
                        continue;
                    }
                    catch (Exception e) {
                        String string = null;
                        return string;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                break;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ee) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _getRealTags() {
        if (!this.isDirectory() || !this.isPnfs()) {
            return null;
        }
        File f = new File(this, ".(tags)(x)");
        if (!f.exists()) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        BufferedReader r = null;
        try {
            String line = null;
            r = new BufferedReader(new FileReader(f), 64);
            while ((line = r.readLine()) != null) {
                v.add(line);
            }
        }
        catch (IOException ee) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ee) {}
            }
        }
        String[] a = new String[v.size()];
        int j = 0;
        for (int i = 0; i < v.size(); ++i) {
            a[j] = this.tagNameOf((String)v.get(i));
            if (a[j] == null) continue;
            ++j;
        }
        if (j < v.size()) {
            String[] b = new String[j];
            System.arraycopy(a, 0, b, 0, j);
            return b;
        }
        return a;
    }

    public static String pathfinder(File mountpoint, String pnfsId) throws IOException {
        ArrayList<String> v = new ArrayList<String>();
        while (true) {
            try {
                v.add(PnfsFile._getNameOf(mountpoint, pnfsId));
            }
            catch (IOException ioe) {
                break;
            }
            pnfsId = PnfsFile._getParentId(mountpoint, pnfsId);
        }
        if (v.size() == 0) {
            throw new IllegalArgumentException("No path for " + pnfsId);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = v.size() - 1; i >= 0; --i) {
            sb.append("/").append((String)v.get(i));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _getParentId(File mountpoint, String pnfsId) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(new File(mountpoint, ".(parent)(" + pnfsId + ")")), 32);
        try {
            String string = br.readLine().trim();
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _getNameOf(File mountpoint, String pnfsId) throws IOException {
        if (_logNameSpace.isInfoEnabled()) {
            _logNameSpace.info("nameof for pnfsid " + pnfsId);
        }
        BufferedReader br = new BufferedReader(new FileReader(new File(mountpoint, ".(nameof)(" + pnfsId + ")")), 64);
        try {
            String string = br.readLine().trim();
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PnfsId getParentId() throws CacheException {
        PnfsId pnfsId = this.getPnfsId();
        if (pnfsId != null) {
            if (_logNameSpace.isInfoEnabled()) {
                _logNameSpace.info("parent for pnfsid " + pnfsId);
            }
            File f = new File(this.getParent(), ".(parent)(" + pnfsId + ")");
            String line = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f), 32);
                line = br.readLine();
            }
            catch (IOException ioe) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ee) {}
                }
            }
            return line == null ? null : new PnfsId(line);
        }
        return null;
    }

    private String tagNameOf(String str) {
        if (!str.startsWith(".(tag)(") || !str.endsWith(")")) {
            return null;
        }
        return str.substring(7, str.length() - 1);
    }

    public String[] getTag(String tagName) {
        return this._pnfsId == null ? this._getRealTag(tagName) : this._getPTag(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _getPTag(String tagName) {
        String[][] tags = this.getPTags();
        int i = 0;
        for (i = 0; i < tags.length && !tags[i][0].equals(tagName); ++i) {
        }
        if (i == tags.length) {
            return null;
        }
        File f = new File(this.getParent(), ".(access)(" + tags[i][1] + ")");
        BufferedReader r = null;
        try {
            Vector<String> v = new Vector<String>();
            String line = null;
            r = new BufferedReader(new FileReader(f), 64);
            while ((line = r.readLine()) != null) {
                v.add(line);
            }
            String[] a = new String[v.size()];
            String[] stringArray = v.toArray(a);
            return stringArray;
        }
        catch (IOException ee) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _getRealTag(String tagName) {
        if (!this.isDirectory() || !this.isPnfs()) {
            return null;
        }
        File f = new File(this, ".(tag)(" + tagName + ")");
        if (!f.exists()) {
            return null;
        }
        BufferedReader r = null;
        try {
            Vector<String> v = new Vector<String>();
            String line = null;
            r = new BufferedReader(new FileReader(f), 32);
            while ((line = r.readLine()) != null) {
                v.add(line);
            }
            String[] a = new String[v.size()];
            String[] stringArray = v.toArray(a);
            return stringArray;
        }
        catch (IOException ee) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ee) {}
            }
        }
    }

    public static String[] getPnfsMountpoints() throws FileNotFoundException {
        String[] mountpoints = null;
        try {
            mountpoints = PnfsFile.getPnfsMountpointsFrom("/etc/mnttab");
        }
        catch (FileNotFoundException ee) {
            try {
                mountpoints = PnfsFile.getPnfsMountpointsFrom("/etc/mtab");
            }
            catch (FileNotFoundException ff) {
                throw new FileNotFoundException("Not found mnttab,mtab");
            }
        }
        return mountpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getPnfsMountpointsFrom(String mtab) throws FileNotFoundException {
        BufferedReader in = null;
        Vector<String> mountpoints = new Vector<String>();
        in = new BufferedReader(new FileReader(mtab));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String type;
                String mp;
                try {
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() < 4) continue;
                    st.nextToken();
                    mp = st.nextToken();
                    type = st.nextToken();
                }
                catch (Exception ae) {
                    continue;
                }
                if (!type.equals("nfs")) continue;
                FileInputStream pnfs = null;
                File mpf = new File(mp);
                try {
                    pnfs = new FileInputStream(new File(mpf, ".(const)(x)"));
                }
                catch (Exception ie3) {}
                continue;
                finally {
                    if (pnfs == null) continue;
                    try {
                        pnfs.close();
                    }
                    catch (IOException iie) {}
                    continue;
                }
                mountpoints.add(mp);
            }
        }
        catch (IOException e) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException xioe) {}
        }
        String[] out = new String[mountpoints.size()];
        return mountpoints.toArray(out);
    }

    public static PnfsFile getFileByPnfsId(String mountpoint, PnfsId id) throws CacheException {
        PnfsFile mp = new PnfsFile(mountpoint);
        if (!mp.isDirectory() || !mp.isPnfs()) {
            throw new IllegalArgumentException("mountpoint [" + mountpoint + "] does not exist or not in the pnfs");
        }
        PnfsFile f = new PnfsFile(mountpoint, ".(access)(" + id + ")", id);
        if (!f.exists()) {
            boolean deleted = PnfsFile.isDeleted(id);
            if (deleted) {
                throw new FileNotFoundCacheException(id.toString());
            }
            throw new CacheException(10016, "Not in trash: " + id.toString());
        }
        return f;
    }

    public static PnfsFile getFileByPnfsId(File mountpoint, PnfsId id) throws CacheException {
        PnfsFile mp = new PnfsFile(mountpoint.getAbsolutePath());
        if (!mp.isDirectory() || !mp.isPnfs()) {
            throw new IllegalArgumentException("mountpoint [" + mountpoint + "] does not exist or not in the pnfs");
        }
        PnfsFile f = new PnfsFile(mountpoint.getAbsolutePath(), ".(access)(" + id + ")", id);
        if (!f.exists()) {
            boolean deleted = PnfsFile.isDeleted(id);
            if (deleted) {
                throw new FileNotFoundCacheException(id.toString());
            }
            throw new CacheException(10016, "Not in trash: " + id.toString());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getServerAttributes(File mountpoint, String key) throws IOException {
        if (!mountpoint.exists() || !mountpoint.isDirectory()) {
            throw new IllegalArgumentException("Mountpoint doesn't exist or is not directory");
        }
        File magicFile = new File(mountpoint, ".(config)(" + key + ")");
        BufferedReader snbr = new BufferedReader(new FileReader(magicFile));
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line = null;
            while ((line = snbr.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                list.add(line);
            }
        }
        finally {
            try {
                snbr.close();
            }
            catch (IOException eeee) {}
        }
        return list;
    }

    protected static String getServerAttribute(File mountpoint, String key) throws IOException {
        List<String> list = PnfsFile.getServerAttributes(mountpoint, key);
        if (list.isEmpty()) {
            throw new IOException("Couldn't find valid value for " + key);
        }
        return list.get(0);
    }

    public static String getServerName(File mountpoint) throws IOException {
        return PnfsFile.getServerAttribute(mountpoint, "serverName");
    }

    public static String getServerRoot(File mountpoint) throws IOException {
        return PnfsFile.getServerAttribute(mountpoint, "serverRoot");
    }

    public static String getServerId(File mountpoint) throws IOException {
        return PnfsFile.getServerAttribute(mountpoint, "serverId");
    }

    public static Map<PnfsId, String> getServerRoots(File mountpoint) throws IOException {
        List<String> list = PnfsFile.getServerAttributes(mountpoint, "serverRoot");
        HashMap<PnfsId, String> map = new HashMap<PnfsId, String>();
        for (String entry : list) {
            StringTokenizer st = new StringTokenizer(entry);
            try {
                PnfsId pnfsId = new PnfsId(st.nextToken());
                String value = st.hasMoreTokens() ? st.nextToken() : ".";
                map.put(pnfsId, value);
            }
            catch (Exception e) {
                throw new IOException("Syntax error in serverRoot");
            }
        }
        return map;
    }

    public static PnfsId getMountId(File mountpoint) throws IOException {
        Map<String, String> hash = PnfsFile.getDirectoryCursor(mountpoint);
        String entry = hash.get("mountID");
        if (entry == null) {
            throw new NoSuchElementException("Syntax Error in fileysstem cursor");
        }
        return new PnfsId(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getDirectoryCursor(File directory) throws IOException {
        Hashtable<String, String> hash;
        block15: {
            if (!directory.exists() || !directory.isDirectory()) {
                throw new IllegalArgumentException("Argument doesn't exist or is not dir");
            }
            File magicFile = new File(directory, ".(get)(cursor)");
            BufferedReader snbr = new BufferedReader(new FileReader(magicFile), 128);
            hash = new Hashtable<String, String>();
            block11: while (true) {
                while (true) {
                    String tmp = null;
                    String key = null;
                    String value = null;
                    try {
                        tmp = snbr.readLine();
                        if (tmp == null) {
                        }
                    }
                    catch (EOFException ioe) {}
                    break block15;
                    StringTokenizer st = new StringTokenizer(tmp, "=");
                    try {
                        key = st.nextToken();
                        value = st.nextToken();
                        if (key.length() == 0) continue block11;
                        if (value.length() == 0) continue;
                        hash.put(key, value);
                        continue block11;
                    }
                    catch (Exception eee) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                try {
                    snbr.close();
                }
                catch (IOException eeee) {}
            }
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] listBasePnfsRoots() {
        Hashtable<String, Object[]> hash;
        block25: {
            BufferedReader br;
            hash = new Hashtable<String, Object[]>();
            File mtab = new File("/etc/mnttab");
            if (!mtab.exists() && !(mtab = new File("/etc/mtab")).exists()) {
                return new File[0];
            }
            try {
                br = new BufferedReader(new FileReader(mtab));
            }
            catch (FileNotFoundException e) {
                _logNameSpace.debug(mtab + ": " + e.getMessage());
                return new File[0];
            }
            block16: while (true) {
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line);
                        if (!st.hasMoreTokens()) continue;
                        st.nextToken();
                        if (!st.hasMoreTokens()) {
                            _logNameSpace.debug("Skipping line with only one token: " + line);
                            continue;
                        }
                        String fs = st.nextToken();
                        _logNameSpace.debug("Checking fs mounted at: " + fs);
                        File mountpoint = new File(fs);
                        try {
                            String serverName = PnfsFile.getServerName(mountpoint);
                            Map<String, String> cursor = PnfsFile.getDirectoryCursor(mountpoint);
                            String dirPerm = cursor.get("dirPerm");
                            if (dirPerm == null || dirPerm.length() < 16 || dirPerm.charAt(14) != '0') {
                                _logNameSpace.debug(fs + " failed dirPerm check.");
                                continue;
                            }
                            String mountId = cursor.get("mountID");
                            if (mountId == null) {
                                _logNameSpace.debug(fs + " failed mountID check");
                                continue;
                            }
                            PnfsId id = new PnfsId(mountId);
                            Object[] r = (Object[])hash.get(serverName);
                            if (r == null) {
                                _logNameSpace.debug("Adding " + fs + " as initial candidate for " + mountId);
                                r = new Object[]{fs, id};
                                hash.put(serverName, r);
                                continue block16;
                            }
                            PnfsId storedId = (PnfsId)r[1];
                            if (id.compareTo(storedId) < 0) {
                                _logNameSpace.debug("Updating candidate for " + mountId + " using " + fs);
                                r = new Object[]{fs, id};
                                hash.put(serverName, r);
                                continue block16;
                            }
                            _logNameSpace.debug("Ignoring candidate " + fs + " as higher mount-point already discovered");
                            continue block16;
                        }
                        catch (IOException e) {
                            _logNameSpace.debug("  skipping entry " + fs + " as it triggered " + e.getClass().getSimpleName() + ": " + e.getMessage());
                        }
                        catch (IllegalArgumentException e) {
                            _logNameSpace.debug("  skipping entry " + fs + " as it triggered " + e.getClass().getSimpleName() + ": " + e.getMessage());
                        }
                    }
                    break block25;
                }
                catch (IOException e) {
                    _logNameSpace.debug("Skipping parsing of mount-points: " + e.getMessage());
                    break block25;
                }
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ee) {
                    _logNameSpace.info("IOException whilst closing mtab file");
                }
            }
        }
        File[] results = new File[hash.size()];
        Enumeration e = hash.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Object[] x = (Object[])e.nextElement();
            results[i] = new File(x[0].toString());
            ++i;
        }
        return results;
    }

    public static List<VirtualMountPoint> getVirtualMountPoints(File mountPoint) throws IOException {
        ArrayList<VirtualMountPoint> list = new ArrayList<VirtualMountPoint>();
        PnfsId mountId = PnfsFile.getMountId(mountPoint);
        String serverName = PnfsFile.getServerName(mountPoint);
        String serverId = PnfsFile.getServerId(mountPoint);
        Map<PnfsId, String> map = PnfsFile.getServerRoots(mountPoint);
        String serverMountPath = PnfsFile.pathfinder(mountPoint, mountId.toString());
        _logNameSpace.debug("Building VirtualMountPoint for " + mountPoint);
        for (Map.Entry<PnfsId, String> entry : map.entrySet()) {
            PnfsId virtualMountId = entry.getKey();
            if (mountId.compareTo(virtualMountId) > 0) {
                _logNameSpace.debug("  skipping entry as virtualMountId (" + virtualMountId + ") is smaller than our real mountpoint (" + mountId + ")");
                continue;
            }
            String virtualPnfsPath = PnfsFile.pathfinder(mountPoint, virtualMountId.toString());
            String diff = virtualPnfsPath.substring(serverMountPath.length());
            VirtualMountPoint vmp = new VirtualMountPoint(mountPoint, serverName, serverId, mountId);
            String virtualMountPath = entry.getValue();
            vmp.setVirtual(virtualMountId, virtualPnfsPath, mountPoint + diff, "/pnfs/" + serverId + (virtualMountPath.equals(".") ? "" : (virtualMountPath.equals("*") ? diff : "/" + virtualMountPath)));
            list.add(vmp);
        }
        return list;
    }

    public static List<VirtualMountPoint> getVirtualMountPoints() throws IOException {
        File[] mountpoints = PnfsFile.listBasePnfsRoots();
        ArrayList<VirtualMountPoint> list = new ArrayList<VirtualMountPoint>();
        for (int i = 0; i < mountpoints.length; ++i) {
            try {
                list.addAll(PnfsFile.getVirtualMountPoints(mountpoints[i]));
                continue;
            }
            catch (IOException ioe) {
                _logNameSpace.debug("IOException whilst building list of virtual mount-points: " + ioe.getMessage());
                throw ioe;
            }
            catch (RuntimeException rte) {
                _logNameSpace.debug("Problem whilst building list of virtual mount-points" + rte.getClass().getSimpleName() + ":", (Throwable)rte);
                continue;
            }
            catch (Exception gioe) {
                _logNameSpace.debug("Received " + gioe.getClass().getSimpleName() + " : " + gioe.getMessage());
            }
        }
        return list;
    }

    public static void main(String[] args) {
        block80: {
            if (args.length < 1) {
                System.out.println("Usage : ... <command> <path> [arguments]");
                System.out.println("Usage : ... ispnfs <path>");
                System.out.println("Usage : ... id <path>");
                System.out.println("Usage : ... gettags <dirPath>");
                System.out.println("Usage : ... gettag <dirPath> <tagname>");
                System.out.println("Usage : ... readlevel <dirPath> <level>");
                System.out.println("Usage : ... readxlevel <mountpoint> <pnfsId> <level>");
                System.out.println("Usage : ... setsize <filePath> <size>");
                System.out.println("Usage : ... psetsize <mountpoint>  <pnfsId> <size>");
                System.out.println("Usage : ... ptag <mountpoint>  <pnfsId> [<name>]");
                System.out.println("Usage : ... mountpoints");
                System.out.println("Usage : ... xmountpoints");
                System.out.println("Usage : ... nameof <mountpoint> <pnfsId>");
                System.out.println("Usage : ... parent <mountpoint> <pnfsId>");
                System.out.println("Usage : ... length <mountpoint> <pnfsId>");
                System.out.println("Usage : ... pathfinder <mountpoint> <pnfsId>");
                System.out.println("Usage : ... analyse");
                System.exit(4);
            }
            try {
                String command = args[0];
                String path = args.length > 1 ? args[1] : "";
                PnfsFile f = new PnfsFile(path);
                if (command.equals("ispnfs")) {
                    System.out.println(path + " : " + f.isPnfs());
                    break block80;
                }
                if (command.equals("id")) {
                    PnfsId id = f.getPnfsId();
                    if (id == null) {
                        System.out.println("Can't determine pnfs id");
                    } else {
                        System.out.println(path + " : " + f.getPnfsId().toString());
                    }
                    break block80;
                }
                if (command.equals("nameof")) {
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    System.out.println(PnfsFile._getNameOf(new File(args[1]), args[2]));
                    break block80;
                }
                if (command.equals("length")) {
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    PnfsId id = new PnfsId(args[2]);
                    PnfsFile x = PnfsFile.getFileByPnfsId(f.getAbsolutePath(), id);
                    if (x == null) {
                        System.out.println("Can't get PnfsFile.getFileByPnfsId");
                        System.exit(4);
                    }
                    System.out.println(x.toString() + " : " + x.length());
                    break block80;
                }
                if (command.equals("parentof")) {
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    System.out.println(PnfsFile._getParentId(new File(args[1]), args[2]));
                    break block80;
                }
                if (command.equals("pathfinder")) {
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    System.out.println(PnfsFile.pathfinder(new File(args[1]), args[2]));
                    break block80;
                }
                if (command.equals("gettag")) {
                    String[] tag;
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    if (!f.isDirectory()) {
                        System.err.println("Not a directory : " + path);
                        System.exit(45);
                    }
                    if ((tag = f.getTag(args[2])) == null) {
                        System.out.println("Tag " + args[2] + " not found");
                        System.exit(4);
                    } else {
                        for (int j = 0; j < tag.length; ++j) {
                            System.out.println(args[1] + " : " + tag[j]);
                        }
                    }
                    break block80;
                }
                if (command.equals("gettags")) {
                    String[] tags = f.getTags();
                    if (tags == null) {
                        System.out.println("No tags found");
                        System.exit(4);
                    } else {
                        for (int j = 0; j < tags.length; ++j) {
                            System.out.println(tags[j]);
                        }
                    }
                    break block80;
                }
                if (command.equals("readlevel")) {
                    int level;
                    File lf;
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    if ((lf = f.getLevelFile(level = new Integer(args[2]).intValue())) == null) {
                        System.out.println("Can't get levelfile");
                        System.exit(4);
                    }
                    try {
                        BufferedReader r = new BufferedReader(new FileReader(lf));
                        String line = null;
                        while ((line = r.readLine()) != null) {
                            System.out.println(line);
                        }
                        r.close();
                    }
                    catch (IOException e) {
                        System.err.println("Exception : " + e);
                    }
                    break block80;
                }
                if (command.equals("ptag")) {
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    PnfsId id = new PnfsId(args[2]);
                    PnfsFile x = PnfsFile.getFileByPnfsId(f.getAbsolutePath(), id);
                    if (x == null) {
                        System.out.println("Can't get PnfsFile.getFileByPnfsId");
                        System.exit(4);
                    }
                    if (args.length == 3) {
                        String[][] tags = x.getPTags();
                        for (int i = 0; i < tags.length; ++i) {
                            System.out.println(tags[i][1] + " -> " + tags[i][0]);
                        }
                    } else {
                        String[] tag = x.getTag(args[3]);
                        if (tag == null) {
                            System.err.println("tag not found : " + args[3]);
                            System.exit(4);
                        }
                        for (int i = 0; i < tag.length; ++i) {
                            System.out.println(tag[i]);
                        }
                    }
                    break block80;
                }
                if (command.equals("getfiletype")) {
                    String fileType;
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    PnfsId id = new PnfsId(args[2]);
                    PnfsFile x = PnfsFile.getFileByPnfsId(f.getAbsolutePath(), id);
                    if (x == null) {
                        System.out.println("Can't get PnfsFileType");
                        System.exit(4);
                    }
                    if ((fileType = x.getPnfsFileType()) == null) {
                        System.err.println("Can't determine filetype");
                        System.exit(5);
                    }
                    System.out.println(fileType);
                    break block80;
                }
                if (command.equals("parent")) {
                    PnfsId parentId;
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    PnfsId id = new PnfsId(args[2]);
                    PnfsFile x = PnfsFile.getFileByPnfsId(f.getAbsolutePath(), id);
                    if (x == null) {
                        System.out.println("Can't get PnfsFileType");
                        System.exit(4);
                    }
                    if ((parentId = x.getParentId()) == null) {
                        System.err.println("Can't determine parentId");
                        System.exit(5);
                    }
                    System.out.println("" + parentId);
                    break block80;
                }
                if (command.equals("readxlevel")) {
                    if (args.length < 4) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    PnfsId id = new PnfsId(args[2]);
                    int level = new Integer(args[3]);
                    PnfsFile x = PnfsFile.getFileByPnfsId(f.getAbsolutePath(), id);
                    if (x == null) {
                        System.out.println("Can't get PnfsFile.getFileByPnfsId");
                        System.exit(4);
                    }
                    File lf = x.getLevelFile(level);
                    try {
                        BufferedReader r = new BufferedReader(new FileReader(lf));
                        String line = null;
                        while ((line = r.readLine()) != null) {
                            System.out.println(line);
                        }
                        r.close();
                    }
                    catch (IOException e) {
                        System.err.println("Exception : " + e);
                    }
                    break block80;
                }
                if (command.equals("test")) {
                    try {
                        BufferedReader r = new BufferedReader(new FileReader(f));
                        r.close();
                    }
                    catch (IOException e) {
                        System.err.println("Exception : " + e);
                    }
                    break block80;
                }
                if (command.equals("psetsize")) {
                    if (args.length < 4) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    PnfsId id = new PnfsId(args[2]);
                    PnfsFile x = PnfsFile.getFileByPnfsId(f.getAbsolutePath(), id);
                    if (x == null) {
                        System.out.println("Can't get PnfsFile.getFileByPnfsId");
                        System.exit(4);
                    }
                    int size = new Integer(args[3]);
                    boolean y = x.setLength(size);
                    System.out.println("Result : " + y);
                    break block80;
                }
                if (command.equals("setsize")) {
                    if (args.length < 3) {
                        System.err.println("Not enought arguments");
                        System.exit(45);
                    }
                    int size = new Integer(args[2]);
                    boolean x = f.setLength(size);
                    System.out.println("Result : " + x);
                    break block80;
                }
                if (command.equals("mountpoints")) {
                    String[] mps = PnfsFile.getPnfsMountpoints();
                    for (int i = 0; i < mps.length; ++i) {
                        System.out.println("" + i + " -> " + mps[i]);
                    }
                    break block80;
                }
                if (command.equals("xmountpoints")) {
                    File[] mps = PnfsFile.listBasePnfsRoots();
                    for (int i = 0; i < mps.length; ++i) {
                        System.out.println("" + i + " -> " + mps[i] + " " + PnfsFile.getServerName(mps[i]) + " " + PnfsFile.getServerRoot(mps[i]));
                    }
                    break block80;
                }
                if (!command.equals("analyse")) break block80;
                File[] mountpoints = PnfsFile.listBasePnfsRoots();
                for (int i = 0; i < mountpoints.length; ++i) {
                    File mp = mountpoints[i];
                    System.out.println("Mountpoint : " + mp);
                    System.out.print("  Mount Id    : ");
                    PnfsId mountId = null;
                    try {
                        mountId = PnfsFile.getMountId(mp);
                        System.out.println(mountId.toString());
                    }
                    catch (IOException ee) {
                        System.out.println(ee.getMessage());
                    }
                    System.out.print("  Server Name : ");
                    try {
                        System.out.println(PnfsFile.getServerName(mp));
                    }
                    catch (IOException ee) {
                        System.out.println(ee.getMessage());
                    }
                    System.out.print("  Server Id   : ");
                    try {
                        System.out.println(PnfsFile.getServerId(mp));
                    }
                    catch (IOException ee) {
                        System.out.println(ee.getMessage());
                    }
                    System.out.print("  Server Root : ");
                    try {
                        System.out.println(PnfsFile.getServerRoot(mp));
                    }
                    catch (IOException ee) {
                        System.out.println(ee.getMessage());
                    }
                    System.out.print("  Server Roots: ");
                    Map<PnfsId, String> map = null;
                    try {
                        map = PnfsFile.getServerRoots(mp);
                        System.out.println("");
                    }
                    catch (IOException ee) {
                        System.out.println(ee.getMessage());
                    }
                    String serverMountPath = PnfsFile.pathfinder(mp, mountId.toString());
                    for (Map.Entry<PnfsId, String> entry : map.entrySet()) {
                        System.out.println("    " + entry.getKey() + "  " + entry.getValue());
                        PnfsId virtualMountId = entry.getKey();
                        if (mountId.compareTo(virtualMountId) > 0) {
                            System.out.println("    -> invalid (serverId<mountId)");
                            continue;
                        }
                        String virtualMountPath = PnfsFile.pathfinder(mp, virtualMountId.toString());
                        String diff = virtualMountPath.substring(serverMountPath.length());
                        System.out.println("      VirtualMountPath : " + virtualMountPath);
                        System.out.println("      VirtualBasicPath : " + serverMountPath);
                        System.out.println("      VirtualLocalPath : " + mp + diff);
                        System.out.println("      VirtualGlobalPath: /pnfs/" + PnfsFile.getServerId(mp) + (entry.getValue().equals(".") ? "" : (entry.getValue().equals("*") ? diff : "/" + entry.getValue())));
                        System.out.println("      Diff : " + diff);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(4);
            }
            catch (CacheException ex) {
                ex.printStackTrace();
                System.exit(4);
            }
        }
    }

    public static class VirtualMountPoint {
        private File _basicMountPoint = null;
        private String _serverId = null;
        private String _serverName = null;
        private PnfsId _mountId = null;
        private String _virtualGlobalPath = null;
        private String _virtualLocalPath = null;
        private PnfsId _virtualMountId = null;
        private String _virtualPnfsPath = null;

        private VirtualMountPoint(File basicMountPoint, String serverName, String serverId, PnfsId mountId) {
            this._basicMountPoint = basicMountPoint;
            this._serverId = serverId;
            this._serverName = serverName;
            this._mountId = mountId;
        }

        private void setVirtual(PnfsId mountId, String pnfsPath, String localPath, String globalPath) {
            this._virtualMountId = mountId;
            this._virtualPnfsPath = pnfsPath;
            this._virtualLocalPath = localPath;
            this._virtualGlobalPath = globalPath;
        }

        public File getRealMountPoint() {
            return this._basicMountPoint;
        }

        public PnfsId getRealMountId() {
            return this._mountId;
        }

        public PnfsId getVirtualMountId() {
            return this._virtualMountId;
        }

        public String getServerId() {
            return this._serverId;
        }

        public String getServerName() {
            return this._serverName;
        }

        public String getVirtualPnfsPath() {
            return this._virtualPnfsPath;
        }

        public String getVirtualLocalPath() {
            return this._virtualLocalPath;
        }

        public String getVirtualGlobalPath() {
            return this._virtualGlobalPath;
        }

        public String toString() {
            return this._serverId + "@" + this._serverName + ":" + this._virtualLocalPath + " -> " + this._virtualGlobalPath;
        }
    }
}

