/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.OsmLocationExtractor;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.OSMStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.util.AbstractPnfsExtractor;

public class OsmInfoExtractor
extends AbstractPnfsExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStorageInfo(String pnfsMountpoint, PnfsId pnfsId, StorageInfo storageInfo, int accessMode) throws CacheException {
        PrintWriter pw;
        PnfsFile pnfsFile = PnfsFile.getFileByPnfsId(pnfsMountpoint, pnfsId);
        if (pnfsFile == null) {
            throw new CacheException(37, "Not a valid PnfsId " + pnfsId);
        }
        if (storageInfo.isSetBitFileId()) {
            OSMStorageInfo osm = (OSMStorageInfo)storageInfo;
            File levelFile = pnfsFile.getLevelFile(1);
            switch (accessMode) {
                case 0: {
                    if (levelFile.length() > 0L) {
                        throw new CacheException(38, "File already exits (can't overwrite mode=0)");
                    }
                }
                case 1: 
                case 2: {
                    try {
                        pw = null;
                        try {
                            pw = new PrintWriter(new FileWriter(levelFile, accessMode == 2));
                            pw.println(osm.getStore() + " " + osm.getStorageGroup() + " " + osm.getBitfileId());
                            pw.flush();
                            break;
                        }
                        finally {
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                    catch (IOException ee) {
                        throw new CacheException(107, "Problem in set(OSM)StorageInfo : " + ee);
                    }
                }
                default: {
                    throw new CacheException(39, "Illegal Access Mode : " + accessMode);
                }
            }
        }
        if (storageInfo.isSetAddLocation()) {
            File levelFile = pnfsFile.getLevelFile(1);
            switch (accessMode) {
                case 0: {
                    if (levelFile.length() > 0L) {
                        throw new CacheException(38, "File already exits (can't overwrite mode=0)");
                    }
                }
                case 1: 
                case 2: {
                    try {
                        List newLocations = storageInfo.locations();
                        pw = null;
                        try {
                            pw = new PrintWriter(new FileWriter(levelFile, accessMode == 2));
                            for (URI locationURI : newLocations) {
                                pw.println((String)new OsmLocationExtractor(locationURI).toLevels().get(1));
                            }
                            if (pw.checkError()) {
                                throw new IOException("Failed to flush data into leve1");
                            }
                            break;
                        }
                        finally {
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                    catch (IOException ee) {
                        throw new CacheException(107, "Problem in set(OSM)StorageInfo : " + ee);
                    }
                }
                default: {
                    throw new CacheException(39, "Illegal Access Mode : " + accessMode);
                }
            }
        }
    }

    @Override
    protected StorageInfo extractDirectory(String mp, PnfsFile x) throws CacheException {
        PnfsFile parentDir = null;
        if (x.isDirectory()) {
            parentDir = x;
        } else {
            PnfsId parent = x.getParentId();
            if (parent == null) {
                throw new CacheException(36, "Couldn't determine parent ID");
            }
            parentDir = PnfsFile.getFileByPnfsId(mp, parent);
        }
        String[] template = parentDir.getTag("OSMTemplate");
        String[] group = parentDir.getTag("sGroup");
        String[] spaceToken = parentDir.getTag("WriteToken");
        if (template == null || group == null || template.length == 0 || group.length == 0) {
            throw new CacheException(35, "OSM info not found in " + parentDir + "(type=" + parentDir.getPnfsFileType() + ")");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        StringTokenizer st = null;
        for (int i = 0; i < template.length; ++i) {
            st = new StringTokenizer(template[i]);
            if (st.countTokens() < 2) continue;
            hash.put(st.nextToken(), st.nextToken());
        }
        String store = (String)hash.get("StoreName");
        if (store == null) {
            throw new CacheException(37, "StoreName not found in template");
        }
        String gr = group[0].trim();
        OSMStorageInfo info = new OSMStorageInfo(store, gr);
        info.addKeys(hash);
        String[] tag = parentDir.getTag("hsmInstance");
        if (tag != null && tag.length > 0 && tag[0] != null) {
            info.setHsm(tag[0].trim().toLowerCase());
        }
        if (spaceToken != null) {
            info.setKey("writeToken", spaceToken[0].trim());
        }
        return info;
    }

    @Override
    protected StorageInfo extractFile(String mp, PnfsFile pnfsFile) throws CacheException {
        StorageInfo storageInfo;
        File level = pnfsFile.getLevelFile(1);
        if (level.length() == 0L) {
            storageInfo = this.extractDirectory(mp, pnfsFile);
        } else {
            List<String> levelContent = super.readLines(level);
            assert (!levelContent.isEmpty());
            String[] fields = levelContent.get(0).split("[ \t]");
            if (fields.length < 3) {
                throw new CacheException(38, "Level 1 content of " + pnfsFile.getPnfsId() + " is invalid [" + levelContent.get(0) + "]");
            }
            storageInfo = new OSMStorageInfo(fields[0], fields[1], fields[2]);
            for (String levelEntry : levelContent) {
                if ((levelEntry = levelEntry.trim()).length() <= 0) continue;
                storageInfo.addLocation(OsmLocationExtractor.parseLevel((String)levelEntry));
            }
        }
        return storageInfo;
    }
}

