/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.OsmInfoExtractor;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class OpaqueStorageInfoExtractor
extends OsmInfoExtractor {
    private static final URI DUMMY_URI = URI.create("osm://unknown-HSM/unknown-path");
    private final int _pnfsLevel = 3;

    @Override
    public StorageInfo getStorageInfo(String pnfsMountpoint, PnfsId pnfsId) throws CacheException {
        File levelFile;
        PnfsFile pnfsFile = PnfsFile.getFileByPnfsId(pnfsMountpoint, pnfsId);
        if (pnfsFile != null && pnfsFile.isLink()) {
            try {
                pnfsFile = new PnfsFile(pnfsFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new CacheException(37, "Failed to dereference link with ID " + pnfsId);
            }
        }
        if (pnfsFile == null) {
            throw new CacheException(37, "Not a valid PNFS ID " + pnfsId);
        }
        StorageInfo info = super.getStorageInfo(pnfsMountpoint, pnfsId);
        if (pnfsFile.isFile() && (levelFile = pnfsFile.getLevelFile(3)).length() > 0L) {
            info.addLocation(DUMMY_URI);
        }
        return info;
    }

    @Override
    public void setStorageInfo(String pnfsMountpoint, PnfsId pnfsId, StorageInfo storageInfo, int accessMode) throws CacheException {
        PnfsFile pnfsFile = PnfsFile.getFileByPnfsId(pnfsMountpoint, pnfsId);
        if (pnfsFile == null) {
            throw new CacheException(107, "Not a valid PnfsId " + pnfsId);
        }
        switch (accessMode) {
            case 0: {
                File levelFile = pnfsFile.getLevelFile(3);
                if (levelFile.length() <= 0L) break;
                throw new CacheException(38, "File already exits (can't overwrite mode=0)");
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new CacheException(39, "Illegal Access Mode : " + accessMode);
            }
        }
    }
}

