/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.EnstoreStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.util.AbstractPnfsExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnstoreInfoExtractor
extends AbstractPnfsExtractor {
    private static final Logger _log = LoggerFactory.getLogger(EnstoreInfoExtractor.class);
    private static final long TWOGIG = 0x80000000L;

    @Override
    public void setStorageInfo(String pnfsMountpoint, PnfsId pnfsId, StorageInfo storageInfo, int accessMode) throws CacheException {
        if (storageInfo.isSetBitFileId()) {
            throw new CacheException(1, "Operation not suppported : setStorageInfo");
        }
    }

    protected EnstoreStorageInfo extractDirectory(String mp, PnfsFile x) throws CacheException {
        String gr;
        PnfsFile parentDir = null;
        if (x.isDirectory()) {
            parentDir = x;
        } else {
            PnfsId parent = x.getParentId();
            if (parent == null) {
                throw new CacheException(36, "Couldn't determine parent ID");
            }
            parentDir = PnfsFile.getFileByPnfsId(mp, parent);
        }
        String[] template = parentDir.getTag("OSMTemplate");
        String[] group = parentDir.getTag("storage_group");
        String[] family = parentDir.getTag("file_family");
        String[] spaceToken = parentDir.getTag("WriteToken");
        if (family == null || family.length == 0) {
            throw new CacheException(35, "Enstore info not found in " + parentDir + "(type=" + parentDir.getPnfsFileType() + ")");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        if (template != null) {
            StringTokenizer st = null;
            for (int i = 0; i < template.length; ++i) {
                st = new StringTokenizer(template[i]);
                if (st.countTokens() < 2) continue;
                hash.put(st.nextToken(), st.nextToken());
            }
        }
        gr = group == null || group.length == 0 || (gr = group[0].trim()).equals("") ? "None" : gr;
        EnstoreStorageInfo info = new EnstoreStorageInfo(gr, family[0].trim());
        info.addKeys(hash);
        if (spaceToken != null) {
            info.setKey("writeToken", spaceToken[0].trim());
        }
        return info;
    }

    @Override
    protected StorageInfo extractFile(String mp, PnfsFile x) throws CacheException {
        EnstoreStorageInfo info = null;
        File level = x.getLevelFile(4);
        long fileSize = x.length();
        if (level.length() == 0L) {
            info = this.extractDirectory(mp, x);
        } else {
            List<String> levelContent = super.readLines(level);
            if (levelContent.size() < 9) {
                throw new CacheException(37, "Level 4 content of " + x.getPnfsId() + " is invalid (nobfid)");
            }
            String volume = levelContent.get(0);
            String location = levelContent.get(1);
            String sizeStr = levelContent.get(2);
            String family = levelContent.get(3);
            String bfid = levelContent.get(8);
            try {
                long enstoreFileSize = Long.parseLong(sizeStr);
                if (fileSize != enstoreFileSize && fileSize == 1L && enstoreFileSize >= 0x80000000L) {
                    fileSize = enstoreFileSize;
                } else if (fileSize != enstoreFileSize && fileSize != 1L) {
                    _log.warn(String.format("File size mismatch: enstore=%d, pnfs=%d", enstoreFileSize, fileSize));
                }
            }
            catch (NumberFormatException nfm) {
                _log.warn("File size entry in level4 is not a valid number: " + nfm.getMessage());
            }
            family = family.trim();
            bfid = bfid.trim();
            EnstoreStorageInfo helper = this.extractDirectory(mp, x);
            info = new EnstoreStorageInfo(helper.getStorageGroup(), family, bfid);
            info.setVolume(volume);
            info.setLocation(location);
            info.setFileSize(fileSize);
        }
        return info;
    }
}

