/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace.provider;

import diskCacheV111.namespace.AbstractNameSpaceProvider;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import dmg.util.Args;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.dcache.commons.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class SQLNameSpaceProvider
extends AbstractNameSpaceProvider {
    private static Logger _logNamespace = LoggerFactory.getLogger((String)"logger.org.dcache.namespace.provider");
    private String _tableName = "cacheinfo";
    private DataSource _dbConnectionsPool;
    private final String _addCacheLocationSQL;
    private final String _getCacheLocationSQL;
    private final String _clearCacheLocationSQL;

    public SQLNameSpaceProvider(String arguments) throws Exception {
        Args args = new Args((CharSequence)arguments);
        String __cfTableName = args.getOpt("cachelocation-provider-tableName");
        if (__cfTableName != null) {
            this._tableName = __cfTableName;
        }
        this._addCacheLocationSQL = "INSERT INTO " + this._tableName + " VALUES(?,?,?)";
        this._getCacheLocationSQL = "SELECT pool FROM " + this._tableName + " WHERE pnfsid=? ORDER BY ctime DESC";
        this._clearCacheLocationSQL = "DELETE  FROM " + this._tableName + " WHERE pnfsid=? AND pool LIKE ?";
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this._dbConnectionsPool = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheLocation(Subject subject, PnfsId pnfsId, String cacheLocation) throws FileNotFoundCacheException {
        Connection dbConnection = null;
        PreparedStatement ps = null;
        try {
            boolean deleted = PnfsFile.isDeleted(pnfsId);
            if (deleted) {
                throw new FileNotFoundCacheException("no such file or directory " + pnfsId.getId());
            }
            dbConnection = this._dbConnectionsPool.getConnection();
            ps = dbConnection.prepareStatement(this._addCacheLocationSQL);
            ps.setString(1, pnfsId.toString());
            ps.setString(2, cacheLocation);
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            int result = ps.executeUpdate();
        }
        catch (SQLException e) {
            block5: {
                try {
                    String sqlState = e.getSQLState();
                    if (sqlState.startsWith("23")) break block5;
                    _logNamespace.error("Failed to add cache location: " + e);
                }
                catch (Throwable throwable) {
                    SqlHelper.tryToClose(ps);
                    SQLNameSpaceProvider.tryToClose(dbConnection);
                    throw throwable;
                }
            }
            SqlHelper.tryToClose(ps);
            SQLNameSpaceProvider.tryToClose(dbConnection);
        }
        SqlHelper.tryToClose((PreparedStatement)ps);
        SQLNameSpaceProvider.tryToClose(dbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheLocation(Subject subject, PnfsId pnfsId, String cacheLocation, boolean removeIfLast) throws CacheException {
        Connection dbConnection = null;
        PreparedStatement ps = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
            ps = dbConnection.prepareStatement(this._clearCacheLocationSQL);
            ps.setString(1, pnfsId.toString());
            ps.setString(2, cacheLocation.equals("*") ? "%" : cacheLocation);
            int result = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                _logNamespace.error("Failed to clear cache location: " + e);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(ps);
                SQLNameSpaceProvider.tryToClose(dbConnection);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)ps);
            SQLNameSpaceProvider.tryToClose(dbConnection);
        }
        SqlHelper.tryToClose((PreparedStatement)ps);
        SQLNameSpaceProvider.tryToClose(dbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCacheLocation(Subject subject, PnfsId pnfsId) throws CacheException {
        ArrayList<String> locations = new ArrayList<String>();
        Connection dbConnection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
            ps = dbConnection.prepareStatement(this._getCacheLocationSQL);
            ps.setString(1, pnfsId.toString());
            result = ps.executeQuery();
            while (result.next()) {
                locations.add(result.getString("pool"));
            }
        }
        catch (SQLException e) {
            try {
                _logNamespace.error("Failed to get cache location: " + e);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(result);
                SqlHelper.tryToClose(ps);
                SQLNameSpaceProvider.tryToClose(dbConnection);
                throw throwable;
            }
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose((PreparedStatement)ps);
            SQLNameSpaceProvider.tryToClose(dbConnection);
        }
        SqlHelper.tryToClose((ResultSet)result);
        SqlHelper.tryToClose((PreparedStatement)ps);
        SQLNameSpaceProvider.tryToClose(dbConnection);
        return locations;
    }

    static void tryToClose(Connection o) {
        try {
            if (o != null) {
                o.close();
            }
        }
        catch (SQLException e) {
            _logNamespace.error("Failed to close Connection: " + e);
        }
    }

    public String toString() {
        return "$Id: SQLNameSpaceProvider.java,v 1.19 2007-08-22 12:24:38 tigran Exp $";
    }
}

