/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace.provider;

import com.google.common.collect.Range;
import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.namespace.provider.AbstractNameSpaceProviderDecorator;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsId;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessType;
import org.dcache.auth.Subjects;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.ListHandler;
import org.dcache.namespace.PermissionHandler;
import org.dcache.util.Glob;
import org.dcache.vehicles.FileAttributes;
import org.springframework.beans.factory.annotation.Required;

public class PermissionHandlerNameSpaceProvider
extends AbstractNameSpaceProviderDecorator {
    private PermissionHandler _handler;

    public PermissionHandlerNameSpaceProvider(NameSpaceProvider inner) {
        super(inner);
    }

    @Required
    public void setPermissionHandler(PermissionHandler handler) {
        this._handler = handler;
    }

    private FileAttributes getFileAttributesForPermissionHandler(PnfsId id) throws CacheException {
        return this._inner.getFileAttributes(Subjects.ROOT, id, this._handler.getRequiredAttributes());
    }

    private FileAttributes getFileAttributesForPermissionHandler(PnfsId id, FileAttribute ... extra) throws CacheException {
        EnumSet<FileAttribute> attr = EnumSet.noneOf(FileAttribute.class);
        attr.addAll(this._handler.getRequiredAttributes());
        attr.addAll(Arrays.asList(extra));
        return this._inner.getFileAttributes(Subjects.ROOT, id, attr);
    }

    @Override
    public PnfsId createEntry(Subject subject, String path, int uid, int gid, int mode, boolean isDirectory) throws CacheException {
        File file;
        File parent;
        if (!Subjects.isRoot((Subject)subject) && (parent = (file = new File(path)).getParentFile()) != null) {
            PnfsId parentId = this.pathToPnfsid(subject, parent.toString(), true);
            FileAttributes attributes = this.getFileAttributesForPermissionHandler(parentId);
            if (isDirectory ? this._handler.canCreateSubDir(subject, attributes) != AccessType.ACCESS_ALLOWED : this._handler.canCreateFile(subject, attributes) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + path);
            }
        }
        return super.createEntry(subject, path, uid, gid, mode, isDirectory);
    }

    @Override
    public void deleteEntry(Subject subject, PnfsId pnfsId) throws CacheException {
        if (!Subjects.isRoot((Subject)subject)) {
            PnfsId parentId = super.getParentOf(subject, pnfsId);
            FileAttributes parentAttributes = this.getFileAttributesForPermissionHandler(parentId);
            FileAttributes fileAttributes = this.getFileAttributesForPermissionHandler(pnfsId, FileAttribute.TYPE);
            if (fileAttributes.getFileType() == FileType.DIR ? this._handler.canDeleteDir(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED : this._handler.canDeleteFile(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + pnfsId.toString());
            }
        }
        super.deleteEntry(subject, pnfsId);
    }

    @Override
    public void deleteEntry(Subject subject, String path) throws CacheException {
        File file;
        File parent;
        if (!Subjects.isRoot((Subject)subject) && (parent = (file = new File(path)).getParentFile()) != null) {
            PnfsId fileId = this.pathToPnfsid(subject, file.toString(), false);
            PnfsId parentId = super.pathToPnfsid(subject, parent.toString(), true);
            FileAttributes parentAttributes = this.getFileAttributesForPermissionHandler(parentId);
            FileAttributes fileAttributes = this.getFileAttributesForPermissionHandler(fileId, FileAttribute.TYPE);
            if (fileAttributes.getFileType() == FileType.DIR ? this._handler.canDeleteDir(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED : this._handler.canDeleteFile(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + path);
            }
        }
        super.deleteEntry(subject, path);
    }

    @Override
    public void renameEntry(Subject subject, PnfsId pnfsId, String newName, boolean overwrite) throws CacheException {
        boolean isDir;
        PnfsId newParentId;
        if (Subjects.isRoot((Subject)subject)) {
            super.renameEntry(subject, pnfsId, newName, overwrite);
            return;
        }
        PnfsId parentId = super.getParentOf(subject, pnfsId);
        File newFile = new File(newName);
        File newParent = newFile.getParentFile();
        try {
            newParentId = this.pathToPnfsid(subject, newParent.toString(), true);
        }
        catch (FileNotFoundCacheException e) {
            throw new NotDirCacheException("No such directory: " + newParent.toString());
        }
        FileAttributes parentAttributes = this.getFileAttributesForPermissionHandler(parentId);
        FileAttributes newParentAttributes = this.getFileAttributesForPermissionHandler(newParentId);
        FileAttributes fileAttributes = this._inner.getFileAttributes(Subjects.ROOT, pnfsId, EnumSet.of(FileAttribute.TYPE));
        boolean bl = isDir = fileAttributes.getFileType() == FileType.DIR;
        if (this._handler.canRename(subject, parentAttributes, newParentAttributes, isDir) != AccessType.ACCESS_ALLOWED) {
            throw new PermissionDeniedCacheException("Access denied: " + pnfsId.toString());
        }
        try {
            super.renameEntry(subject, pnfsId, newName, false);
        }
        catch (FileExistsCacheException e) {
            if (!overwrite) {
                throw e;
            }
            PnfsId destId = this.pathToPnfsid(subject, newName, false);
            FileAttributes destAttributes = this.getFileAttributesForPermissionHandler(destId, FileAttribute.TYPE);
            if (destAttributes.getFileType() == FileType.DIR ? this._handler.canDeleteDir(subject, newParentAttributes, destAttributes) != AccessType.ACCESS_ALLOWED : this._handler.canDeleteFile(subject, newParentAttributes, destAttributes) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + newName);
            }
            super.renameEntry(subject, pnfsId, newName, true);
        }
    }

    @Override
    public PnfsId pathToPnfsid(Subject subject, String path, boolean followLinks) throws CacheException {
        PnfsId parentId;
        FileAttributes attributes;
        File file;
        File parent;
        if (!Subjects.isRoot((Subject)subject) && (parent = (file = new File(path)).getParentFile()) != null && this._handler.canLookup(subject, attributes = this.getFileAttributesForPermissionHandler(parentId = super.pathToPnfsid(subject, parent.toString(), true))) != AccessType.ACCESS_ALLOWED) {
            throw new PermissionDeniedCacheException("Access denied: " + path);
        }
        return super.pathToPnfsid(subject, path, followLinks);
    }

    @Override
    public FileAttributes getFileAttributes(Subject subject, PnfsId pnfsId, Set<FileAttribute> attr) throws CacheException {
        if (!Subjects.isRoot((Subject)subject)) {
            EnumSet<FileAttribute> required = EnumSet.noneOf(FileAttribute.class);
            required.addAll(this._handler.getRequiredAttributes());
            required.addAll(attr);
            FileAttributes fileAttributes = super.getFileAttributes(subject, pnfsId, required);
            try {
                PnfsId parentId = this._inner.getParentOf(subject, pnfsId);
                FileAttributes parent = this.getFileAttributesForPermissionHandler(parentId);
                if (this._handler.canGetAttributes(subject, parent, fileAttributes, attr) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + pnfsId.toString());
                }
            }
            catch (FileNotFoundCacheException e) {
                // empty catch block
            }
            return fileAttributes;
        }
        return super.getFileAttributes(subject, pnfsId, attr);
    }

    @Override
    public void setFileAttributes(Subject subject, PnfsId pnfsId, FileAttributes attr) throws CacheException {
        FileAttributes attributes;
        PnfsId parentId;
        FileAttributes parentAttributes;
        if (!Subjects.isRoot((Subject)subject) && this._handler.canSetAttributes(subject, parentAttributes = this.getFileAttributesForPermissionHandler(parentId = super.getParentOf(subject, pnfsId)), attributes = this.getFileAttributesForPermissionHandler(pnfsId), attr.getDefinedAttributes()) != AccessType.ACCESS_ALLOWED) {
            throw new PermissionDeniedCacheException("Access denied: " + pnfsId.toString());
        }
        super.setFileAttributes(subject, pnfsId, attr);
    }

    @Override
    public void list(Subject subject, String path, Glob glob, Range<Integer> range, Set<FileAttribute> attrs, ListHandler handler) throws CacheException {
        if (!Subjects.isRoot((Subject)subject)) {
            PnfsId pnfsId = this.pathToPnfsid(subject, path, true);
            FileAttributes attributes = this.getFileAttributesForPermissionHandler(pnfsId, FileAttribute.TYPE);
            if (attributes.getFileType() != FileType.DIR) {
                throw new NotDirCacheException("Not a directory");
            }
            if (this._handler.canListDir(subject, attributes) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + path);
            }
        }
        super.list(subject, path, glob, range, attrs, handler);
    }
}

