/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace.provider;

import diskCacheV111.namespace.provider.Trash;
import java.io.File;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfsTrash
implements Trash {
    private final String _trash;
    private static final Logger _logger = LoggerFactory.getLogger((String)"logger.org.dcache.namespace");

    public NfsTrash(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Bad trash location");
        }
        File trashLocation = new File(location);
        if (!trashLocation.exists() || !trashLocation.isDirectory()) {
            throw new IllegalArgumentException("Directory '" + location + "' does not exist");
        }
        this._trash = location;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Trash location set: " + this._trash);
        }
    }

    @Override
    public boolean isFound(String pnfsid) {
        File inTrash = new File(this._trash, MessageFormat.format(".(intrash)({0})", pnfsid));
        return inTrash.exists();
    }
}

