/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace.provider;

import diskCacheV111.namespace.provider.Trash;
import diskCacheV111.util.PnfsIdUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.dcache.util.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTrash
implements Trash {
    private final DataSource _dataSource;
    private static final Logger _logger = LoggerFactory.getLogger((String)("logger.org.dcache.namespace." + DbTrash.class.getName()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbTrash(String jdbcUrl, String jdbcClass, String user, String password) throws SQLException {
        Connection conn = null;
        if (jdbcUrl == null || jdbcClass == null || user == null || password == null) {
            throw new IllegalArgumentException("Not enough arguments to initalize trash database");
        }
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug(MessageFormat.format("Init database args: {0}, {1}, {2}, ********", jdbcUrl, jdbcClass, user));
            }
            this._dataSource = JdbcConnectionPool.getDataSource((String)jdbcUrl, (String)jdbcClass, (String)user, (String)password);
            conn = this._dataSource.getConnection();
        }
        finally {
            try {
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFound(String pnfsid) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        String sql = "SELECT * FROM deleted WHERE pnfsid='" + pnfsid + "'";
        boolean rval = false;
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("About to execute '" + sql + "'");
            }
            conn = this._dataSource.getConnection();
            pstmt = conn.prepareStatement("SELECT * FROM deleted WHERE pnfsid=?");
            pstmt.setBytes(1, PnfsIdUtil.toBinPnfsId((String)pnfsid));
            rset = pstmt.executeQuery();
            rval = rset.next();
        }
        catch (SQLException exception) {
            _logger.error("Trash database access error" + exception);
        }
        finally {
            try {
                if (null != rset) {
                    rset.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (null != pstmt) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("SQL '" + sql + "' returned " + rval);
        }
        return rval;
    }
}

