/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace.provider;

import diskCacheV111.util.CacheException;
import diskCacheV111.vehicles.CacheInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;

public class ChecksumCollection {
    private static final String CHECKSUM_DELIMITER = ",";
    private static final String CHECKSUM_COLLECTION_FLAG = "uc";
    private static final String CHECKSUM_ADLER32_FLAG = "c";
    private final Map<ChecksumType, String> _map = new HashMap<ChecksumType, String>();

    public ChecksumCollection() {
    }

    public ChecksumCollection(String s) throws CacheException {
        this.add(s);
    }

    public void add(Collection<Checksum> checksums) throws CacheException {
        for (Checksum checksum : checksums) {
            this.put(checksum);
        }
    }

    public void add(String s) throws CacheException {
        if (s != null) {
            for (String value : s.split(CHECKSUM_DELIMITER)) {
                this.put(Checksum.parseChecksum((String)value));
            }
        }
    }

    public String get(ChecksumType type) {
        return this._map.get(type);
    }

    public void put(Checksum checksum) throws CacheException {
        ChecksumType type = checksum.getType();
        String value = checksum.getValue();
        String existingValue = this._map.get(type);
        if (existingValue == null) {
            this._map.put(type, value);
        } else if (!existingValue.equals(value)) {
            throw new CacheException(10015, "Checksum mismatch");
        }
    }

    public void remove(ChecksumType type) {
        this._map.remove(type);
    }

    public void serialize(CacheInfo info) {
        StringBuilder result = null;
        for (Map.Entry<ChecksumType, String> el : this._map.entrySet()) {
            ChecksumType type = el.getKey();
            String value = el.getValue();
            Checksum checksum = new Checksum(type, value);
            if (type == ChecksumType.ADLER32) continue;
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(CHECKSUM_DELIMITER);
            }
            result.append(checksum.toString(true));
        }
        if (result != null) {
            info.getFlags().put(CHECKSUM_COLLECTION_FLAG, result.toString());
        } else {
            info.getFlags().remove(CHECKSUM_COLLECTION_FLAG);
        }
        String adler32 = this.get(ChecksumType.ADLER32);
        if (adler32 != null) {
            Checksum checksum = new Checksum(ChecksumType.ADLER32, adler32);
            info.getFlags().put(CHECKSUM_ADLER32_FLAG, checksum.toString(false));
        } else {
            info.getFlags().remove(CHECKSUM_ADLER32_FLAG);
        }
    }

    public Set<Checksum> getChecksums() {
        HashSet<Checksum> checksums = new HashSet<Checksum>();
        for (Map.Entry<ChecksumType, String> e : this._map.entrySet()) {
            checksums.add(new Checksum(e.getKey(), e.getValue()));
        }
        return checksums;
    }

    public static ChecksumCollection extract(CacheInfo info) throws CacheException {
        CacheInfo.CacheFlags flags = info.getFlags();
        ChecksumCollection collection = new ChecksumCollection();
        collection.add(flags.get(CHECKSUM_ADLER32_FLAG));
        collection.add(flags.get(CHECKSUM_COLLECTION_FLAG));
        return collection;
    }
}

