/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace.provider;

import com.google.common.collect.Range;
import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.namespace.provider.ChecksumCollection;
import diskCacheV111.namespace.provider.DbTrash;
import diskCacheV111.namespace.provider.FsTrash;
import diskCacheV111.namespace.provider.NfsTrash;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.NotFileCacheException;
import diskCacheV111.util.PathMap;
import diskCacheV111.util.PnfsFile;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.StorageInfoExtractable;
import diskCacheV111.vehicles.CacheInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.util.Args;
import dmg.util.CollectionFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.ListHandler;
import org.dcache.util.ChecksumType;
import org.dcache.util.Glob;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class BasicNameSpaceProvider
implements NameSpaceProvider {
    private final String _mountPoint;
    private final List<PnfsFile.VirtualMountPoint> _virtualMountPoints;
    private final PathManager _pathManager;
    private final StorageInfoExtractable _extractor;
    private static final Logger _logNameSpace = LoggerFactory.getLogger((String)("logger.org.dcache.namespace." + BasicNameSpaceProvider.class.getName()));
    private NameSpaceProvider _cacheLocationProvider;
    private final AccessLatency _defaultAccessLatency;
    private final RetentionPolicy _defaultRetentionPolicy;
    private final boolean _inheritFileOwnership;
    private static final long FILE_SIZE_2GB = Integer.MAX_VALUE;
    private static final String ACCESS_LATENCY_FLAG = "al";
    private static final String RETENTION_POLICY_FLAG = "rp";
    private static final Set<FileAttribute> SIMPLE_ATTRIBUTES = EnumSet.of(FileAttribute.SIMPLE_TYPE, FileAttribute.SIZE, FileAttribute.MODIFICATION_TIME);

    public BasicNameSpaceProvider(String arguments) throws Exception {
        String passwd;
        String userName;
        String driverName;
        String location;
        Args args = new Args((CharSequence)arguments);
        String accessLatensyOption = args.getOpt("DefaultAccessLatency");
        this._defaultAccessLatency = accessLatensyOption != null && accessLatensyOption.length() > 0 ? AccessLatency.getAccessLatency((String)accessLatensyOption) : StorageInfo.DEFAULT_ACCESS_LATENCY;
        String retentionPolicyOption = args.getOpt("DefaultRetentionPolicy");
        this._defaultRetentionPolicy = retentionPolicyOption != null && retentionPolicyOption.length() > 0 ? RetentionPolicy.getRetentionPolicy((String)retentionPolicyOption) : StorageInfo.DEFAULT_RETENTION_POLICY;
        this._inheritFileOwnership = Boolean.valueOf(args.getOpt("inheritFileOwnership"));
        Class<?> exClass = Class.forName(args.argv(0));
        Constructor<?> extractorInit = exClass.getConstructor(new Class[0]);
        this._extractor = (StorageInfoExtractable)extractorInit.newInstance(new Object[0]);
        this._mountPoint = args.getOpt("pnfs");
        if (this._mountPoint != null && !this._mountPoint.equals("")) {
            _logNameSpace.debug("PnfsFilesystem enforced : " + this._mountPoint);
            PnfsFile pf = new PnfsFile(this._mountPoint);
            if (!pf.isDirectory() || !pf.isPnfs()) {
                throw new IllegalArgumentException("not a pnfs directory: " + this._mountPoint);
            }
            this._virtualMountPoints = PnfsFile.getVirtualMountPoints(new File(this._mountPoint));
        } else {
            _logNameSpace.debug("Starting PNFS autodetect");
            this._virtualMountPoints = PnfsFile.getVirtualMountPoints();
        }
        if (this._virtualMountPoints.isEmpty()) {
            throw new Exception("No mountpoints left ... ");
        }
        for (PnfsFile.VirtualMountPoint vmp : this._virtualMountPoints) {
            if (!_logNameSpace.isDebugEnabled()) continue;
            _logNameSpace.debug(" Server         : " + vmp.getServerId() + "(" + vmp.getServerName() + ")");
            _logNameSpace.debug(" RealMountPoint : " + vmp.getRealMountId() + " " + vmp.getRealMountPoint());
            _logNameSpace.debug("       VirtualMountId : " + vmp.getVirtualMountId());
            _logNameSpace.debug("      VirtualPnfsPath : " + vmp.getVirtualPnfsPath());
            _logNameSpace.debug("     VirtualLocalPath : " + vmp.getVirtualLocalPath());
            _logNameSpace.debug("    VirtualGlobalPath : " + vmp.getVirtualGlobalPath());
        }
        this._pathManager = new PathManager(this._virtualMountPoints);
        String defaultServerName = args.getOpt("defaultPnfsServer");
        if (this._pathManager.getServerCount() > 2 && (defaultServerName == null || defaultServerName.equals(""))) {
            throw new IllegalArgumentException("No default server specified");
        }
        if (defaultServerName != null && !defaultServerName.equals("*")) {
            this._pathManager.setDefaultServerName(defaultServerName);
        }
        if (_logNameSpace.isDebugEnabled()) {
            _logNameSpace.debug("Using default pnfs server : " + this._pathManager.getDefaultServerName());
        }
        if ((location = args.getOpt("delete-registration")) == null || location.equals("")) {
            _logNameSpace.warn("'delete-registration' is not defined.");
            location = null;
        }
        if ((driverName = args.getOpt("delete-registration-jdbcDrv")) == null || driverName.equals("")) {
            _logNameSpace.warn("'delete-registration-jdbcDrv' is not defined.");
            driverName = null;
        }
        if ((userName = args.getOpt("delete-registration-dbUser")) == null || userName.equals("")) {
            _logNameSpace.warn("'delete-registration-dbUser' is not defined.");
            userName = null;
        }
        if ((passwd = args.getOpt("delete-registration-dbPass")) == null || passwd.equals("")) {
            _logNameSpace.warn("'delete-registration-dbPass' is not defined.");
            passwd = null;
        }
        if (_logNameSpace.isDebugEnabled()) {
            _logNameSpace.debug("'delete-registration' set to " + location);
        }
        if (location != null && location.startsWith("/")) {
            FsTrash trash = new FsTrash(location);
            PnfsFile.setTrash(trash);
        } else if (location != null && location.startsWith("jdbc:")) {
            DbTrash trash = new DbTrash(location, driverName, userName, passwd);
            PnfsFile.setTrash(trash);
        } else if (location != null && location.startsWith("pnfs:")) {
            NfsTrash trash = new NfsTrash(this._mountPoint);
            PnfsFile.setTrash(trash);
        } else {
            _logNameSpace.info("Empty trash is selected");
        }
    }

    @Required
    public void setCacheLocationProvider(NameSpaceProvider provider) {
        this._cacheLocationProvider = provider;
    }

    public void addCacheLocation(Subject subject, PnfsId pnfsId, String cacheLocation) throws CacheException {
        if (_logNameSpace.isDebugEnabled()) {
            _logNameSpace.debug("add cache location " + cacheLocation + " for " + pnfsId);
        }
        try {
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            CacheInfo ci = new CacheInfo(pf);
            ci.addCacheLocation(cacheLocation);
            ci.writeCacheInfo(pf);
        }
        catch (IOException e) {
            _logNameSpace.error("Exception in addCacheLocation " + e);
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void clearCacheLocation(Subject subject, PnfsId pnfsId, String cacheLocation, boolean removeIfLast) throws CacheException {
        if (_logNameSpace.isDebugEnabled()) {
            _logNameSpace.debug("clearCacheLocation : " + cacheLocation + " for " + pnfsId);
        }
        try {
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            if (pf == null) {
                _logNameSpace.error("Can't get PnfsFile of : " + pnfsId);
                return;
            }
            CacheInfo ci = new CacheInfo(pf);
            if (cacheLocation.equals("*")) {
                List<String> cacheLocations = ci.getCacheLocations();
                if (!cacheLocations.isEmpty()) {
                    for (String location : cacheLocations) {
                        ci.clearCacheLocation(location);
                    }
                    ci.writeCacheInfo(pf);
                }
            } else if (ci.clearCacheLocation(cacheLocation)) {
                ci.writeCacheInfo(pf);
            }
            if (ci.getCacheLocations().isEmpty()) {
                CacheInfo.CacheFlags flags = ci.getFlags();
                String deletable = flags.get("d");
                if (removeIfLast || deletable != null && deletable.startsWith("t")) {
                    if (_logNameSpace.isDebugEnabled()) {
                        _logNameSpace.debug("clearCacheLocation : deleting " + pnfsId + " from filesystem");
                    }
                    this.deleteEntry(subject, pnfsId);
                }
            }
        }
        catch (Exception e) {
            _logNameSpace.error("Exception in clearCacheLocation for : " + pnfsId + " -> " + e);
        }
    }

    public PnfsId createEntry(Subject subject, String name, int uid, int gid, int mode, boolean isDirectory) throws CacheException {
        boolean rc;
        String globalPath = name;
        if (_logNameSpace.isDebugEnabled()) {
            _logNameSpace.debug("create PNFS entry for " + globalPath);
        }
        PnfsFile pf = null;
        String localPath = null;
        PnfsId pnfsId = null;
        try {
            localPath = this._pathManager.globalToLocal(globalPath);
            pf = new PnfsFile(localPath);
        }
        catch (Exception ie) {
            _logNameSpace.error("failed to map global path to local: " + globalPath, (Throwable)ie);
            throw new IllegalArgumentException("g2l match failed : " + ie.getMessage());
        }
        File parent = pf.getParentFile();
        try {
            rc = isDirectory ? pf.mkdir() : pf.createNewFile();
        }
        catch (IOException e) {
            if (parent.isDirectory()) {
                _logNameSpace.error("Failed to create " + globalPath + ": " + e.getMessage());
                throw new CacheException(10011, "IO Error creating " + name + ": " + e.getMessage());
            }
            rc = false;
        }
        if (!rc) {
            if (!parent.exists()) {
                throw new FileNotFoundCacheException("No such file or directory: " + parent);
            }
            if (!parent.isDirectory()) {
                throw new NotDirCacheException("Not a directory: " + parent);
            }
            throw new FileExistsCacheException("File exists: " + name);
        }
        if (!pf.isPnfs()) {
            _logNameSpace.warn("requested path [" + globalPath + "], is not an pnfs path");
            pf.delete();
            throw new IllegalArgumentException("Not a pnfs file system");
        }
        if (!Subjects.isNobody((Subject)subject) && !this._inheritFileOwnership) {
            if (uid == -1) {
                uid = (int)Subjects.getUid((Subject)subject);
            }
            if (gid == -1) {
                gid = (int)Subjects.getPrimaryGid((Subject)subject);
            }
        }
        if (uid == -1 || gid == -1 || mode == -1) {
            PnfsId parentId = pf.getParentId();
            FileAttributes parentAttributes = this.getFileAttributes(subject, parentId, EnumSet.of(FileAttribute.MODE, FileAttribute.OWNER, FileAttribute.OWNER_GROUP));
            if (uid == -1) {
                uid = parentAttributes.getOwner();
            }
            if (gid == -1) {
                gid = parentAttributes.getGroup();
            }
            if (mode == -1) {
                mode = parentAttributes.getMode();
                mode = isDirectory ? (mode &= 0x1FF) : (mode &= 0x1B6);
            }
        }
        pnfsId = pf.getPnfsId();
        try {
            FileAttributes attributes = new FileAttributes();
            attributes.setOwner(uid);
            attributes.setGroup(gid);
            attributes.setMode(mode);
            this.setFileAttributes(Subjects.ROOT, pnfsId, attributes);
        }
        catch (RuntimeException e) {
            pf.delete();
            throw e;
        }
        catch (CacheException e) {
            pf.delete();
            throw e;
        }
        if (_logNameSpace.isDebugEnabled()) {
            _logNameSpace.debug("Created new entry [" + globalPath + "], id: " + pnfsId.toString());
        }
        return pf.getPnfsId();
    }

    public void deleteEntry(Subject subject, PnfsId pnfsId) throws CacheException {
        String pnfsIdPath = this.pnfsidToPath(subject, pnfsId);
        _logNameSpace.debug("delete PNFS entry for " + pnfsId);
        this.deleteEntry(subject, pnfsIdPath);
    }

    public void deleteEntry(Subject subject, String path) throws CacheException {
        boolean rc;
        _logNameSpace.debug("delete PNFS entry for  path " + path);
        PnfsFile pf = new PnfsFile(path);
        if (!pf.exists()) {
            _logNameSpace.debug(path + ": no such file");
            throw new FileNotFoundCacheException("No such file or directory");
        }
        try {
            rc = pf.delete();
        }
        catch (Exception e) {
            _logNameSpace.error("delete failed " + e);
            throw new IllegalArgumentException("Failed to remove entry " + path + " : " + e);
        }
        if (!rc) {
            if (pf.isDirectory() && pf.list().length != 0) {
                _logNameSpace.error(path + ": is not empty");
                throw new IllegalArgumentException("Directory  " + path + " not empty");
            }
            _logNameSpace.error(path + ": unknown reason");
            throw new IllegalArgumentException("Failed to remove entry " + path + " : Unknown reason.");
        }
    }

    public List<String> getCacheLocation(Subject subject, PnfsId pnfsId) throws CacheException {
        try {
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            if (pf == null || !pf.exists()) {
                throw new FileNotFoundCacheException("no such file or directory" + pnfsId.toString());
            }
            CacheInfo ci = new CacheInfo(pf);
            if (_logNameSpace.isDebugEnabled()) {
                _logNameSpace.debug("pnfs file = " + pf + " cache info = " + ci);
            }
            return new ArrayList<String>(ci.getCacheLocations());
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public String pnfsidToPath(Subject subject, PnfsId pnfsId) throws CacheException {
        PnfsFile pnfsFile = this._pathManager.getFileByPnfsId(pnfsId);
        if (pnfsFile == null) {
            throw new FileNotFoundCacheException(pnfsId.toString() + " not found");
        }
        try {
            String pnfsPath = this.pathfinder(pnfsId);
            String domain = pnfsId.getDomain();
            PnfsFile.VirtualMountPoint vmp = this._pathManager.getVmpByDomain(domain);
            if (vmp == null) {
                throw new IllegalArgumentException("Can't find default VMP");
            }
            String pvm = vmp.getVirtualPnfsPath();
            if (!pnfsPath.startsWith(pvm)) {
                throw new IllegalArgumentException("PnfsId not in scope of vmp : " + pvm);
            }
            return vmp.getVirtualGlobalPath() + pnfsPath.substring(pvm.length());
        }
        catch (Exception e) {
            _logNameSpace.error("!! Problem determining path of " + pnfsId);
            _logNameSpace.error(e.toString());
            return pnfsFile.getPath();
        }
    }

    public PnfsId pathToPnfsid(Subject subject, String path, boolean followLinks) throws CacheException {
        PnfsFile pnfsFile = null;
        try {
            String localPath = this._pathManager.globalToLocal(path);
            if (followLinks) {
                File localFile = new File(localPath);
                pnfsFile = new PnfsFile(localFile.getAbsolutePath());
            } else {
                pnfsFile = new PnfsFile(localPath);
            }
        }
        catch (NoSuchElementException nse) {
            throw new FileNotFoundCacheException("path " + path + " not found");
        }
        return pnfsFile.getPnfsId();
    }

    private void storeAlRpInLevel2(StorageInfo storageInfo, PnfsFile pnfsFile) throws IOException {
        if (storageInfo.isSetAccessLatency() || storageInfo.isSetRetentionPolicy()) {
            CacheInfo info = new CacheInfo(pnfsFile);
            CacheInfo.CacheFlags flags = info.getFlags();
            if (storageInfo.isSetAccessLatency()) {
                flags.put(ACCESS_LATENCY_FLAG, storageInfo.getAccessLatency().toString());
            }
            if (storageInfo.isSetRetentionPolicy()) {
                flags.put(RETENTION_POLICY_FLAG, storageInfo.getRetentionPolicy().toString());
            }
            info.writeCacheInfo(pnfsFile);
        }
    }

    public void setStorageInfo(Subject subject, PnfsId pnfsId, StorageInfo storageInfo, int mode) throws CacheException {
        _logNameSpace.debug("setStorageInfo : " + pnfsId);
        File mountpoint = this._pathManager.getMountPointByPnfsId(pnfsId);
        this._extractor.setStorageInfo(mountpoint.getAbsolutePath(), pnfsId, storageInfo, mode);
        PnfsFile pnfsFile = PnfsFile.getFileByPnfsId(mountpoint, pnfsId);
        try {
            this.storeAlRpInLevel2(storageInfo, pnfsFile);
        }
        catch (IOException e) {
            throw new CacheException("IO error while updating level 2 of " + pnfsId + ": " + e.getMessage());
        }
    }

    private AccessLatency getAccessLatencyForDirectory(PnfsFile dir) {
        String[] s = dir.getTag("AccessLatency");
        if (s != null) {
            try {
                return AccessLatency.getAccessLatency((String)s[0].trim());
            }
            catch (IllegalArgumentException e) {
                _logNameSpace.error("Invalid AccessLatency tag in " + dir);
            }
        }
        return this._defaultAccessLatency;
    }

    private RetentionPolicy getRetentionPolicyForDirectory(PnfsFile dir) {
        String[] s = dir.getTag("RetentionPolicy");
        if (s != null) {
            try {
                return RetentionPolicy.getRetentionPolicy((String)s[0].trim());
            }
            catch (IllegalArgumentException e) {
                _logNameSpace.error("Invalid RetentionPolicy tag in " + dir);
            }
        }
        return this._defaultRetentionPolicy;
    }

    private StorageInfo getStorageInfo(Subject subject, PnfsId pnfsId) throws CacheException {
        StorageInfo info;
        block19: {
            _logNameSpace.debug("getStorageInfo : " + pnfsId);
            File mountpoint = this._pathManager.getMountPointByPnfsId(pnfsId);
            info = this._extractor.getStorageInfo(mountpoint.getAbsolutePath(), pnfsId);
            _logNameSpace.debug("Storage info " + info);
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            if (pf.isDirectory()) {
                info.setAccessLatency(this.getAccessLatencyForDirectory(pf));
                info.setRetentionPolicy(this.getRetentionPolicyForDirectory(pf));
            } else if (pf.isFile() && info.isCreatedOnly()) {
                PnfsFile dir = BasicNameSpaceProvider.getParentPnfsFile(mountpoint, pf, null);
                info.setAccessLatency(this.getAccessLatencyForDirectory(dir));
                info.setRetentionPolicy(this.getRetentionPolicyForDirectory(dir));
            } else if (pf.isFile()) {
                try {
                    PnfsFile dir = null;
                    CacheInfo cinfo = new CacheInfo(pf);
                    CacheInfo.CacheFlags flags = cinfo.getFlags();
                    for (Map.Entry<String, String> entry : flags.entrySet()) {
                        info.setKey("flag-" + entry.getKey(), entry.getValue());
                    }
                    String al = flags.get(ACCESS_LATENCY_FLAG);
                    if (al != null) {
                        try {
                            info.setAccessLatency(AccessLatency.getAccessLatency((String)al));
                        }
                        catch (IllegalArgumentException e) {
                            throw new CacheException(10012, "Invalid access latency in level 2 of " + pnfsId);
                        }
                    } else {
                        dir = BasicNameSpaceProvider.getParentPnfsFile(mountpoint, pf, dir);
                        info.setAccessLatency(this.getAccessLatencyForDirectory(dir));
                    }
                    String rp = flags.get(RETENTION_POLICY_FLAG);
                    if (rp != null) {
                        try {
                            info.setRetentionPolicy(RetentionPolicy.getRetentionPolicy((String)rp));
                        }
                        catch (IllegalArgumentException e) {
                            throw new CacheException(10012, "Invalid retention policy in level 2 of " + pnfsId);
                        }
                    } else {
                        dir = BasicNameSpaceProvider.getParentPnfsFile(mountpoint, pf, dir);
                        info.setRetentionPolicy(this.getRetentionPolicyForDirectory(dir));
                    }
                    if (info.getFileSize() != 1L) break block19;
                    try {
                        long largeFilesize;
                        String sizeString = flags.get("l");
                        if (sizeString != null && (largeFilesize = Long.parseLong(sizeString)) > 0L) {
                            info.setFileSize(largeFilesize);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new CacheException(10012, "Invalid length in level 2 of " + pnfsId);
                    }
                }
                catch (IOException e) {
                    throw new CacheException("IO error while reading level 2 of " + pnfsId);
                }
            }
        }
        return info;
    }

    public void removeFileAttribute(Subject subject, PnfsId pnfsId, String attribute) throws CacheException {
        try {
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            CacheInfo info = new CacheInfo(pf);
            CacheInfo.CacheFlags flags = info.getFlags();
            flags.remove(attribute);
            info.writeCacheInfo(pf);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void renameEntry(Subject subject, PnfsId pnfsId, String newName, boolean overwrite) throws CacheException {
        File src = new File(this._pathManager.globalToLocal(this.pnfsidToPath(subject, pnfsId)));
        File dest = new File(this._pathManager.globalToLocal(newName));
        if (!overwrite && dest.exists()) {
            throw new FileExistsCacheException("File exists: " + dest);
        }
        if (!src.renameTo(dest)) {
            if (!src.exists()) {
                throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
            }
            if (!dest.getParentFile().isDirectory()) {
                throw new NotDirCacheException("No such directory: " + dest.getParent());
            }
            throw new CacheException("Failed to rename " + pnfsId + " to " + newName);
        }
    }

    public void removeChecksum(Subject subject, PnfsId pnfsId, ChecksumType type) throws CacheException {
        try {
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            if (!pf.isFile()) {
                throw new NotFileCacheException("Not a file: " + pnfsId);
            }
            CacheInfo info = new CacheInfo(pf);
            ChecksumCollection checksums = ChecksumCollection.extract(info);
            checksums.remove(type);
            checksums.serialize(info);
            info.writeCacheInfo(pf);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    private void setAccessRights(File mp, PnfsId pnfsId, int level, int uid, int gid, int mode) throws CacheException {
        String hexTime = Long.toHexString(System.currentTimeMillis() / 1000L);
        int l = hexTime.length();
        if (l > 8) {
            hexTime = hexTime.substring(l - 8);
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(".(pset)(").append(pnfsId.getId()).append(")(attr)(").append(level).append(")(").append(Integer.toOctalString(0x8000 | mode)).append(":").append(uid).append(":").append(gid).append(":").append(hexTime).append(":").append(hexTime).append(":").append(hexTime).append(")");
        File metaFile = new File(mp, sb.toString());
        try {
            long delay = 1L;
            while (true) {
                try {
                    RandomAccessFile raf = new RandomAccessFile(metaFile, "rws");
                    raf.close();
                    return;
                }
                catch (IOException e) {
                    if (this.getFileAttributes(null, pnfsId, EnumSet.of(FileAttribute.MODE)).getMode() == mode) {
                        return;
                    }
                    _logNameSpace.warn("Failed to set permissions: " + e.getMessage());
                    if (delay > 1024L) {
                        throw new CacheException(10011, "Failed to set permissions");
                    }
                    Thread.sleep(delay);
                    delay *= 2L;
                    metaFile.delete();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(10011, "Failed to set permissions: Operation was interrupted");
        }
    }

    private void setFileSize(PnfsId pnfsId, long length) throws CacheException {
        try {
            long size;
            PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
            pf.setLength(length);
            for (int i = 0; i < 10 && (size = pf.length()) != length; ++i) {
                _logNameSpace.debug("setLength : not yet ... ");
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new CacheException("Operation interrupted");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("$Revision: 16947 $").append("\n");
        for (PnfsFile.VirtualMountPoint vmp : this._virtualMountPoints) {
            sb.append(" Server         : " + vmp.getServerId() + "(" + vmp.getServerName() + ")").append("\n");
            sb.append(" RealMountPoint : " + vmp.getRealMountId() + " " + vmp.getRealMountPoint()).append("\n");
            sb.append("       VirtualMountId : " + vmp.getVirtualMountId()).append("\n");
            sb.append("      VirtualPnfsPath : " + vmp.getVirtualPnfsPath()).append("\n");
            sb.append("     VirtualLocalPath : " + vmp.getVirtualLocalPath()).append("\n");
            sb.append("    VirtualGlobalPath : " + vmp.getVirtualGlobalPath()).append("\n");
        }
        return sb.toString();
    }

    private String pathfinder(PnfsId pnfsId) throws CacheException {
        ArrayList<String> list = new ArrayList<String>();
        String pnfs = pnfsId.getId();
        File mp = this._pathManager.getMountPointByPnfsId(pnfsId);
        try {
            String name;
            while ((name = this.nameOf(mp, pnfs)) != null) {
                list.add(name);
                if ((pnfs = this.parentOf(mp, pnfs)) != null) continue;
                break;
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
        if (list.size() == 0) {
            throw new FileNotFoundCacheException(pnfsId.toString() + " not found");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            sb.append("/").append((String)list.get(i));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nameOf(File mp, String pnfsId) throws IOException {
        File file = new File(mp, ".(nameof)(" + pnfsId + ")");
        if (_logNameSpace.isInfoEnabled()) {
            _logNameSpace.info("nameof for pnfsid " + pnfsId);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String string = br.readLine();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parentOf(File mp, String pnfsId) throws IOException {
        if (_logNameSpace.isInfoEnabled()) {
            _logNameSpace.info("parent for pnfsid " + pnfsId);
        }
        File file = new File(mp, ".(parent)(" + pnfsId + ")");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String string = br.readLine();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ee) {}
            }
        }
    }

    public PnfsId getParentOf(Subject subject, PnfsId pnfsId) throws CacheException {
        try {
            File mp = this._pathManager.getMountPointByPnfsId(pnfsId);
            return new PnfsId(this.parentOf(mp, pnfsId.toString()));
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public FileAttributes getFileAttributes(Subject subject, PnfsId pnfsId, Set<FileAttribute> attr) throws CacheException {
        PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
        CacheInfo cacheInfo = null;
        FileAttributes attributes = new FileAttributes();
        try {
            for (FileAttribute attribute : attr) {
                switch (attribute) {
                    case ACL: {
                        attributes.setAcl(null);
                        break;
                    }
                    case ACCESS_LATENCY: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        attributes.setAccessLatency(AccessLatency.getAccessLatency((String)cacheInfo.getFlags().get(ACCESS_LATENCY_FLAG)));
                        break;
                    }
                    case RETENTION_POLICY: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        attributes.setRetentionPolicy(RetentionPolicy.getRetentionPolicy((String)cacheInfo.getFlags().get(ACCESS_LATENCY_FLAG)));
                        break;
                    }
                    case SIZE: {
                        String s;
                        long filesize = pf.length();
                        if (filesize <= 1L && pf.isFile() && (s = (cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo)).getFlags().get("l")) != null) {
                            try {
                                filesize = Long.parseLong(s);
                            }
                            catch (NumberFormatException ignored) {
                                // empty catch block
                            }
                        }
                        attributes.setSize(filesize);
                        break;
                    }
                    case CHECKSUM: {
                        if (!pf.isFile()) break;
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        ChecksumCollection collection = ChecksumCollection.extract(cacheInfo);
                        attributes.setChecksums(collection.getChecksums());
                        break;
                    }
                    case LOCATIONS: {
                        if (!pf.isFile()) break;
                        if (this._cacheLocationProvider != this) {
                            attributes.setLocations((Collection)this._cacheLocationProvider.getCacheLocation(subject, pnfsId));
                            break;
                        }
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        attributes.setLocations(cacheInfo.getCacheLocations());
                        break;
                    }
                    case FLAGS: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        Map flags = CollectionFactory.newHashMap();
                        for (Map.Entry<String, String> e : cacheInfo.getFlags().entrySet()) {
                            flags.put(e.getKey(), e.getValue());
                        }
                        attributes.setFlags(flags);
                        break;
                    }
                    case PNFSID: {
                        attributes.setPnfsId(pnfsId);
                        break;
                    }
                    case STORAGEINFO: {
                        attributes.setStorageInfo(this.getStorageInfo(subject, pnfsId));
                        break;
                    }
                }
            }
            if (!Collections.disjoint(attr, PnfsFile.GETATTR_ATTRIBUTES)) {
                pf.readGetAttr(this._pathManager.getMountPointByPnfsId(pnfsId), attributes);
            }
            return attributes;
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void setFileAttributes(Subject subject, PnfsId pnfsId, FileAttributes attr) throws CacheException {
        PnfsFile pf = this._pathManager.getFileByPnfsId(pnfsId);
        File mountpoint = this._pathManager.getMountPointByPnfsId(pnfsId);
        PnfsFile dir = null;
        CacheInfo cacheInfo = null;
        Set definedAttributes = attr.getDefinedAttributes();
        try {
            block14: for (FileAttribute attribute : definedAttributes) {
                switch (attribute) {
                    case ACCESS_LATENCY: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        cacheInfo.getFlags().put(ACCESS_LATENCY_FLAG, attr.getAccessLatency().toString());
                        break;
                    }
                    case RETENTION_POLICY: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        cacheInfo.getFlags().put(RETENTION_POLICY_FLAG, attr.getRetentionPolicy().toString());
                        break;
                    }
                    case DEFAULT_ACCESS_LATENCY: {
                        if ((cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo)).getFlags().get(ACCESS_LATENCY_FLAG) != null) continue block14;
                        dir = BasicNameSpaceProvider.getParentPnfsFile(mountpoint, pf, dir);
                        cacheInfo.getFlags().put(ACCESS_LATENCY_FLAG, this.getAccessLatencyForDirectory(dir).toString());
                        break;
                    }
                    case DEFAULT_RETENTION_POLICY: {
                        if ((cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo)).getFlags().get(RETENTION_POLICY_FLAG) != null) continue block14;
                        dir = BasicNameSpaceProvider.getParentPnfsFile(mountpoint, pf, dir);
                        cacheInfo.getFlags().put(RETENTION_POLICY_FLAG, this.getRetentionPolicyForDirectory(dir).toString());
                        break;
                    }
                    case SIZE: {
                        long size = attr.getSize();
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        cacheInfo.getFlags().put("l", Long.toString(size));
                        if (size > Integer.MAX_VALUE) {
                            pf.setLength(1L);
                            break;
                        }
                        pf.setLength(size);
                        break;
                    }
                    case CHECKSUM: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        ChecksumCollection collection = ChecksumCollection.extract(cacheInfo);
                        collection.add(attr.getChecksums());
                        collection.serialize(cacheInfo);
                        break;
                    }
                    case LOCATIONS: {
                        for (String string : attr.getLocations()) {
                            if (this._cacheLocationProvider != this) {
                                this._cacheLocationProvider.addCacheLocation(subject, pnfsId, string);
                                continue;
                            }
                            cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                            cacheInfo.addCacheLocation(string);
                        }
                        continue block14;
                    }
                    case FLAGS: {
                        cacheInfo = BasicNameSpaceProvider.getCacheInfo(pf, cacheInfo);
                        for (Map.Entry entry : attr.getFlags().entrySet()) {
                            cacheInfo.getFlags().put((String)entry.getKey(), (String)entry.getValue());
                        }
                        continue block14;
                    }
                    case MODE: 
                    case OWNER: 
                    case OWNER_GROUP: {
                        break;
                    }
                    case ACL: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Attribute " + attribute + " not supported yet.");
                    }
                }
            }
            if (cacheInfo != null) {
                cacheInfo.writeCacheInfo(pf);
            }
            if (definedAttributes.contains(FileAttribute.MODE) || definedAttributes.contains(FileAttribute.OWNER) || definedAttributes.contains(FileAttribute.OWNER_GROUP)) {
                EnumSet<FileAttribute> missingAttributes = EnumSet.of(FileAttribute.MODE, FileAttribute.OWNER, FileAttribute.OWNER_GROUP);
                missingAttributes.removeAll(definedAttributes);
                FileAttributes current = null;
                if (!missingAttributes.isEmpty()) {
                    current = this.getFileAttributes(subject, pnfsId, missingAttributes);
                }
                int mode = definedAttributes.contains(FileAttribute.MODE) ? attr.getMode() : current.getMode();
                int uid = definedAttributes.contains(FileAttribute.OWNER) ? attr.getOwner() : current.getOwner();
                int gid = definedAttributes.contains(FileAttribute.OWNER_GROUP) ? attr.getGroup() : current.getGroup();
                for (int level = 0; level < 2; ++level) {
                    this.setAccessRights(mountpoint, pnfsId, level, uid, gid, mode);
                }
            }
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void list(Subject subject, String path, Glob glob, Range<Integer> range, Set<FileAttribute> attrs, ListHandler handler) throws CacheException {
        Pattern pattern;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundCacheException("Directory does not exist");
        }
        if (!file.isDirectory()) {
            throw new NotDirCacheException("Not a directory");
        }
        Pattern pattern2 = pattern = glob == null ? null : glob.toPattern();
        ListFilter filter = attrs.isEmpty() ? new NameOnlyListFilter(pattern, range, handler) : (SIMPLE_ATTRIBUTES.containsAll(attrs) ? new SimpleAttributesListFilter(pattern, range, attrs, handler) : new ManyAttributesListFilter(pattern, range, attrs, handler));
        File[] list = file.listFiles(filter);
        if (list == null) {
            throw new CacheException(10011, "IO Error");
        }
    }

    private static CacheInfo getCacheInfo(PnfsFile pnfsFile, CacheInfo cacheInfo) throws IOException {
        return cacheInfo != null ? cacheInfo : new CacheInfo(pnfsFile);
    }

    private static PnfsFile getParentPnfsFile(File mountpoint, PnfsFile file, PnfsFile parent) throws CacheException {
        if (parent != null) {
            return parent;
        }
        PnfsId id = file.getParentId();
        if (id == null) {
            throw new CacheException(36, "Couldn't determine parent ID");
        }
        return PnfsFile.getFileByPnfsId(mountpoint, id);
    }

    private class ManyAttributesListFilter
    extends ListFilter {
        public ManyAttributesListFilter(Pattern pattern, Range<Integer> range, Set<FileAttribute> attributes, ListHandler handler) {
            super(pattern, range, attributes, handler);
        }

        @Override
        protected FileAttributes getAttributes(File file) throws CacheException {
            PnfsId id = BasicNameSpaceProvider.this.pathToPnfsid(Subjects.ROOT, file.toString(), true);
            return BasicNameSpaceProvider.this.getFileAttributes(Subjects.ROOT, id, this._attributes);
        }
    }

    private class SimpleAttributesListFilter
    extends ListFilter {
        public SimpleAttributesListFilter(Pattern pattern, Range<Integer> range, Set<FileAttribute> attributes, ListHandler handler) {
            super(pattern, range, attributes, handler);
        }

        @Override
        protected FileAttributes getAttributes(File file) throws CacheException {
            FileAttributes attr = new FileAttributes();
            if (this._attributes.contains(FileAttribute.SIZE)) {
                long size = file.length();
                if (size <= 1L) {
                    PnfsId id = BasicNameSpaceProvider.this.pathToPnfsid(Subjects.ROOT, file.toString(), true);
                    attr = BasicNameSpaceProvider.this.getFileAttributes(Subjects.ROOT, id, EnumSet.of(FileAttribute.SIZE));
                } else {
                    attr.setSize(size);
                }
            }
            if (this._attributes.contains(FileAttribute.SIMPLE_TYPE)) {
                if (file.isFile()) {
                    attr.setFileType(FileType.REGULAR);
                } else if (file.isDirectory()) {
                    attr.setFileType(FileType.DIR);
                } else {
                    attr.setFileType(FileType.SPECIAL);
                }
            }
            if (this._attributes.contains(FileAttribute.MODIFICATION_TIME)) {
                attr.setModificationTime(file.lastModified());
            }
            return attr;
        }
    }

    private class NameOnlyListFilter
    extends ListFilter {
        public NameOnlyListFilter(Pattern pattern, Range<Integer> range, ListHandler handler) {
            super(pattern, range, EnumSet.noneOf(FileAttribute.class), handler);
        }

        @Override
        protected FileAttributes getAttributes(File file) {
            return null;
        }
    }

    private abstract class ListFilter
    implements FileFilter {
        private final Pattern _pattern;
        private final ListHandler _handler;
        private final Range<Integer> _range;
        private int _counter = 0;
        protected final Set<FileAttribute> _attributes;

        public ListFilter(Pattern pattern, Range<Integer> range, Set<FileAttribute> attributes, ListHandler handler) {
            this._pattern = pattern;
            this._range = range;
            this._handler = handler;
            this._attributes = attributes;
        }

        protected abstract FileAttributes getAttributes(File var1) throws CacheException;

        @Override
        public boolean accept(File file) {
            block3: {
                String name = file.getName();
                if ((this._pattern == null || this._pattern.matcher(name).matches()) && this._range.contains((Comparable)Integer.valueOf(this._counter++))) {
                    try {
                        this._handler.addEntry(name, this.getAttributes(file));
                    }
                    catch (CacheException e) {
                        if (e.getRc() == 10001 || e.getRc() == 10016) break block3;
                        _logNameSpace.warn("Lookup failed: " + file);
                    }
                }
            }
            return false;
        }
    }

    private static class PathManager {
        private final PathMap _globalPathMap = new PathMap();
        private final Map<String, PnfsFile.VirtualMountPoint> _servers = new HashMap<String, PnfsFile.VirtualMountPoint>();
        private File _defaultMountPoint = null;
        private String _defaultServerName = null;
        private String _defaultServerId = null;

        private PathManager(List<PnfsFile.VirtualMountPoint> virtualMountPoints) {
            for (PnfsFile.VirtualMountPoint vmp : virtualMountPoints) {
                this._globalPathMap.add(vmp.getVirtualGlobalPath(), (Object)vmp);
                this._servers.put(vmp.getServerId(), vmp);
            }
            if (this._servers.isEmpty()) {
                throw new NoSuchElementException("Emtpy server list");
            }
            PnfsFile.VirtualMountPoint vmp = virtualMountPoints.get(0);
            this._defaultServerName = vmp.getServerName();
            this._defaultServerId = vmp.getServerId();
            this._defaultMountPoint = this.getVmpByDomain(this._defaultServerId).getRealMountPoint();
        }

        private PnfsFile.VirtualMountPoint getVmpByDomain(String domain) {
            String resolvedDomain = domain == null || domain.length() == 0 ? this._defaultServerId : domain;
            PnfsFile.VirtualMountPoint vmp = this._servers.get(resolvedDomain);
            if (vmp == null) {
                throw new NoSuchElementException("No server found for : " + domain);
            }
            return vmp;
        }

        public File getMountPointByPnfsId(PnfsId pnfsId) {
            String domain = pnfsId.getDomain();
            if (domain == null || domain.equals("")) {
                return this._defaultMountPoint;
            }
            PnfsFile.VirtualMountPoint vmp = this.getVmpByDomain(domain);
            return vmp.getRealMountPoint();
        }

        public PnfsFile getFileByPnfsId(PnfsId pnfsId) throws CacheException {
            return PnfsFile.getFileByPnfsId(this.getMountPointByPnfsId(pnfsId), pnfsId);
        }

        public String getDefaultServerName() {
            return this._defaultServerName;
        }

        public void setDefaultServerName(String serverName) throws NoSuchElementException {
            PnfsFile.VirtualMountPoint vmp = this.getVmpByDomain(serverName);
            this._defaultMountPoint = vmp.getRealMountPoint();
            this._defaultServerName = serverName;
        }

        private String globalToLocal(String globalPath) {
            PathMap.Entry entry = this._globalPathMap.match(globalPath);
            if (entry.getNode() instanceof Map) {
                return null;
            }
            PnfsFile.VirtualMountPoint vmp = (PnfsFile.VirtualMountPoint)entry.getNode();
            return vmp.getVirtualLocalPath() + entry.getRest();
        }

        public int getServerCount() {
            return this._servers.size();
        }
    }
}

