/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.cells;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PnfsClearCacheLocationMessage;
import diskCacheV111.vehicles.PnfsGetCacheLocationsMessage;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import dmg.util.CommandSyntaxException;
import dmg.util.Formats;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanerV2
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(CleanerV2.class);
    private final String _cellName;
    private final CellNucleus _nucleus;
    private final Args _args;
    private final String _dirName;
    private final File _trashLocation;
    private final File _dbDirectory;
    private final File _archive;
    private final File _currentDir;
    private final File _globalLock;
    private final File _currentRemoveList;
    private boolean _nullBug = false;
    private Thread _cleaningThread = null;
    private long _refreshInterval = 300000L;
    private long _replyTimeout = 10000L;
    private int _removeCounter = 0;
    private int _unremoveCounter = 0;
    private int _lastTimeRemoveCounter = 0;
    private int _lastTimeUnremoveCounter = 0;
    private long _recoverTimer = 0L;
    private int _exceptionCounter = 0;
    private int _loopCounter = 0;
    private final Date _started = new Date();
    private final Object _sleepLock = new Object();
    private long _previousRecoverRun = System.currentTimeMillis();
    private String _broadcastCellName = null;
    private File _moveAwayLocation = null;
    private boolean _usePnfsManager = true;
    private boolean _cleanUpAfterwards = false;
    private String _pnfsManagerName = "PnfsManager";
    private long _pnfsManagerTimeout = 60000L;
    private int _processInOnce = 100;
    private Thread _workerThread = null;
    private boolean _useZip = false;
    private boolean _useLog = false;
    private int _summaryErrorCounters = 0;
    private static final SimpleDateFormat _formatter = new SimpleDateFormat("yyyy.MM.dd");
    public String hh_set_moveawaylocation = "<directory to move processed pnfsid files> | void ";
    public String hh_lock = "get|check|release";
    public String hh_set_refresh = "<refreshTimeInSeconds> # > 5 [-wakeup]";
    public String hh_set_recover = "<refreshTimeInMINUTES>";
    public String hh_reactivate = "<poolName> | -a";
    public String hh_scan = "[-init] [-force]";
    private static final int CREATE_SUMMARY = 0;
    private static final int CLEAR_TRASH = 1;
    private static final int SPLIT = 2;
    private static final int RUN_DELETE = 3;
    public String hh_report_remove = "<reportRemoveReceiver>|off";
    public String hh_ls_failed = "[-a] [-l]";

    public CleanerV2(String cellName, String args) throws Exception {
        super(cellName, CleanerV2.class.getName(), args, false);
        this._cellName = cellName;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        this.useInterpreter(true);
        try {
            String refreshString = this._args.getOpt("refresh");
            if (refreshString != null) {
                try {
                    this._refreshInterval = Long.parseLong(refreshString) * 1000L;
                }
                catch (NumberFormatException ee) {
                    // empty catch block
                }
            }
            _log.info("Refresh Interval set to " + this._refreshInterval + " milli seconds");
            refreshString = this._args.getOpt("recover");
            if (refreshString != null) {
                try {
                    this._recoverTimer = Long.parseLong(refreshString) * 60000L;
                }
                catch (NumberFormatException ee) {
                    // empty catch block
                }
            }
            _log.info("Recover Interval set to " + this._recoverTimer / 60000L + " minutes");
            refreshString = this._args.getOpt("poolTimeout");
            if (refreshString != null) {
                try {
                    this._replyTimeout = Long.parseLong(refreshString) * 1000L;
                }
                catch (NumberFormatException ee) {
                    // empty catch block
                }
            }
            _log.info("Pool Timeout set to " + this._replyTimeout / 1000L + " seconds");
            String dirName = null;
            dirName = this._args.getOpt("trash");
            if (dirName == null || dirName.equals("")) {
                _log.info("'trash' not defined. Starting autodetect");
                dirName = this.autodetectTrash();
            }
            this._dirName = dirName;
            _log.info("'trash' set to " + this._dirName);
            this._trashLocation = new File(this._dirName);
            if (!this._trashLocation.isDirectory()) {
                _log.info("'trash' not a directory : " + this._dirName);
                throw new IllegalArgumentException("'trash' not a directory : " + this._dirName);
            }
            String db = this._args.getOpt("db");
            if (db == null) {
                throw new IllegalArgumentException("Database Directory (db) not specified");
            }
            this._dbDirectory = new File(db);
            if (!this._dbDirectory.isDirectory()) {
                throw new IllegalArgumentException("Not a directory : " + db);
            }
            _log.info("Database directory : " + this._dbDirectory);
            String moveAway = this._args.getOpt("moveAwayLocation");
            if (moveAway != null && !moveAway.equals("")) {
                this._moveAwayLocation = new File(moveAway);
                if (!this._moveAwayLocation.isDirectory()) {
                    _log.warn("moveAwayLocation is not a directory, switching to remove mode");
                    this._moveAwayLocation = null;
                }
            }
            _log.info("moveAwayLocation : " + (this._moveAwayLocation == null ? "VOID" : this._moveAwayLocation.toString()));
            this._broadcastCellName = this._args.getOpt("reportRemove");
            this._broadcastCellName = this._broadcastCellName == null || this._broadcastCellName.equals("") || this._broadcastCellName.equals("none") ? null : this._broadcastCellName;
            _log.info(this._broadcastCellName == null ? "Remove report disabled" : "Remove report sent to : " + this._broadcastCellName);
            this._currentDir = new File(this._dbDirectory, "current");
            this._currentDir.mkdir();
            if (!this._currentDir.isDirectory()) {
                throw new IOException("Can't create current : " + this._currentDir);
            }
            this._archive = new File(this._dbDirectory, "archive");
            this._archive.mkdir();
            if (!this._archive.isDirectory()) {
                throw new IOException("Can't create archive : " + this._archive);
            }
            this._currentRemoveList = new File(this._currentDir, "removeList");
            this._globalLock = new File(this._currentDir, "GlobalLock");
            this._globalLock.deleteOnExit();
            this._nullBug = this._args.hasOption("nullBug");
            String tmp = this._args.getOpt("usePnfsManager");
            if (tmp != null && tmp.length() > 0) {
                if (tmp.equalsIgnoreCase("off") || tmp.equalsIgnoreCase("no")) {
                    this._usePnfsManager = false;
                } else if (!tmp.equalsIgnoreCase("on") && !tmp.equalsIgnoreCase("yes")) {
                    this._pnfsManagerName = tmp;
                }
            }
            if ((tmp = this._args.getOpt("pnfsManagerTimeout")) != null) {
                try {
                    this._pnfsManagerTimeout = Long.parseLong(tmp) * 1000L;
                }
                catch (NumberFormatException ee) {
                    _log.warn("Problem with argument of pnfsManagerTimeout : " + tmp);
                }
            }
            _log.info("Using PnfsManager for cacheInfo : " + this._usePnfsManager);
            if (this._usePnfsManager) {
                _log.info("Using PnfsManager Name    : " + this._pnfsManagerName);
                _log.info("Using PnfsManager Timeout : " + this._pnfsManagerTimeout);
            }
            if ((tmp = this._args.getOpt("processFilesPerRun")) != null) {
                try {
                    this._processInOnce = Integer.parseInt(tmp);
                }
                catch (NumberFormatException ee) {
                    // empty catch block
                }
            }
            _log.info("Processing " + this._processInOnce + " files per run");
            tmp = this._args.getOpt("archive");
            if (tmp != null) {
                if (tmp.equals("zip")) {
                    this._useZip = true;
                    this._useLog = false;
                } else if (tmp.equals("log")) {
                    this._useLog = true;
                    this._useZip = false;
                } else {
                    this._useLog = false;
                    this._useZip = false;
                }
            }
            _log.info("Archive method : " + (this._useZip ? "zip" : (this._useLog ? "log" : "none")));
            this._workerThread = this._nucleus.newThread((Runnable)this, "Worker");
            this._workerThread.start();
        }
        catch (Exception e) {
            _log.warn("Exception occurred while running cleaner constructor : " + e, (Throwable)e);
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    public void getInfo(PrintWriter pw) {
        pw.println("Cleaner (V2)");
        pw.println("  Version           : $Id: CleanerV2.java,v 1.23 2007-05-24 13:51:12 tigran Exp $");
        pw.println("  Db Directory      : " + this._dbDirectory);
        pw.println("  Trash Location    : " + this._dirName);
        pw.println("  Chain Location    : " + (this._moveAwayLocation == null ? "VOID" : this._moveAwayLocation.toString()));
        pw.println("  Archive method    : " + (this._useZip ? "zip" : (this._useLog ? "log" : "none")));
        pw.println("  Refresh interval  : " + this._refreshInterval);
        pw.println("  ReplyTimeout (ms) : " + this._replyTimeout);
        pw.println("  Report Remove to  : " + (this._broadcastCellName == null ? "none" : this._broadcastCellName));
        pw.println("  Started           : " + this._started);
        pw.println("  Loops             : " + this._loopCounter);
        pw.println("  Files removed     : " + this._removeCounter + " / " + this._unremoveCounter);
        pw.println("  Process per r-run : " + this._processInOnce + " / " + this._summaryErrorCounters);
        pw.println("  Global Lock       : " + (this._globalLock.exists() ? "set" : "released"));
        pw.println("  Recover Timer     : " + (this._recoverTimer == 0L ? "DISABLED" : this._recoverTimer / 1000L / 60L + " Min"));
        if (this._recoverTimer > 0L) {
            pw.println("  Next Recover Run  : " + (this._recoverTimer - (System.currentTimeMillis() - this._previousRecoverRun)) / 60000L + " Minutes");
        }
        pw.println("  Use Pnfs Manager  : " + this._usePnfsManager);
        if (this._usePnfsManager) {
            pw.println("  PnfsManager Name     : " + this._pnfsManagerName);
            pw.println("  PnfsManager Timeout  : " + this._pnfsManagerTimeout);
        }
    }

    public String toString() {
        return "Removed=" + this._removeCounter + ";X=" + this._exceptionCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String autodetectTrash() throws Exception {
        File pnfsSetup = new File("/usr/etc/pnfsSetup");
        if (!pnfsSetup.exists()) {
            throw new Exception("Not a pnfsServer");
        }
        if (!pnfsSetup.canRead()) {
            throw new Exception("Can't read pnfsSetup file");
        }
        BufferedReader br = new BufferedReader(new FileReader(pnfsSetup));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "=");
                try {
                    String key = st.nextToken();
                    String value = st.nextToken();
                    if (!key.equals("trash") || value.length() <= 0) continue;
                    String string = value + "/2";
                    return string;
                }
                catch (Exception ee) {}
            }
            throw new Exception("'trash' not found in pnfsSetup");
        }
        catch (EOFException eof) {
            throw new Exception("'trash' not found in pnfsSetup");
        }
        finally {
            try {
                br.close();
            }
            catch (Exception eeee) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTrash() throws IOException {
        block17: {
            BufferedReader br = new BufferedReader(new FileReader(this._currentRemoveList));
            String line = null;
            block11: while (true) {
                while (true) {
                    block16: {
                        try {
                            line = br.readLine();
                            if (line == null) {
                            }
                            break block16;
                        }
                        catch (IOException ioe) {
                            _log.warn("Io Exception at : " + line + " : " + ioe);
                        }
                        break block17;
                    }
                    try {
                        boolean success;
                        StringTokenizer st = new StringTokenizer(line);
                        String pnfsId = st.nextToken();
                        if (this._moveAwayLocation != null) {
                            success = new File(this._trashLocation, pnfsId).renameTo(new File(this._moveAwayLocation, pnfsId));
                            _log.info("Moving : " + pnfsId + " " + success);
                        } else {
                            success = new File(this._trashLocation, pnfsId).delete();
                            _log.info("Removing : " + pnfsId + " " + success);
                        }
                        if (!this._usePnfsManager || !this._cleanUpAfterwards) continue block11;
                        this.clearAllCacheLocations(new PnfsId(pnfsId));
                    }
                    catch (Exception ee) {
                        _log.warn("clearTrash : Problem " + line + " : " + ee);
                    }
                }
                break;
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informBroadcaster() {
        String broadcast = this._broadcastCellName;
        if (broadcast == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this._currentRemoveList));
            String line = null;
            try {
                while (true) {
                    block20: {
                        try {
                            line = br.readLine();
                            if (line == null) {
                            }
                            break block20;
                        }
                        catch (IOException ioe) {
                            _log.warn("Io Exception at : " + line + " : " + ioe);
                        }
                        break;
                    }
                    try {
                        StringTokenizer st = new StringTokenizer(line);
                        list.add(st.nextToken());
                    }
                    catch (Exception ee) {
                        _log.warn("clearTrash : Problem " + line + " : " + ee);
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException eee) {}
                }
            }
        }
        catch (IOException ioe) {
            _log.warn("I/O problems with " + this._currentRemoveList + " : " + ioe);
            return;
        }
        if (list.size() == 0) {
            return;
        }
        String[] fileList = list.toArray(new String[list.size()]);
        PoolRemoveFilesMessage msg = new PoolRemoveFilesMessage(broadcast);
        msg.setFiles(fileList);
        msg.setReplyRequired(false);
        try {
            this.sendMessage(new CellMessage(new CellPath(broadcast), (Object)msg));
        }
        catch (Exception ee) {
            _log.warn("Problems sending 'remove files' message to " + broadcast + " : " + ee.getMessage(), (Throwable)ee);
        }
    }

    public String ac_set_moveawaylocation_$_1(Args args) {
        String loc = args.argv(0);
        if (loc.equals("") || loc.equals("void")) {
            this._moveAwayLocation = null;
            return "Move Away feature disabled";
        }
        File f = new File(loc);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("Not a directory : " + f);
        }
        this._moveAwayLocation = f;
        return "New move away location : " + f;
    }

    public String ac_scantrash(Args args) throws Exception {
        this.createSummary();
        return "";
    }

    public String ac_cleartrash(Args args) throws Exception {
        this.clearTrash();
        return "";
    }

    public String ac_split(Args args) throws Exception {
        this.split();
        return "";
    }

    public String ac_rundelete(Args args) throws Exception {
        this.runDelete(this.getPoolFiles());
        return "";
    }

    public String ac_lock_$_1(Args args) throws Exception {
        String command = args.argv(0);
        if (command.equals("get")) {
            this.getGlobalLock();
            return "Lock granted";
        }
        if (command.equals("release")) {
            this.releaseGlobalLock();
            return "Lock released";
        }
        if (command.equals("check")) {
            return "Lock " + (this._globalLock.exists() ? "set" : "not set");
        }
        throw new CommandSyntaxException("Syntax Error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_set_refresh_$_0_1(Args args) {
        if (args.argc() > 0) {
            long newRefresh = Long.parseLong(args.argv(0)) * 1000L;
            if (newRefresh < 5000L) {
                throw new IllegalArgumentException("Time must be greater than 5");
            }
            this._refreshInterval = newRefresh;
        }
        if (args.hasOption("wakeup")) {
            Object object = this._sleepLock;
            synchronized (object) {
                this._sleepLock.notifyAll();
            }
        }
        return "Refresh set to " + this._refreshInterval / 1000L + " seconds";
    }

    public String ac_set_recover_$_1(Args args) {
        long newRefresh = Long.parseLong(args.argv(0)) * 1000L * 60L;
        if (newRefresh < 0L) {
            throw new IllegalArgumentException("Time must be greater >= 0");
        }
        this._recoverTimer = newRefresh;
        if (this._recoverTimer > 0L) {
            return "Recover Timer set to " + this._recoverTimer / 60000L + " minutes";
        }
        return "Recover disabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_reactivate_$_0_1(Args args) throws Exception {
        boolean all = args.hasOption("a");
        if (!all && args.argc() < 1 || all && args.argc() > 0) {
            throw new CommandSyntaxException("Not enough or inconsistent arguments");
        }
        if (all) {
            this.getGlobalLock();
            try {
                this.reactivate();
            }
            finally {
                this.releaseGlobalLock();
            }
        }
        String poolName = args.argv(0);
        File failedFile = new File(this._currentDir, "failed." + poolName);
        if (!failedFile.exists()) {
            throw new IllegalArgumentException("Failed pool file not found for " + poolName);
        }
        this.getGlobalLock();
        try {
            this.reactivate(failedFile);
        }
        finally {
            this.releaseGlobalLock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_scan(Args args) throws Exception {
        if (!args.hasOption("force")) {
            this.getGlobalLock();
        }
        try {
            this.runNextCheck(args.hasOption("init"));
        }
        finally {
            this.releaseGlobalLock();
        }
        return "";
    }

    public void cleanUp() {
        _log.warn("Clean up called");
        if (this._workerThread != null) {
            this._workerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean moreFilesToProcess = false;
        int i = 0;
        while (!Thread.interrupted()) {
            block16: {
                ++this._loopCounter;
                if (!moreFilesToProcess) {
                    try {
                        Object object = this._sleepLock;
                        synchronized (object) {
                            this._sleepLock.wait(this._refreshInterval);
                        }
                    }
                    catch (InterruptedException ie) {
                        _log.warn("Worker thread interrupted");
                        break;
                    }
                }
                try {
                    this.getGlobalLock();
                }
                catch (Exception ee) {
                    _log.warn("Problem in getting global lock : " + ee.getMessage());
                    break block16;
                }
                try {
                    if (this._recoverTimer > 0L && System.currentTimeMillis() - this._previousRecoverRun > this._recoverTimer) {
                        this.reactivate();
                        this._previousRecoverRun = System.currentTimeMillis();
                    }
                    moreFilesToProcess = this.runNextCheck(true);
                }
                catch (Exception ee) {
                    _log.warn("runNextCheck : " + ee);
                    ee.printStackTrace();
                }
                finally {
                    this.releaseGlobalLock();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelete(String[] poolFileList) {
        if (poolFileList == null) {
            return;
        }
        for (int i = 0; i < poolFileList.length && !Thread.interrupted(); ++i) {
            String thisFile = poolFileList[i];
            _log.info("runDelete : processing : " + thisFile);
            String thisPool = this.getPoolName(thisFile);
            if (thisPool == null) continue;
            BufferedReader br = null;
            File poolFile = new File(this._currentDir, thisFile);
            ArrayList<String> list = new ArrayList<String>();
            String line = null;
            try {
                br = new BufferedReader(new FileReader(poolFile));
            }
            catch (FileNotFoundException ee) {
                _log.warn("Can't open : " + thisFile);
                continue;
            }
            try {
                while (true) {
                    block24: {
                        try {
                            line = br.readLine();
                            if (line == null) {
                            }
                            break block24;
                        }
                        catch (Exception ee) {
                            _log.warn("Problem in reading : " + thisFile + " : " + ee);
                        }
                        break;
                    }
                    list.add(line.trim());
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException eee) {}
                }
            }
            _log.info("runDelete : list for " + thisPool + " : " + list);
            this._removeCounter += list.size();
            String[] notRemoved = this.sendRemoveToPool(thisPool, list);
            if (notRemoved != null && notRemoved.length > 0) {
                this._unremoveCounter += notRemoved.length;
                _log.info("runDelete : sendRemoveToPool returned " + thisPool + " : " + notRemoved.length);
                File removeFile = new File(this._currentDir, "failed." + thisPool);
                PrintWriter rpw = null;
                try {
                    rpw = new PrintWriter(new FileWriter(removeFile.getAbsolutePath(), true));
                    try {
                        for (int j = 0; j < notRemoved.length; ++j) {
                            rpw.println(notRemoved[j].trim());
                        }
                        rpw.flush();
                    }
                    finally {
                        if (rpw != null) {
                            rpw.close();
                        }
                    }
                }
                catch (Exception eee) {
                    _log.warn("Can't create removefile : " + removeFile + " : " + eee);
                }
            }
            poolFile.delete();
        }
    }

    private boolean runNextCheck(boolean init) throws Exception {
        int state = 0;
        String[] poolFileList = null;
        if (init) {
            poolFileList = this.getPoolFiles();
            if (poolFileList != null && poolFileList.length > 0) {
                state = 3;
                _log.info("runNextCheck : found pool files (->RUN_DELETE)");
            } else if (this._currentRemoveList.exists()) {
                state = 1;
                _log.info("runNextCheck : found remove list (->CLEAR_TRASH)");
            } else {
                state = 0;
            }
        }
        switch (state) {
            case 0: {
                int count = this.createSummary();
                if (count <= 0) {
                    return false;
                }
                _log.info("runNextCheck: createSummary collected " + count + " files");
                _log.info("runNextCheck: informing Broadcaster");
                this.informBroadcaster();
            }
            case 1: {
                _log.info("runNextCheck: clearing Trash");
                this.clearTrash();
            }
            case 2: {
                _log.info("runNextCheck: splitting summary");
                this.split();
                poolFileList = this.getPoolFiles();
                _log.info("runNextCheck: got poollist : " + (poolFileList == null ? "NULL" : "" + poolFileList.length));
            }
            case 3: {
                _log.info("runNextCheck: runningDelete");
                this.runDelete(poolFileList);
            }
        }
        return true;
    }

    private String[] getPoolFiles() {
        return this._currentDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("pool.");
            }
        });
    }

    private String[] getFailedFiles() {
        return this._currentDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("failed.");
            }
        });
    }

    private String getPoolName(String filename) {
        int pos = filename.indexOf(46);
        if (pos < 0 || pos + 1 == filename.length()) {
            return null;
        }
        return filename.substring(pos + 1);
    }

    private void reactivate() throws Exception {
        String[] failedFiles = this.getFailedFiles();
        for (int i = 0; i < failedFiles.length; ++i) {
            try {
                _log.info("Reactivating : " + failedFiles[i]);
                this.reactivate(new File(this._currentDir, failedFiles[i]));
                continue;
            }
            catch (Exception e) {
                _log.warn("Problem reactivating : " + failedFiles[i] + " : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reactivate(File failedFile) throws Exception {
        File parentFile = failedFile.getParentFile();
        String poolName = this.getPoolName(failedFile.getName());
        File tmpFailed = new File(parentFile, "$failed." + poolName);
        File tmpRetry = new File(parentFile, "$retry." + poolName);
        PrintWriter failed = null;
        PrintWriter retry = null;
        BufferedReader br = new BufferedReader(new FileReader(failedFile));
        int remainingFiles = 0;
        try {
            String line;
            retry = new PrintWriter(new FileWriter(tmpRetry));
            try {
                line = null;
                HashSet<String> set = new HashSet<String>(100);
                while ((line = br.readLine()) != null && set.size() < 100) {
                    String pnfsid = line.trim();
                    new PnfsId(pnfsid);
                    set.add(pnfsid);
                }
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    retry.println(i.next().toString());
                }
            }
            finally {
                try {
                    retry.close();
                }
                catch (Exception d4) {}
            }
            failed = new PrintWriter(new FileWriter(tmpFailed));
            try {
                line = null;
                while ((line = br.readLine()) != null) {
                    failed.println(line);
                    ++remainingFiles;
                }
            }
            finally {
                try {
                    failed.close();
                }
                catch (Exception d4) {}
            }
        }
        catch (Exception rm) {
            tmpRetry.delete();
            tmpFailed.delete();
        }
        finally {
            try {
                br.close();
            }
            catch (Exception d4) {}
        }
        failedFile.delete();
        if (remainingFiles > 0) {
            tmpFailed.renameTo(failedFile);
        } else {
            tmpFailed.delete();
        }
        tmpRetry.renameTo(new File(parentFile, "pool." + poolName));
    }

    private String[] sendRemoveToPool(String poolName, List<String> removeList) {
        PoolRemoveFilesMessage msg = new PoolRemoveFilesMessage(poolName);
        String[] pnfsList = removeList.toArray(new String[removeList.size()]);
        if (this._nullBug) {
            Iterator<String> i = removeList.iterator();
            while (i.hasNext()) {
                if (i.next() != null) continue;
                _log.warn("sendRemoveToPool : nullBug : null in original list");
            }
            int n = pnfsList.length;
            for (int j = 0; j < n; ++j) {
                if (pnfsList[j] != null) continue;
                _log.warn("sendRemoveToPool : nullBug : null in copied list");
            }
        }
        msg.setFiles(pnfsList);
        CellMessage cellMessage = new CellMessage(new CellPath(poolName), (Object)msg);
        try {
            cellMessage = this.sendAndWait(cellMessage, this._replyTimeout);
        }
        catch (Exception ee) {
            return pnfsList;
        }
        if (cellMessage == null) {
            _log.warn("sendRemoveToPool : remove message to " + poolName + " timed out");
            return pnfsList;
        }
        Object reply = cellMessage.getMessageObject();
        if (reply == null) {
            _log.warn("sendRemoveToPool : reply message from " + poolName + " didn't contain messageObject");
            return pnfsList;
        }
        if (!(reply instanceof PoolRemoveFilesMessage)) {
            _log.warn("sendRemoveToPool : got unexpected reply class : " + reply.getClass().getName());
            return pnfsList;
        }
        PoolRemoveFilesMessage prfm = (PoolRemoveFilesMessage)reply;
        if (prfm.getReturnCode() == 0) {
            _log.info("sendRemoveToPool : all files removed from " + poolName);
            return null;
        }
        Object o = prfm.getErrorObject();
        if (o instanceof String[]) {
            String[] notRemoved = (String[])o;
            _log.warn("sendRemoveToPool : " + notRemoved.length + " files couldn't be removed from " + poolName);
            return notRemoved;
        }
        if (o == null) {
            _log.warn("sendRemoveToPool : reply from " + poolName + " [null]");
            return pnfsList;
        }
        _log.warn("sendRemoveToPool : reply from " + poolName + " [" + o.getClass().getName() + "]=" + o.toString());
        return pnfsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split() throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this._currentRemoveList));
        HashMap<String, File> hash = new HashMap<String, File>();
        try {
            String line;
            block9: while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String pnfsId = st.nextToken();
                while (true) {
                    if (!st.hasMoreTokens()) continue block9;
                    String pool = st.nextToken();
                    File f = (File)hash.get(pool);
                    if (f == null) {
                        f = new File(this._currentDir, "pool." + pool);
                        hash.put(pool, f);
                        f.delete();
                    }
                    PrintWriter pw = null;
                    try {
                        pw = new PrintWriter(new FileWriter(f.getAbsolutePath(), true));
                    }
                    catch (IOException ioe) {
                        _log.warn("Couldn't write to : " + f.getAbsolutePath() + " : " + ioe);
                        continue;
                    }
                    pw.println(pnfsId);
                    pw.flush();
                    pw.close();
                }
                break;
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
            this._currentRemoveList.delete();
        }
    }

    private int createSummary() throws Exception {
        FileOutputStream out1 = null;
        OutputStream out2 = null;
        String zipFileName = "removes." + System.currentTimeMillis() + ".gz";
        File zipfile = new File(this._archive, "$" + zipFileName);
        File removeList = new File(this._currentDir, "$removeList");
        File logFile = new File(this._archive, _formatter.format(new Date()));
        int count = 0;
        try {
            out1 = new FileOutputStream(removeList);
            try {
                if (this._useZip) {
                    out2 = new GZIPOutputStream(new FileOutputStream(zipfile));
                } else if (this._useLog) {
                    out2 = new FileOutputStream(logFile, true);
                }
            }
            catch (Exception iozip) {
                try {
                    ((OutputStream)out1).close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw iozip;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new OutputStreamWriter(new DuplicatedOutputStream(out1, out2)));
                count = this.createSummary(pw);
            }
            catch (Exception ioe) {
                throw ioe;
            }
            finally {
                try {
                    pw.close();
                }
                catch (Exception ee) {}
            }
        }
        catch (Exception fex) {
            if (this._useZip) {
                zipfile.delete();
            }
            removeList.delete();
            throw fex;
        }
        if (count == 0) {
            if (this._useZip) {
                zipfile.delete();
            }
            removeList.delete();
        } else {
            if (this._useZip) {
                zipfile.renameTo(new File(this._archive, zipFileName));
            }
            removeList.renameTo(this._currentRemoveList);
        }
        return count;
    }

    private int createSummary(PrintWriter pw) {
        String[] fileList = this._trashLocation.list(new FilenameFilter(){
            int counter = 0;

            @Override
            public boolean accept(File dir, String name) {
                if (this.counter > CleanerV2.this._processInOnce) {
                    return false;
                }
                try {
                    new PnfsId(name);
                }
                catch (Exception e) {
                    return false;
                }
                ++this.counter;
                return true;
            }
        });
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ee) {
            // empty catch block
        }
        int validCounter = 0;
        int errorCounter = 0;
        for (int i = 0; i < fileList.length; ++i) {
            _log.info("Processing " + fileList[i]);
            PnfsId pnfsId = null;
            try {
                pnfsId = new PnfsId(fileList[i]);
            }
            catch (Exception pnfse) {
                _log.warn("Error in syntax of pnfsId name " + fileList[i], (Throwable)pnfse);
                continue;
            }
            try {
                HashSet<String> list = new HashSet<String>();
                if (this._usePnfsManager) {
                    this.getCacheInfoFromPnfsManager(pnfsId, list);
                }
                pw.print(pnfsId.toString());
                for (String location : list) {
                    pw.print(" ");
                    pw.print(location);
                }
                pw.println("");
                ++validCounter;
                continue;
            }
            catch (Exception ee) {
                _log.warn("Not removed : " + pnfsId + " couldn't get cacheinfo due to " + ee.getMessage());
                ++errorCounter;
            }
        }
        this._summaryErrorCounters = errorCounter;
        return validCounter;
    }

    private void clearAllCacheLocations(PnfsId pnfsId) {
        PnfsClearCacheLocationMessage pnfs = new PnfsClearCacheLocationMessage(pnfsId, "*");
        CellMessage message = new CellMessage(new CellPath(this._pnfsManagerName), (Object)pnfs);
        try {
            this.sendMessage(message);
        }
        catch (Exception ee) {
            _log.warn("Ignoring error in sending clearCacheLocation : " + ee);
        }
    }

    private void getCacheInfoFromPnfsManager(PnfsId pnfsId, Set<String> externalList) throws Exception {
        PnfsGetCacheLocationsMessage pnfs = new PnfsGetCacheLocationsMessage(pnfsId);
        CellMessage message = new CellMessage(new CellPath(this._pnfsManagerName), (Object)pnfs);
        if ((message = this.sendAndWait(message, this._pnfsManagerTimeout)) == null) {
            throw new Exception("PnfsManager request timed out for " + pnfsId);
        }
        Object obj = message.getMessageObject();
        if (!(obj instanceof PnfsGetCacheLocationsMessage)) {
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            throw new Exception("Got unexpected reply from PnfsManager " + obj.getClass().getName() + " instead of PnfsGetCacheLocationsMessage");
        }
        pnfs = (PnfsGetCacheLocationsMessage)obj;
        if (pnfs == null) {
            throw new Exception("No reply from PnfsManager for " + pnfsId);
        }
        if (pnfs.getReturnCode() != 0) {
            Object error = pnfs.getErrorObject();
            _log.warn("Got error from PnfsManager for " + pnfsId + " [" + pnfs.getReturnCode() + "] " + (error == null ? "" : error.toString()));
            return;
        }
        List locations = pnfs.getCacheLocations();
        if (locations == null) {
            _log.warn("getCacheInfoFromPnfsManager : PnfsManager replied with 'null' getCacheInfo answer for " + pnfsId);
            return;
        }
        _log.info("getCacheInfoFromPnfsManager : adding cacheinfo for " + pnfsId + " " + locations);
        externalList.addAll(locations);
    }

    public String ac_report_remove_$_1(Args args) {
        String broadcaster = args.argv(0);
        this._broadcastCellName = broadcaster.equals("off") ? null : broadcaster;
        return this._broadcastCellName == null ? "Remove report disabled" : "Sending removeReport to " + this._broadcastCellName;
    }

    public String ac_ls_failed(Args args) throws Exception {
        StringBuffer sb = new StringBuffer();
        boolean detail = args.hasOption("l");
        boolean more = args.hasOption("a");
        detail = more ? true : detail;
        String[] poolFileList = this._currentDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("failed.");
            }
        });
        for (int i = 0; i < poolFileList.length; ++i) {
            HashSet<String> hash = new HashSet<String>();
            int count = 0;
            String line = null;
            sb.append(Formats.field((String)poolFileList[i], (int)18, (int)2));
            if (detail) {
                File f = new File(this._currentDir, poolFileList[i]);
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(f));
                }
                catch (Exception ee) {
                    sb.append(" Can't open : ").append(f).append("\n");
                    continue;
                }
                while ((line = br.readLine()) != null) {
                    ++count;
                    if (!more) continue;
                    hash.add(line.trim());
                }
                try {
                    br.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                sb.append(" ").append(Formats.field((String)("" + count), (int)5, (int)4));
                if (more) {
                    sb.append(" ").append(Formats.field((String)("" + hash.size()), (int)5, (int)4));
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private synchronized void releaseGlobalLock() {
        this._globalLock.delete();
    }

    private synchronized void getGlobalLock() throws Exception {
        boolean result = this._globalLock.createNewFile();
        if (!result) {
            throw new IllegalStateException("File exists: " + this._globalLock.getAbsoluteFile());
        }
    }

    public void messageArrived(CellMessage message) {
        Object obj = message.getMessageObject();
        _log.warn("Unexpected message arrived from : " + message.getSourcePath() + " " + obj.getClass().getName() + " " + obj.toString());
    }

    private static class DuplicatedOutputStream
    extends OutputStream {
        private OutputStream _out1;
        private OutputStream _out2;

        private DuplicatedOutputStream(OutputStream out1, OutputStream out2) {
            this._out1 = out1;
            this._out2 = out2;
        }

        @Override
        public void close() {
            try {
                if (this._out2 != null) {
                    this._out2.close();
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                if (this._out1 != null) {
                    this._out1.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void flush() throws IOException {
            if (this._out2 != null) {
                this._out2.flush();
            }
            if (this._out1 != null) {
                this._out1.flush();
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (this._out1 != null) {
                this._out1.write(n);
            }
            if (this._out2 != null) {
                this._out2.write(n);
            }
        }

        @Override
        public void write(byte[] n) throws IOException {
            if (this._out1 != null) {
                this._out1.write(n);
            }
            if (this._out2 != null) {
                this._out2.write(n);
            }
        }

        @Override
        public void write(byte[] n, int offset, int len) throws IOException {
            if (this._out1 != null) {
                this._out1.write(n, offset, len);
            }
            if (this._out2 != null) {
                this._out2.write(n, offset, len);
            }
        }
    }
}

