/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.gplazma;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;
import org.dcache.auth.UserAuthBase;
import org.dcache.auth.UserPwdRecord;

class KpwdPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -5104794169722666904L;
    private String _name;
    private long _uid;
    private long _gid;
    private boolean _isDisabled;
    private String _home;
    private String _root;
    private boolean _isReadOnly;

    public KpwdPrincipal(UserAuthBase record) {
        Preconditions.checkNotNull((Object)record);
        this._name = record.Username;
        this._uid = record.UID;
        this._gid = record.GID;
        this._isDisabled = record instanceof UserPwdRecord && ((UserPwdRecord)record).isDisabled();
        this._home = record.Home;
        this._root = record.Root;
        this._isReadOnly = record.ReadOnly;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public long getUid() {
        return this._uid;
    }

    public long getGid() {
        return this._gid;
    }

    public boolean isDisabled() {
        return this._isDisabled;
    }

    public String getHome() {
        return this._home;
    }

    public String getRoot() {
        return this._root;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

