/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.gplazma;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.KAuthFile;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserAuthBase;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.UserPwdRecord;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.auth.gplazma.KpwdPrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAccountPlugin;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.globus.gsi.jaas.GlobusPrincipal;

public class KpwdPlugin
implements GPlazmaAuthenticationPlugin,
GPlazmaMappingPlugin,
GPlazmaAccountPlugin,
GPlazmaSessionPlugin {
    private static final String KPWD = "gplazma.kpwd.file";
    private final File _kpwdFile;
    private long _cacheTime;
    private KAuthFile _cacheAuthFile;

    public KpwdPlugin(Properties properties) {
        String path = properties.getProperty(KPWD, null);
        if (path == null) {
            throw new IllegalArgumentException("gplazma.kpwd.file argument must be specified");
        }
        this._kpwdFile = new File(path);
    }

    KpwdPlugin(KAuthFile file) {
        this._cacheAuthFile = file;
        this._kpwdFile = null;
    }

    private synchronized KAuthFile getAuthFile() throws AuthenticationException {
        try {
            if (this._kpwdFile != null && this._kpwdFile.lastModified() >= this._cacheTime) {
                this._cacheAuthFile = new KAuthFile(this._kpwdFile.getPath());
                this._cacheTime = System.currentTimeMillis();
            }
            return this._cacheAuthFile;
        }
        catch (IOException e) {
            String msg = String.format("failed to read %s: %s", this._kpwdFile.getName(), e.getMessage());
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        PasswordCredential password = (PasswordCredential)Iterables.getFirst((Iterable)Iterables.filter(privateCredentials, PasswordCredential.class), null);
        if (password == null) {
            throw new AuthenticationException("no username and password");
        }
        String name = password.getUsername();
        UserPwdRecord entry = this.getAuthFile().getUserPwdRecord(name);
        if (entry == null) {
            throw new AuthenticationException(name + " is unknown");
        }
        if (!(entry.isAnonymous() || entry.isDisabled() || entry.passwordIsValid(String.valueOf(password.getPassword())))) {
            throw new AuthenticationException("wrong password");
        }
        identifiedPrincipals.add(new KpwdPrincipal((UserAuthBase)entry));
        if (entry.isDisabled()) {
            throw new AuthenticationException("account is disabled");
        }
    }

    public void map(Set<Principal> principals, Set<Principal> authorizedPrincipals) throws AuthenticationException {
        KpwdPrincipal kpwd = (KpwdPrincipal)Iterables.getFirst((Iterable)Iterables.filter(principals, KpwdPrincipal.class), null);
        if (kpwd == null) {
            KAuthFile authFile = this.getAuthFile();
            String loginName = null;
            Principal principal = null;
            for (Principal p : principals) {
                if (p instanceof LoginNamePrincipal) {
                    if (loginName != null) {
                        throw new AuthenticationException(KpwdPlugin.errorMessage(principal, p));
                    }
                    loginName = p.getName();
                    continue;
                }
                if (p instanceof GlobusPrincipal) {
                    if (principal != null) {
                        throw new AuthenticationException(KpwdPlugin.errorMessage(principal, p));
                    }
                    principal = p;
                    continue;
                }
                if (!(p instanceof KerberosPrincipal)) continue;
                if (principal != null) {
                    throw new AuthenticationException(KpwdPlugin.errorMessage(principal, p));
                }
                principal = p;
            }
            if (principal == null) {
                throw new AuthenticationException("no mappable principals");
            }
            if (loginName == null && (loginName = authFile.getIdMapping(principal.getName())) == null) {
                throw new AuthenticationException("no login name");
            }
            UserAuthRecord authRecord = authFile.getUserRecord(loginName);
            if (authRecord == null) {
                throw new AuthenticationException("unknown login name: " + loginName);
            }
            if (!authRecord.hasSecureIdentity(principal.getName())) {
                throw new AuthenticationException("not allowed to login as " + loginName);
            }
            authRecord.DN = principal.getName();
            kpwd = new KpwdPrincipal((UserAuthBase)authRecord);
            authorizedPrincipals.add(principal);
        }
        authorizedPrincipals.add(kpwd);
        if (kpwd.isDisabled()) {
            throw new AuthenticationException("account disabled");
        }
        authorizedPrincipals.add((Principal)new UserNamePrincipal(kpwd.getName()));
        authorizedPrincipals.add((Principal)new UidPrincipal(kpwd.getUid()));
        authorizedPrincipals.add((Principal)new GidPrincipal(kpwd.getGid(), true));
    }

    private static String errorMessage(Principal principal1, Principal principal2) {
        String name2;
        String name1 = KpwdPlugin.nameFor(principal1);
        if (name1.equals(name2 = KpwdPlugin.nameFor(principal2))) {
            return "multiple " + name2 + " principals found";
        }
        return name1 + " and " + name2 + " principals found";
    }

    private static String nameFor(Principal principal) {
        if (principal instanceof KerberosPrincipal) {
            return "Kerberos";
        }
        if (principal instanceof GlobusPrincipal) {
            return "X509";
        }
        return principal.getClass().getSimpleName();
    }

    public void account(Set<Principal> authorizedPrincipals) throws AuthenticationException {
        KpwdPrincipal kpwd = (KpwdPrincipal)Iterables.getFirst((Iterable)Iterables.filter(authorizedPrincipals, KpwdPrincipal.class), null);
        if (kpwd != null && kpwd.isDisabled()) {
            throw new AuthenticationException("account disabled");
        }
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        KpwdPrincipal kpwd = (KpwdPrincipal)Iterables.getFirst((Iterable)Iterables.filter(authorizedPrincipals, KpwdPrincipal.class), null);
        if (kpwd == null) {
            throw new AuthenticationException("no record found");
        }
        attrib.add(new HomeDirectory(kpwd.getHome()));
        attrib.add(new RootDirectory(kpwd.getRoot()));
        attrib.add(new ReadOnly(kpwd.isReadOnly()));
    }
}

