/*
 * Decompiled with CFR 0.152.
 */
package fnal.vox.client;

import fnal.vox.security.ANAMUtil;
import fnal.vox.security.Base64;
import fnal.vox.security.CertInputStream;
import fnal.vox.security.MyANAM;
import fnal.vox.security.ReadWriteSocket;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.globus.gsi.gssapi.GSSConstants;
import org.gridforum.jgss.ExtendedGSSContext;

public class Client {
    private ReadWriteSocket rwSocket = null;
    private Socket clientSocket = null;
    private String host;
    private String id;
    private String serverDn;
    private String resource;
    private boolean isAuthorized;
    private int port;
    private MyANAM anamObject = null;
    private ExtendedGSSContext context = null;

    public Client(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.serverDn = string2;
        this.id = "";
        this.resource = "";
        this.isAuthorized = false;
    }

    private void init() throws Exception {
        this.anamObject = new MyANAM();
        System.out.println("Connecting to Host:" + this.host + " Port:" + this.port);
        this.context = this.anamObject.getGsiClientContext();
        this.clientSocket = this.anamObject.getGsiClientSocket(this.host, this.port, this.context);
        this.rwSocket = new ReadWriteSocket(this.clientSocket);
    }

    public String getId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isAuthorized() {
        return this.isAuthorized;
    }

    public X509Certificate[] generateCertChain(String[] stringArray) throws Exception {
        int n = stringArray.length;
        ANAMUtil aNAMUtil = new ANAMUtil();
        X509Certificate[] x509CertificateArray = new X509Certificate[n];
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + aNAMUtil.getOneCert(stringArray[i]);
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        CertInputStream certInputStream = new CertInputStream(string);
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates((InputStream)certInputStream);
        Iterator<? extends Certificate> iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            x509CertificateArray[n2] = (X509Certificate)iterator.next();
            ++n2;
        }
        collection.clear();
        return x509CertificateArray;
    }

    public X509Certificate generateCert(String string) {
        X509Certificate x509Certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(fileInputStream);
            Iterator<? extends Certificate> iterator = collection.iterator();
            if (iterator.hasNext()) {
                x509Certificate = (X509Certificate)iterator.next();
                String string2 = x509Certificate.getSubjectDN().getName();
                System.out.println("dn " + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return x509Certificate;
    }

    public void sendRequest(ExtendedGSSContext extendedGSSContext) throws Exception {
        this.init();
        extendedGSSContext = this.context;
        X509Certificate[] x509CertificateArray = (X509Certificate[])extendedGSSContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        this.sendRequest(x509CertificateArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(X509Certificate[] x509CertificateArray) throws Exception {
        try {
            this.init();
            String string = ((Object)this.context.getTargName()).toString();
            if (!this.serverDn.equals(string)) {
                throw new Exception("DN in context " + string + " does not match with DN in conf file " + this.serverDn);
            }
            if (!this.sendCertChain(x509CertificateArray)) {
                throw new Exception("Failed to send cert chain to the server");
            }
            this.rwSocket.sendMessage("done");
            String string2 = this.rwSocket.recvMessage();
            if (string2.equals("no")) {
                this.rwSocket.sendMessage("more");
                string2 = this.rwSocket.recvMessage();
                throw new Exception(string2);
            }
            if (string2.equals("yes")) {
                this.rwSocket.sendMessage("more");
                this.resource = string2 = this.rwSocket.recvMessage();
                this.id = string2;
            }
            this.isAuthorized = true;
        }
        finally {
            this.disposeAll();
        }
    }

    private boolean sendCertChain(X509Certificate[] x509CertificateArray) throws Exception {
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            String string = "-----BEGIN CERTIFICATE-----\n";
            byte[] byArray = x509CertificateArray[i].getEncoded();
            string = string + Base64.encodeBytes((byte[])byArray);
            string = string + "\n-----END CERTIFICATE-----\n";
            this.rwSocket.sendMessage(string);
            String string2 = this.rwSocket.recvMessage();
            if (string2.equals("more")) continue;
            return false;
        }
        return true;
    }

    private void disposeAll() {
        try {
            this.context.dispose();
            this.rwSocket.closeAll();
            this.clientSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                this.rwSocket.closeAll();
                this.clientSocket.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                try {
                    this.clientSocket.close();
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
            }
        }
    }

    public void checkLRA(ExtendedGSSContext extendedGSSContext) throws Exception {
        this.sendRequest(extendedGSSContext);
    }

    public void checkSAZ(ExtendedGSSContext extendedGSSContext) throws Exception {
        this.sendRequest(extendedGSSContext);
    }
}

