/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.openssl.PEMWriter;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;

public class CertUtil {
    static Logger logger = Logger.getLogger((String)CertUtil.class.getName());

    public static String getPEM(X509Certificate cert) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)cert);
        pemWriter.flush();
        return stringWriter.toString();
    }

    public static String getPEM(X509Certificate[] certs, int from, int to) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        int i = from;
        while (i <= to) {
            pemWriter.writeObject((Object)certs[i]);
        }
        pemWriter.flush();
        return stringWriter.toString();
    }

    public static String getPEM(X509Certificate[] certs) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        int i = 0;
        while (i < certs.length) {
            pemWriter.writeObject((Object)certs[i]);
        }
        pemWriter.flush();
        return stringWriter.toString();
    }

    public static int findClientCert(X509Certificate[] chain) {
        int i;
        for (i = chain.length - 1; i >= 0 && (chain[i].getBasicConstraints() != -1 || ((Object)chain[i].getIssuerDN()).equals(chain[i].getSubjectDN())); --i) {
        }
        if (i == chain.length) {
            logger.error((Object)"UpdatingKeymanager: invalid certificate chain, client cert missing.");
            return -1;
        }
        return i;
    }

    public static boolean keysMatch(PrivateKey key, X509Certificate certificate) {
        PublicKey pubKey = certificate.getPublicKey();
        return CertUtil.keysMatch(key, pubKey);
    }

    public static boolean keysMatch(PrivateKey key, PublicKey pubKey) {
        if (key instanceof RSAKey && pubKey instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().equals(((RSAKey)((Object)pubKey)).getModulus());
        }
        String text = !(key instanceof RSAKey) && !(pubKey instanceof RSAKey) ? "neither" : (key instanceof RSAKey ? "private key" : "public key");
        throw new IllegalArgumentException("When comparing public and private keys, only RSA keys are supported. Of the keys, " + text + " was RSA key.");
    }

    public static byte[] getExtensionBytes(X509Certificate cert, String oid) throws IOException {
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        DEROctetString valueOctets = (DEROctetString)ASN1Object.fromByteArray((byte[])bytes);
        return valueOctets.getOctets();
    }

    public static DN getUserDN(X509Certificate[] chain) throws IOException {
        int i = CertUtil.findClientCert(chain);
        if (i < 0) {
            throw new IOException("No user certificate found in proxy chain for: " + DNHandler.getSubject(chain[0]).getRFCDN());
        }
        return DNHandler.getSubject(chain[i]);
    }
}

