/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveProperties
extends Properties {
    private static final long serialVersionUID = -1735376359346160599L;

    public CaseInsensitiveProperties(Properties defaults) {
        this.loadProperties(defaults);
    }

    public CaseInsensitiveProperties() {
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key.toLowerCase());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key.toLowerCase(), defaultValue);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key.toLowerCase(), value);
    }

    @Override
    public synchronized void load(InputStream inputStream) throws IOException {
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        this.loadProperties(tempProperties);
    }

    public void loadProperties(Properties inProperties) {
        Enumeration<?> names = inProperties.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            this.setProperty(key, inProperties.getProperty(key));
        }
    }

    @Override
    public synchronized Object remove(Object keyObj) throws IllegalArgumentException {
        if (!(keyObj instanceof String)) {
            throw new IllegalArgumentException("CaseInsensitiveProperties.remove accepts only Strings as argument");
        }
        String key = (String)keyObj;
        return super.remove(key.toLowerCase());
    }

    @Override
    public Object put(String key, String value) {
        return this.setProperty(key, value);
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public synchronized boolean containsKey(String key) {
        return super.containsKey(key.toLowerCase());
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        for (String string : t.keySet()) {
            this.setProperty(string.toLowerCase(), (String)t.get(string));
        }
    }
}

