/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.security.SecurityContext;
import org.glite.security.trustmanager.ContextWrapper;
import org.glite.security.util.CaseInsensitiveProperties;
import org.glite.security.util.CertUtil;
import org.glite.security.util.DNHandler;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.KeyStoreGenerator;
import org.glite.security.util.Password;

public class UpdatingKeyManager
extends X509ExtendedKeyManager {
    static final Logger LOGGER = Logger.getLogger((String)UpdatingKeyManager.class.getName());
    char[] passwd;
    KeyStore keyStore;
    X509KeyManager managerImpl;
    long intervalSecs = -1L;
    KeyManagerFactory keyManagerFactory;
    String identityCertFile;
    String identityKeyFile;
    String identityKeyPasswd;
    String identityStoreFile;
    String identityStoreType;
    String identityStorePasswd;
    String proxyFile;
    String proxyIntervalBlob;
    PasswordFinder passwordFinder;
    Timer identityTimer = null;
    public String m_credentialFile;

    public UpdatingKeyManager(CaseInsensitiveProperties config, PasswordFinder finder) throws NoSuchAlgorithmException, CertificateException {
        this.identityCertFile = config.getProperty("sslCertFile");
        this.identityKeyFile = config.getProperty("sslKey");
        this.identityKeyPasswd = config.getProperty("sslKeyPasswd");
        this.identityStoreFile = config.getProperty("sslCertStore");
        this.identityStoreType = config.getProperty("sslCertStoreType", "JKS");
        this.identityStorePasswd = config.getProperty("sslCertStorePasswd");
        this.proxyFile = config.getProperty("gridProxyFile");
        this.proxyIntervalBlob = config.getProperty("credentialsUpdateInterval");
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.fatal((Object)("Internal: X509 key manager initialization failed: " + e.getMessage()));
            throw e;
        }
        this.passwordFinder = finder;
        try {
            this.loadKeystore();
        }
        catch (CertificateException e) {
            LOGGER.fatal((Object)("credentials loading failed: " + e.getMessage()));
            throw e;
        }
        if (this.proxyIntervalBlob != null) {
            this.intervalSecs = ContextWrapper.getIntervalSecs(this.proxyIntervalBlob);
            this.startUpdateLoop();
        }
    }

    public UpdatingKeyManager(KeyStore store, char[] pass) throws Exception {
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("UpdatingKeymanager: initialization failed because of internal error: " + e.getMessage()));
            throw e;
        }
        this.setManager(store, pass);
    }

    private void setManager(KeyStore store, char[] pass) throws CertificateException {
        this.keyStore = store;
        this.passwd = pass;
        try {
            LOGGER.debug((Object)("Setting key manager implementation with keystore: " + store + " containing aliases: " + store.aliases()));
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(store.aliases().nextElement());
            PrivateKey key = (PrivateKey)this.keyStore.getKey(store.aliases().nextElement(), pass);
            if (!CertUtil.keysMatch(key, cert)) {
                throw new CertificateException("When loading credentials, certificate and private key don't match.");
            }
            this.keyManagerFactory.init(this.keyStore, pass);
            this.managerImpl = (X509KeyManager)this.keyManagerFactory.getKeyManagers()[0];
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Credentials reading failed: " + e.getMessage()));
            throw new CertificateException(e.getMessage());
        }
    }

    void loadKeystore() throws CertificateException {
        FileInputStream istream = null;
        ByteArrayInputStream inputStream = null;
        BufferedInputStream bis = null;
        KeyStore identityStore = null;
        try {
            if (this.identityStoreFile != null) {
                LOGGER.debug((Object)("using credentials from keystore: " + this.identityStoreFile));
                this.m_credentialFile = this.identityStoreFile;
                identityStore = KeyStore.getInstance(this.identityStoreType);
                istream = new FileInputStream(this.identityStoreFile);
                if (this.identityStorePasswd != null) {
                    identityStore.load(istream, this.identityStorePasswd.toCharArray());
                    this.setManager(identityStore, this.identityStorePasswd.toCharArray());
                } else {
                    identityStore.load(istream, null);
                    this.setManager(identityStore, null);
                }
            } else if (this.identityCertFile != null && this.identityKeyFile != null) {
                LOGGER.debug((Object)("using credential cert file: " + this.identityCertFile + " and credential key file: " + this.identityKeyFile));
                this.m_credentialFile = this.identityCertFile + ", " + this.identityKeyFile;
                if (this.passwordFinder == null && this.identityKeyPasswd != null) {
                    this.passwordFinder = new Password(this.identityKeyPasswd.toCharArray());
                }
                identityStore = KeyStoreGenerator.generate(this.identityCertFile, this.identityKeyFile, this.passwordFinder, "internal");
                this.setManager(identityStore, "internal".toCharArray());
            } else {
                LOGGER.debug((Object)("proxyfile given: " + this.proxyFile));
                if (this.proxyFile == null) {
                    String proxyStream = System.getProperty("gridProxyStream");
                    if (proxyStream != null && proxyStream.length() > 0) {
                        LOGGER.debug((Object)"Loading proxy from a stream");
                        this.m_credentialFile = "(internal stream)";
                        try {
                            inputStream = new ByteArrayInputStream(proxyStream.getBytes());
                            bis = new BufferedInputStream(inputStream);
                        }
                        catch (Exception e) {
                            LOGGER.debug((Object)"Unable to load Proxy from Stream");
                        }
                    } else {
                        try {
                            LOGGER.debug((Object)"no proxyfile given, using default");
                            this.proxyFile = this.findProxy();
                            LOGGER.debug((Object)("read proxy: " + this.proxyFile));
                            this.m_credentialFile = this.proxyFile;
                            bis = new BufferedInputStream(new FileInputStream(this.proxyFile));
                        }
                        catch (Exception e) {
                            LOGGER.debug((Object)"Credetials loading failed, no credentials defined and default credentials couldn't be found");
                            throw new CertificateException("Credetials loading failed, no credentials defined and default credentials couldn't be found");
                        }
                    }
                } else {
                    this.m_credentialFile = this.proxyFile;
                    bis = new BufferedInputStream(new FileInputStream(this.proxyFile));
                }
                FileCertReader reader = new FileCertReader();
                identityStore = reader.readProxy(bis, "internal");
                this.setManager(identityStore, "internal".toCharArray());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Identity reading failed: " + e.getMessage()));
            throw new CertificateException(e.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            sc = new SecurityContext();
            SecurityContext.setCurrentContext(sc);
        }
        if (issuers != null) {
            sc.setPeerCas(issuers);
        }
        String alias = this.managerImpl.chooseClientAlias(keyType, issuers, null);
        LOGGER.debug((Object)("UpdatingKeyManager.chooseEngineClientAlias: alias is=" + alias));
        return alias;
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            sc = new SecurityContext();
            SecurityContext.setCurrentContext(sc);
        }
        if (issuers != null) {
            sc.setPeerCas(issuers);
        }
        String alias = this.managerImpl.chooseServerAlias(keyType, issuers, null);
        LOGGER.debug((Object)("UpdatingKeyManager.chooseEngineServerAlias: alias is=" + alias));
        return alias;
    }

    public String chooseClientAlias(String[] str, Principal[] principal, Socket socket) {
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            sc = new SecurityContext();
            SecurityContext.setCurrentContext(sc);
        }
        if (principal != null) {
            sc.setPeerCas(principal);
        }
        if (LOGGER.isDebugEnabled()) {
            int n;
            LOGGER.debug((Object)"types are:");
            for (n = 0; n < str.length; ++n) {
                LOGGER.debug((Object)str[n]);
            }
            if (principal != null) {
                LOGGER.debug((Object)"principals are:");
                for (n = 0; n < principal.length; ++n) {
                    LOGGER.debug((Object)DNHandler.getDN(principal[n]));
                }
            } else {
                LOGGER.debug((Object)"no principals received");
            }
            LOGGER.debug((Object)("socket is: " + socket));
            LOGGER.debug((Object)("UpdatingKeyManager.chooseClientAlias: ks=" + this.managerImpl));
        }
        String alias = this.managerImpl.chooseClientAlias(str, principal, socket);
        LOGGER.debug((Object)("UpdatingKeyManager.chooseClientAlias: alias is=" + alias));
        return alias;
    }

    public String chooseServerAlias(String str, Principal[] principal, Socket socket) {
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            sc = new SecurityContext();
            SecurityContext.setCurrentContext(sc);
        }
        if (principal != null) {
            sc.setPeerCas(principal);
        }
        String alias = this.managerImpl.chooseServerAlias(str, principal, socket);
        LOGGER.debug((Object)("UpdatingKeyManager.chooseServerAlias: type=" + str + " issuers=" + principal + " socket=" + socket + " alias is=" + alias));
        return alias;
    }

    public X509Certificate[] getCertificateChain(String str) {
        X509Certificate[] chain = this.managerImpl.getCertificateChain(str);
        LOGGER.debug((Object)("alias=" + str + " DN is = " + (chain == null ? null : chain[0].getSubjectDN())));
        return chain;
    }

    public String[] getClientAliases(String str, Principal[] principal) {
        String[] aliases = this.managerImpl.getClientAliases(str, principal);
        if (LOGGER.isDebugEnabled()) {
            String list = "";
            if (aliases != null) {
                for (int i = 0; i < aliases.length; ++i) {
                    list = list + aliases[i];
                    list = list + ", ";
                }
            } else {
                list = "none";
            }
            LOGGER.debug((Object)("UpdatingKeyManager.getClientAliases: type=" + str + " issuers=" + principal + " aliases are=" + list));
        }
        return aliases;
    }

    public PrivateKey getPrivateKey(String str) {
        PrivateKey key = this.managerImpl.getPrivateKey(str);
        LOGGER.debug((Object)("UpdatingKeyManager.getPrivateKey: alias= " + str + " key " + key == null ? "not found." : "found."));
        return key;
    }

    public String[] getServerAliases(String str, Principal[] principal) {
        String[] aliases = this.managerImpl.getServerAliases(str, principal);
        if (LOGGER.isDebugEnabled()) {
            String list = "";
            if (aliases != null) {
                for (int i = 0; i < aliases.length; ++i) {
                    list = list + aliases[i];
                    list = list + ", ";
                }
            } else {
                list = "none";
            }
            LOGGER.debug((Object)("UpdatingKeyManager.getServerAliases: type=" + str + " issuers=" + principal + " aliases are=" + list));
        }
        return aliases;
    }

    void startUpdateLoop() {
        if (this.intervalSecs > 0L) {
            this.identityTimer = new Timer(true);
            this.identityTimer.schedule((TimerTask)new RefreshIdentity(), 0L, this.intervalSecs * 1000L);
        }
    }

    void stop() {
        if (this.identityTimer != null) {
            this.identityTimer.cancel();
            this.identityTimer = null;
        }
    }

    public String findProxy() throws IOException {
        String uid;
        File tmpDir;
        try {
            String proxyFileSystem = System.getProperty("X509_USER_PROXY");
            if (proxyFileSystem != null) {
                return proxyFileSystem;
            }
            proxyFileSystem = System.getProperty("X509_PROXY_FILE");
            if (proxyFileSystem != null) {
                return proxyFileSystem;
            }
            tmpDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                LOGGER.fatal((Object)("directory " + tmpDir + " not found for default proxy loading"));
                throw new IOException("directory " + tmpDir + " not found for default proxy loading");
            }
            uid = System.getProperty("UID");
            if (uid == null) {
                LOGGER.fatal((Object)"No credentials defined and couldn't discover user uid for the proxy loading");
                throw new NoSuchFieldError("No credentials defined and couldn't discover user uid for the proxy loading");
            }
        }
        catch (IOException e) {
            LOGGER.fatal((Object)("Proxy file finding failed: " + e.getMessage()));
            throw new IOException("Proxy file finding failed: " + e.getMessage());
        }
        return tmpDir.getAbsolutePath() + File.separator + "x509up_u" + uid;
    }

    public String toString() {
        if (this.managerImpl == null) {
            return "UpdatingKeyManager (uninitialized) [" + super.toString() + "]";
        }
        return "UpdatingKeyManager [" + this.managerImpl.getCertificateChain(null)[0].toString() + "]";
    }

    class RefreshIdentity
    extends TimerTask {
        RefreshIdentity() {
        }

        public void run() {
            LOGGER.debug((Object)"refreshing credentials.\n");
            try {
                UpdatingKeyManager.this.loadKeystore();
            }
            catch (Exception e) {
                LOGGER.fatal((Object)"Credentials reload failed");
                throw new RuntimeException("Credentials reload failed");
            }
        }

        public String toString() {
            return "UpdatingKeyManager.RefreshIdentity timer task" + super.toString();
        }
    }
}

