/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.glite.security.SecurityContext;
import org.glite.security.trustmanager.CRLCertChecker;
import org.glite.security.trustmanager.ProxyCertPathValidator;

public class CRLFileTrustManager
implements X509TrustManager {
    private static final Logger LOGGER = Logger.getLogger((String)CRLFileTrustManager.class.getName());
    ProxyCertPathValidator validator = null;
    String crlFiles = null;
    Vector trustAnchors = null;
    Properties config = null;

    public CRLFileTrustManager(Vector trustAnchors) throws CertificateException, NoSuchProviderException {
        this.validator = new ProxyCertPathValidator(trustAnchors);
    }

    public void setChecker(PKIXCertPathChecker cheker) {
        this.validator.setCRLChecker((CRLCertChecker)cheker);
    }

    public void checkClientTrusted(X509Certificate[] x509Certificate, String authType) throws CertificateException {
        LOGGER.debug((Object)"CRLFileTrustManager::checkClientTrusted");
        if (x509Certificate == null) {
            throw new CertificateException("No certificae given, unable to verify!");
        }
        if (this.validator == null) {
            LOGGER.fatal((Object)"Trying to use uninitialized TrustManager");
            throw new CertificateException("Trying to use uninitialized TrustManager");
        }
        SecurityContext sc = SecurityContext.getCurrentContext();
        if (sc == null) {
            sc = new SecurityContext();
            SecurityContext.setCurrentContext(sc);
        }
        sc.setUnverifiedCertChain(x509Certificate);
        List<X509Certificate> certs = Arrays.asList(x509Certificate);
        Iterator<X509Certificate> iter = certs.iterator();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"The user cert chain is:");
            while (iter.hasNext()) {
                LOGGER.debug((Object)iter.next());
            }
        }
        try {
            this.validator.check(x509Certificate);
            sc.setClientCertChain(x509Certificate);
            LOGGER.info((Object)("Client " + x509Certificate[0].getSubjectDN() + " accepted"));
        }
        catch (Exception e) {
            LOGGER.info((Object)("Client certificate validation failed for " + x509Certificate[0].getSubjectDN() + " reason: " + e.getMessage()));
            LOGGER.debug(certs);
            if (e instanceof CertificateException) {
                throw (CertificateException)e;
            }
            CertificateException newExp = new CertificateException(e.getMessage(), e);
            throw newExp;
        }
    }

    public void checkServerTrusted(X509Certificate[] x509Certificate, String authType) throws CertificateException {
        LOGGER.debug((Object)"Trustmanager is validating a server");
        LOGGER.debug((Object)"The cert chain is: ");
        this.checkClientTrusted(x509Certificate, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        LOGGER.debug((Object)"getAcceptedIssuers");
        X509Certificate[] cas = this.validator.getCACerts();
        LOGGER.debug((Object)("returning " + cas.length + " ca certs"));
        return cas;
    }
}

