/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.security.MessageDigest;
import org.dcache.ftp.BlockLog;
import org.dcache.pool.repository.RepositoryChannel;

public abstract class DigestThread
extends Thread {
    protected RepositoryChannel _channel;
    protected MessageDigest _digest;
    protected BlockLog _log;
    protected Exception _error;
    protected long _readahead;

    public DigestThread(RepositoryChannel channel, BlockLog log, MessageDigest digest) {
        this._channel = channel;
        this._log = log;
        this._digest = digest;
        this._readahead = Long.MAX_VALUE;
    }

    protected void advance(long position) throws InterruptedException {
        this._log.setLimit(this._readahead == Long.MAX_VALUE ? Long.MAX_VALUE : position + this._readahead);
        this._log.waitCompleted(position);
    }

    public void setReadAhead(long value) {
        this._readahead = value;
    }

    public long getReadAhead() {
        return this._readahead;
    }

    @Override
    public abstract void run();

    public Exception getLastError() {
        return this._error;
    }
}

