/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.text.MessageFormat;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dcache.ftp.ErrorListener;
import org.dcache.ftp.FTPException;

public class BlockLog {
    private SortedMap<Long, Long> _blocks = new TreeMap<Long, Long>();
    private boolean _eof = false;
    private static final String _overlapMsg = "Overlapping block detected between ({0}-{1}) and ({2}-{3}).";
    private ErrorListener _errorListener;
    private long _limit;

    public BlockLog(ErrorListener errorListener) {
        this._errorListener = errorListener;
        this._limit = Long.MAX_VALUE;
    }

    public synchronized void addBlock(long position, long size) throws FTPException {
        if (size == 0L) {
            return;
        }
        long begin = position;
        long end = position + size;
        SortedMap<Long, Long> headMap = this._blocks.headMap(position);
        SortedMap<Long, Long> tailMap = this._blocks.tailMap(position);
        if (!headMap.isEmpty()) {
            long prevBegin = headMap.lastKey();
            long prevEnd = (Long)this._blocks.get(prevBegin);
            if (prevEnd > begin) {
                String err = MessageFormat.format(_overlapMsg, begin, end, prevBegin, prevEnd);
                throw new FTPException(err);
            }
            if (prevEnd == begin) {
                begin = prevBegin;
                this._blocks.remove(prevBegin);
            }
        }
        if (!tailMap.isEmpty()) {
            long nextBegin = tailMap.firstKey();
            long nextEnd = (Long)this._blocks.get(nextBegin);
            if (end > nextBegin) {
                String err = MessageFormat.format(_overlapMsg, begin, end, nextBegin, nextEnd);
                throw new FTPException(err);
            }
            if (end == nextBegin) {
                end = nextEnd;
                this._blocks.remove(nextBegin);
            }
        }
        this._blocks.put(begin, end);
        this.notifyAll();
        try {
            while (this._limit <= this.getCompleted()) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void setEof() {
        this._eof = true;
        this.notifyAll();
    }

    public synchronized boolean isEof() {
        return this._eof;
    }

    public synchronized int getFragments() {
        return this._blocks.size();
    }

    public synchronized boolean isComplete() {
        return this.isEof() && this.getFragments() <= 1;
    }

    public synchronized long getCompleted() {
        return !this._blocks.containsKey(0L) ? 0L : (Long)this._blocks.get(0L);
    }

    public synchronized void waitCompleted(long position) throws InterruptedException {
        if (this._limit < position) {
            this.setLimit(position);
        }
        while (this.getCompleted() < position && !this.isEof()) {
            this.wait();
        }
    }

    public synchronized long getLimit() {
        return this._limit;
    }

    public synchronized void setLimit(long limit) {
        this._limit = limit;
        this.notifyAll();
    }
}

