/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.ProxyAdapter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import org.dcache.util.PortRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveAdapter
implements Runnable,
ProxyAdapter {
    private static final Logger _log = LoggerFactory.getLogger(ActiveAdapter.class);
    private static final int EXPECTED_KEY_SET_SIZE_WHEN_DONE = 1;
    private ServerSocketChannel _ssc;
    private String _tgtHost = null;
    private int _tgtPort = 0;
    private String _laddr = null;
    private int _lport;
    private int _maxBlockSize = 32768;
    private int _expectedStreams = 1;
    private Selector _selector = null;
    private final LinkedList<SocketChannel> _pending = new LinkedList();
    private String _error;
    private Thread _t = null;
    private boolean _closeForced = false;
    private int _streamsCreated;

    public ActiveAdapter(PortRange range, String host, int port) throws IOException {
        this._tgtHost = host;
        this._tgtPort = port;
        this._ssc = ServerSocketChannel.open();
        this._ssc.configureBlocking(false);
        range.bind(this._ssc.socket());
        this._laddr = InetAddress.getLocalHost().getHostAddress();
        this._lport = this._ssc.socket().getLocalPort();
        this._t = new Thread(this);
        this._selector = Selector.open();
    }

    @Override
    public synchronized void close() {
        this._closeForced = true;
        if (this._selector != null) {
            this._selector.wakeup();
        }
        if (!this._t.isAlive()) {
            this.closeNow();
        }
    }

    private synchronized void closeNow() {
        if (this._ssc != null) {
            try {
                this.say("Closing " + this._ssc);
                this._ssc.close();
            }
            catch (IOException e) {
                this.esay("Failed to close server socket: " + e.getMessage());
            }
            this._ssc = null;
        }
        if (this._selector != null) {
            for (SelectionKey key : this._selector.keys()) {
                if (!key.isValid() || !(key.attachment() instanceof Tunnel)) continue;
                ((Tunnel)key.attachment()).close();
            }
            try {
                this._selector.close();
            }
            catch (IOException e) {
                this.esay("Failed to close selector: " + e.getMessage());
            }
            this._selector = null;
        }
    }

    private synchronized boolean isTransferInProgress() throws IOException {
        if (this._closeForced) {
            return false;
        }
        if (this._streamsCreated < this._expectedStreams) {
            return true;
        }
        this._selector.selectNow();
        return this._selector.keys().size() > 1;
    }

    @Override
    public int getClientListenerPort() {
        return this._lport;
    }

    @Override
    public String getError() {
        return this._error;
    }

    @Override
    public int getPoolListenerPort() {
        return this._lport;
    }

    @Override
    public void setMaxBlockSize(int size) {
        this._maxBlockSize = size;
    }

    protected void say(String s) {
        _log.info("ActiveAdapter: " + s);
    }

    protected void esay(String s) {
        _log.error("ActiveAdapter: " + s);
    }

    protected void esay(Throwable t) {
        _log.error(t.getMessage(), t);
    }

    @Override
    public boolean hasError() {
        return this._error != null;
    }

    @Override
    public void setDirClientToPool() {
    }

    @Override
    public void setDirPoolToClient() {
    }

    @Override
    public void setModeE(boolean modeE) {
    }

    @Override
    public boolean isAlive() {
        return this._t.isAlive();
    }

    @Override
    public void join() throws InterruptedException {
        this._t.join();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this._t.join(millis);
    }

    @Override
    public void start() {
        this._t.start();
    }

    public String getLocalHost() {
        return this._laddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._ssc.register(this._selector, 16);
            this.say("Listening on port " + this._ssc.socket().getLocalPort());
            while (this.isTransferInProgress()) {
                int num = this._selector.select(5000L);
                Iterator<SelectionKey> selectedKeys = this._selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    try {
                        this.processSelectionKey(key);
                    }
                    catch (IOException e) {
                        key.cancel();
                        this.esay("key processing error");
                    }
                }
                this.processPending();
            }
        }
        catch (ClosedSelectorException e) {
        }
        catch (IOException ie) {
            this.esay(ie);
        }
        finally {
            this.closeNow();
        }
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
        SocketChannel sc = ssc.accept();
        this.say("New connection: " + sc);
        this.addPending(sc);
    }

    private void finishConnection(SelectionKey key) throws IOException {
        SocketChannel sc = (SocketChannel)key.channel();
        Tunnel tnl = (Tunnel)key.attachment();
        boolean success = sc.finishConnect();
        if (success) {
            this.say("New connection: " + sc);
            tnl.register(this._selector);
        } else {
            this.esay("Connection error: " + sc);
            tnl.close();
        }
    }

    public void processSelectionKey(SelectionKey key) throws IOException {
        if (key.isValid() && key.isAcceptable()) {
            this.accept(key);
        }
        if (key.isValid() && key.isConnectable()) {
            this.finishConnection(key);
        }
        if (key.isValid() && key.isReadable()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
            this.read(key);
        }
        if (key.isValid() && key.isWritable()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            this.write(key);
        }
    }

    private void read(SelectionKey key) throws IOException {
        Tunnel tnl = null;
        try {
            tnl = (Tunnel)key.attachment();
            tnl.processInput((SocketChannel)key.channel());
        }
        catch (IOException ie) {
            this.esay("Communication error");
            tnl.close();
        }
    }

    private void write(SelectionKey key) throws IOException {
        Tunnel tnl = null;
        try {
            tnl = (Tunnel)key.attachment();
            tnl.processOutput((SocketChannel)key.channel());
        }
        catch (IOException ie) {
            this.esay("Communication error");
            tnl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPending(SocketChannel s) {
        LinkedList<SocketChannel> linkedList = this._pending;
        synchronized (linkedList) {
            this._pending.add(s);
            this._pending.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPending() throws IOException {
        LinkedList<SocketChannel> linkedList = this._pending;
        synchronized (linkedList) {
            while (this._pending.size() > 0) {
                SocketChannel scs = this._pending.removeFirst();
                scs.configureBlocking(false);
                try {
                    ++this._streamsCreated;
                    SocketChannel sct = ActiveAdapter.createSocketChannel(this._tgtHost, this._tgtPort);
                    Tunnel tnl = new Tunnel(scs, sct);
                    tnl.register(this._selector);
                }
                catch (IOException ie) {
                    this.esay(ie);
                }
            }
            return;
        }
    }

    public static SocketChannel createSocketChannel(String host, int port) throws IOException {
        SocketChannel sc = SocketChannel.open();
        sc.configureBlocking(false);
        sc.connect(new InetSocketAddress(host, port));
        return sc;
    }

    private class Tunnel {
        private final SocketChannel _scs;
        private final SocketChannel _sct;
        private final ByteBuffer _sbuffer;
        private final ByteBuffer _tbuffer;

        Tunnel(SocketChannel scs, SocketChannel sct) {
            this._sbuffer = ByteBuffer.allocate(ActiveAdapter.this._maxBlockSize);
            this._tbuffer = ByteBuffer.allocate(ActiveAdapter.this._maxBlockSize);
            this._scs = scs;
            this._sct = sct;
        }

        public void register(Selector selector) throws ClosedChannelException {
            if (this._sct.isConnectionPending()) {
                this._sct.register(selector, 8, this);
            } else if (this._sct.isConnected()) {
                this._scs.register(selector, 1, this);
                this._sct.register(selector, 1, this);
            }
        }

        public void close() {
            if (ActiveAdapter.this._selector != null) {
                SelectionKey key = this._scs.keyFor(ActiveAdapter.this._selector);
                if (key != null) {
                    key.cancel();
                }
                if ((key = this._sct.keyFor(ActiveAdapter.this._selector)) != null) {
                    key.cancel();
                }
            }
            try {
                ActiveAdapter.this.say("Closing " + this._scs);
                this._scs.close();
            }
            catch (IOException ie) {
                ActiveAdapter.this.esay("Error closing channel " + this._scs + ": " + ie);
            }
            try {
                ActiveAdapter.this.say("Closing " + this._sct);
                this._sct.close();
            }
            catch (IOException ie) {
                ActiveAdapter.this.esay("Error closing channel " + this._sct + ": " + ie);
            }
        }

        public ByteBuffer getBuffer(SocketChannel sc) {
            if (sc == this._scs) {
                return this._sbuffer;
            }
            if (sc == this._sct) {
                return this._tbuffer;
            }
            return null;
        }

        public SocketChannel getMate(SocketChannel sc) {
            if (sc == this._scs) {
                return this._sct;
            }
            if (sc == this._sct) {
                return this._scs;
            }
            return null;
        }

        private void processInput(SocketChannel scs) throws IOException {
            SocketChannel sct = this.getMate(scs);
            ByteBuffer b = this.getBuffer(scs);
            b.clear();
            int r = scs.read(b);
            if (r < 0) {
                ActiveAdapter.this.say("EOF on channel " + scs + ", shutting down output of " + sct);
                sct.socket().shutdownOutput();
                if (scs.socket().isOutputShutdown()) {
                    this.close();
                }
            } else if (r > 0) {
                b.flip();
                this.processOutput(sct);
            } else {
                SelectionKey key = scs.keyFor(ActiveAdapter.this._selector);
                key.interestOps(key.interestOps() | 1);
            }
        }

        private void processOutput(SocketChannel sct) throws IOException {
            SocketChannel scs = this.getMate(sct);
            ByteBuffer b = this.getBuffer(scs);
            sct.write(b);
            if (b.hasRemaining()) {
                SelectionKey key = sct.keyFor(ActiveAdapter.this._selector);
                key.interestOps(key.interestOps() | 4);
            } else {
                SelectionKey key = scs.keyFor(ActiveAdapter.this._selector);
                key.interestOps(key.interestOps() | 1);
            }
        }

        public String toString() {
            return this._scs.toString() + "<->" + this._sct.toString();
        }
    }
}

