/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.movers;

import diskCacheV111.movers.GFtpPerfMarker;

public class GFtpPerfMarkersBlock {
    private int count;
    private GFtpPerfMarker[] markers;

    public int getLength() {
        return this.markers == null ? 0 : this.markers.length;
    }

    public GFtpPerfMarker[] getGFtpPerfMarkers() {
        return this.markers;
    }

    public GFtpPerfMarker markers(int idx) throws IllegalArgumentException {
        if (idx < 0 || idx > this.markers.length) {
            throw new IllegalArgumentException();
        }
        return this.markers[idx];
    }

    public GFtpPerfMarkersBlock() {
        this.clear();
    }

    public GFtpPerfMarkersBlock(int length) {
        this.createNewBlock(length);
    }

    private void createNewBlock(int length) {
        if (length > 0) {
            this.count = length;
            this.markers = new GFtpPerfMarker[length];
            for (int jStripe = 0; jStripe < length; ++jStripe) {
                this.markers[jStripe] = new GFtpPerfMarker(jStripe, length);
            }
        } else {
            this.clear();
        }
    }

    GFtpPerfMarkersBlock(GFtpPerfMarkersBlock pm) {
        int length = pm.getLength();
        this.count = pm.getCount();
        int n = this.count = this.count < length ? this.count : length;
        if (pm.markers != null) {
            this.markers = new GFtpPerfMarker[length];
            for (int jStripe = 0; jStripe < length; ++jStripe) {
                this.markers[jStripe] = new GFtpPerfMarker(jStripe, pm.count);
                this.markers[jStripe].setBytesWithTime(pm.markers[jStripe].getstripeBytesTransferred(), pm.markers[jStripe].getTimeStamp());
            }
        } else {
            this.clear();
        }
    }

    public void setCount(int c) {
        this.count = this.markers != null ? (c < this.markers.length ? c : this.markers.length) : 0;
    }

    public int getCount() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.markers = null;
    }
}

