/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.AbstractFtpDoorV1;
import diskCacheV111.doors.FTPTransactionLog;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import dmg.util.Args;
import dmg.util.CommandExitException;
import dmg.util.StreamEngine;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.Subjects;

public class WeakFtpDoorV1
extends AbstractFtpDoorV1 {
    private String _user;

    public WeakFtpDoorV1(String name, StreamEngine engine, Args args) throws InterruptedException, ExecutionException {
        super(name, engine, args);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.ftpDoorName = "Weak FTP";
    }

    @Override
    protected void secure_reply(String answer, String code) {
    }

    @Override
    public void ac_auth(String arg) {
        this.reply("500 Not Supported");
    }

    @Override
    public void ac_adat(String arg) {
        this.reply("500 Not Supported");
    }

    @Override
    public void secure_command(String arg, String sectype) throws CommandExitException {
    }

    @Override
    public void ac_user(String arg) {
        if (arg.equals("")) {
            this.println(this.err("USER", arg));
            return;
        }
        this._user = arg;
        this.println("331 Password required for " + this._user + ".");
    }

    @Override
    public void ac_pass(String arg) {
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(new PasswordCredential(this._user, arg));
        try {
            this.login(subject);
        }
        catch (PermissionDeniedCacheException e) {
            this.warn("Login denied for " + subject);
            this.println("530 Login incorrect");
        }
        catch (CacheException e) {
            this.error("Login failed for " + subject + ": " + (Object)((Object)e));
            this.println("530 Login failed: " + e.getMessage());
        }
        this.println("230 User " + this._user + " logged in");
    }

    @Override
    public void startTlog(FTPTransactionLog tlog, String path, String action) {
        if (this._subject != null) {
            try {
                String user = Subjects.getUserName((Subject)this._subject) + "(" + Subjects.getUid((Subject)this._subject) + "." + Subjects.getPrimaryGid((Subject)this._subject) + ")";
                tlog.begin(user, "weakftp", action, path, this._engine.getInetAddress());
            }
            catch (Exception e) {
                this.error("WeakFtpDoor: couldn't start tLog. Ignoring exception: " + e.getMessage());
            }
        }
    }
}

